/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class TestRunnerSettings {
    private static final String RESULTS_SPLITPANE_DIVIDER_VERTICAL = "resultsSplitDividerVertical";
    private static final String RESULTS_SPLITPANE_DIVIDER_HORIZONTAL = "resultsSplitDividerHorizontal";
    private static final String RESULTS_SPLITPANE_ORIENTATION = "resultsSplitOrientation";
    private static final int DEFAULT_DIVIDER_LOCATION_VERTICAL = 120;
    private static final int DEFAULT_DIVIDER_LOCATION_HORIZONTAL = 300;
    private static final int DEFAULT_DIVIDER_ORIENTATION = 1;
    private static final TestRunnerSettings INSTANCE = new TestRunnerSettings();

    private TestRunnerSettings() {
    }

    public static TestRunnerSettings getDefault() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(TestRunnerSettings.class);
    }

    public DividerSettings getDividerSettings(Integer orientation) {
        if (orientation == null) {
            orientation = this.getResultsSplitPaneOrientation();
        }
        return new DividerSettings(orientation, this.getResultsSplitPaneDivider(orientation));
    }

    public void setDividerSettings(DividerSettings settings) {
        this.setResultsSplitPaneOrientation(settings.getOrientation());
        this.setResultsSplitPaneDivider(settings.getLocation(), settings.getOrientation());
    }

    private int getResultsSplitPaneDivider(int orientation) {
        if (0 == orientation) {
            return this.getPreferences().getInt(RESULTS_SPLITPANE_DIVIDER_VERTICAL, 120);
        }
        return this.getPreferences().getInt(RESULTS_SPLITPANE_DIVIDER_HORIZONTAL, 300);
    }

    private void setResultsSplitPaneDivider(int dividerLocation, int orientation) {
        if (0 == orientation) {
            this.getPreferences().putInt(RESULTS_SPLITPANE_DIVIDER_VERTICAL, dividerLocation);
        } else {
            this.getPreferences().putInt(RESULTS_SPLITPANE_DIVIDER_HORIZONTAL, dividerLocation);
        }
    }

    private int getResultsSplitPaneOrientation() {
        return this.getPreferences().getInt(RESULTS_SPLITPANE_ORIENTATION, 1);
    }

    private void setResultsSplitPaneOrientation(int dividerOrientation) {
        this.getPreferences().putInt(RESULTS_SPLITPANE_ORIENTATION, dividerOrientation);
    }

    public static final class DividerSettings {
        private final int orientation;
        private final int location;

        public DividerSettings(int orientation, int location) {
            assert (orientation == 1 || orientation == 0);
            this.orientation = orientation;
            this.location = location;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getLocation() {
            return this.location;
        }
    }
}

