/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.openide.awt.GraphicsUtils;

public class CoverageBar
extends JComponent {
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color NOT_COVERED_COLOR = new Color(180, 50, 50);
    private static final Color COVERED_COLOR = new Color(30, 180, 30);
    private boolean emphasize;
    private boolean selected;
    private float coveragePercentage;
    private int totalLines;
    private int executedLines;
    private int partialLines;
    private int inferredLines;

    public CoverageBar() {
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (this.isShowing()) {
                    ToolTipManager.sharedInstance().registerComponent(this);
                } else {
                    ToolTipManager.sharedInstance().unregisterComponent(this);
                }
            }
        });
        this.updateUI();
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public void setCoveragePercentage(float coveragePercentage) {
        this.coveragePercentage = coveragePercentage;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEmphasize() {
        return this.emphasize;
    }

    public void setEmphasize(boolean emphasize) {
        this.emphasize = emphasize;
    }

    private String getString() {
        return String.format("%.2f %%", Float.valueOf(this.coveragePercentage));
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public final void updateUI() {
        Font f = new JLabel().getFont();
        f = new Font(f.getName(), 1, f.getSize());
        this.setFont(f);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height;
        int width;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        int barRectWidth = width = this.getWidth();
        int barRectHeight = height = this.getHeight();
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        int amountFull = (int)((float)barRectWidth * this.coveragePercentage / 100.0f);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        Color notCoveredDark = NOT_COVERED_COLOR;
        Color coveredDark = COVERED_COLOR;
        if (this.emphasize || this.selected) {
            coveredDark = coveredDark.darker();
            notCoveredDark = notCoveredDark.darker();
        }
        g2.setPaint(notCoveredDark);
        g2.fillRect(amountFull, 1, width - 1, height - 1);
        if (this.coveragePercentage > 0.0f) {
            g2.setColor(coveredDark);
            g2.fillRect(1, 1, amountFull, height - 1);
        }
        this.paintText(g2, barRectWidth, barRectHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        int stringHeight;
        Insets border = this.getInsets();
        FontMetrics fontSizer = this.getFontMetrics(this.getFont());
        Dimension size = new Dimension(146, 12);
        String string = this.getString();
        int stringWidth = fontSizer.stringWidth(string);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = 40;
        return pref;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = Short.MAX_VALUE;
        return pref;
    }

    @Override
    public int getBaseline(int w, int h) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return h - fm.getDescent() - (h - fm.getHeight()) / 2;
    }

    private void paintText(Graphics g, int w, int h) {
        if (this.emphasize) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(TEXT_COLOR);
        }
        g.setFont(this.getFont());
        String text = this.getString();
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        g.drawString(text, (w - textWidth) / 2, h - fm.getDescent() - (h - fm.getHeight()) / 2);
    }

    public void setStats(int totalLines, int executedLines, int partialLines, int inferredLines) {
        this.totalLines = totalLines;
        this.executedLines = executedLines;
        this.partialLines = partialLines;
        this.inferredLines = inferredLines;
    }

    @Override
    public String getToolTipText(MouseEvent arg0) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("Total Lines: ");
        sb.append(Integer.toString(this.totalLines));
        sb.append("<br>");
        sb.append("Executed Lines: ");
        sb.append(Integer.toString(this.executedLines));
        sb.append("<br>");
        if (this.partialLines >= 0) {
            sb.append("&nbsp;&nbsp;");
            sb.append("Partial Lines: ");
            sb.append(Integer.toString(this.partialLines));
            sb.append("<br>");
        }
        if (this.inferredLines >= 0) {
            sb.append("&nbsp;&nbsp;");
            sb.append("Inferred Executed Lines: ");
            sb.append(Integer.toString(this.inferredLines));
            sb.append("<br>");
        }
        sb.append("Not Executed Lines: ");
        int notExecutedLines = this.totalLines - this.executedLines;
        sb.append(Integer.toString(notExecutedLines));
        sb.append("<br>");
        return sb.toString();
    }
}

