/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.Document;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IncompatibleExecDataVersionException;
import org.jacoco.core.tools.ExecFileLoader;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.gradle.java.coverage.Bundle;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GradleCoverageProvider
implements CoverageProvider {
    private static final Logger LOG = Logger.getLogger(GradleCoverageProvider.class.getName());
    private static final String JACOCO_VERSION = "0.7.6.201602180812";
    private Set<File> reports;
    private final Map<FileObject, ISourceFileCoverage> fileCoverage = new HashMap<FileObject, ISourceFileCoverage>();
    private long lastUpdate;
    Notification versionNotification;
    boolean enabled;
    final Project project;
    private final FileChangeListener listener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            this.fireChange();
        }

        private void fireChange() {
            GradleCoverageProvider.this.readJacocoExec();
            CoverageManager.INSTANCE.resultsUpdated(GradleCoverageProvider.this.project, (CoverageProvider)GradleCoverageProvider.this);
        }
    };

    public GradleCoverageProvider(Project project) {
        this.project = project;
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAggregating() {
        return false;
    }

    public void setAggregating(boolean aggregating) {
    }

    public Set<String> getMimeTypes() {
        return Collections.singleton("text/x-java");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        GradleJavaProject gjp = GradleJavaProject.get((Project)this.project);
        if (enabled && gjp != null) {
            this.reports = gjp.getCoverageData();
            for (File report : this.reports) {
                FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)report);
            }
            this.readJacocoExec();
        } else {
            if (this.versionNotification != null) {
                this.versionNotification.clear();
                this.versionNotification = null;
            }
            if (this.reports != null) {
                for (File report : this.reports) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this.listener, (File)report);
                }
                this.reports = null;
            }
            this.fileCoverage.clear();
        }
    }

    public synchronized void clear() {
        this.fileCoverage.clear();
    }

    public FileCoverageDetails getDetails(FileObject fo, Document doc) {
        ISourceFileCoverage coverage = this.fileCoverage.get(fo);
        return coverage != null ? new GradleFileCoverageDetails(fo, coverage, this.lastUpdate) : null;
    }

    public List<FileCoverageSummary> getResults() {
        ArrayList<FileCoverageSummary> ret = new ArrayList<FileCoverageSummary>(this.fileCoverage.size());
        for (Map.Entry<FileObject, ISourceFileCoverage> entry : this.fileCoverage.entrySet()) {
            ret.add(GradleCoverageProvider.createSummary(entry.getKey(), entry.getValue()));
        }
        return ret;
    }

    public String getTestAllAction() {
        return "test";
    }

    private static FileCoverageSummary createSummary(FileObject fo, ISourceFileCoverage fileCoverage) {
        ICounter lineCounter = fileCoverage.getLineCounter();
        int lines = lineCounter.getTotalCount();
        int covered = lineCounter.getCoveredCount();
        int missed = lineCounter.getMissedCount();
        return new FileCoverageSummary(fo, fo.getNameExt(), lines, covered, 0, lines - covered - missed);
    }

    private void readJacocoExec() {
        boolean hasVersionProblem = false;
        this.lastUpdate = System.currentTimeMillis();
        ExecFileLoader loader = new ExecFileLoader();
        for (File execFile : this.reports) {
            if (!execFile.canRead()) continue;
            try {
                loader.load(execFile);
                this.lastUpdate = Math.min(this.lastUpdate, execFile.lastModified());
            }
            catch (IncompatibleExecDataVersionException vex) {
                hasVersionProblem = true;
                LOG.log(Level.INFO, "Incompatible JaCoCo execution data in: " + execFile, vex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't load JaCoCo execution details from: " + execFile, ex);
            }
        }
        this.updateVersionNotification(hasVersionProblem);
        ExecutionDataStore dataStore = loader.getExecutionDataStore();
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(dataStore, (ICoverageVisitor)builder);
        GradleJavaProject javaProject = GradleJavaProject.get((Project)this.project);
        Set testClassesRoots = javaProject.getTestClassesRoots();
        for (GradleJavaSourceSet sourceSet : javaProject.getSourceSets().values()) {
            for (File dir : sourceSet.getOutputClassDirs()) {
                if (testClassesRoots.contains(dir) || !dir.isDirectory()) continue;
                try {
                    analyzer.analyzeAll(dir);
                }
                catch (IOException iOException) {}
            }
        }
        Collection sourceFiles = builder.getSourceFiles();
        ClassPath sourceClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])((ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPath("classpath/source"));
        for (ISourceFileCoverage sourceFile : sourceFiles) {
            String fname = sourceFile.getPackageName() + "/" + sourceFile.getName();
            FileObject fo = sourceClassPath.findResource(fname);
            if (fo == null) continue;
            this.fileCoverage.put(fo, sourceFile);
        }
    }

    private void updateVersionNotification(boolean hasVersionProblem) {
        if (!hasVersionProblem && this.versionNotification != null) {
            this.versionNotification.clear();
            this.versionNotification = null;
        }
        if (hasVersionProblem && this.versionNotification == null) {
            this.versionNotification = NotificationDisplayer.getDefault().notify(Bundle.STATUS_INCOMPATIBLE(), NbGradleProject.getWarningIcon(), (JComponent)new JLabel(Bundle.STATUS_INCOMPATIBLE()), (JComponent)new JLabel(Bundle.GRADLE_HINT(JACOCO_VERSION)), NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.WARNING);
        }
    }

    private static class GradleFileCoverageDetails
    implements FileCoverageDetails {
        private static final CoverageType[] STATUS_MAP = new CoverageType[]{CoverageType.UNKNOWN, CoverageType.NOT_COVERED, CoverageType.COVERED, CoverageType.PARTIAL};
        final FileObject file;
        final ISourceFileCoverage cov;
        final long lastUpdated;

        public GradleFileCoverageDetails(FileObject file, ISourceFileCoverage cov, long lastUpdated) {
            this.file = file;
            this.cov = cov;
            this.lastUpdated = lastUpdated;
        }

        public FileObject getFile() {
            return this.file;
        }

        public int getLineCount() {
            return this.cov.getLastLine();
        }

        public boolean hasHitCounts() {
            return false;
        }

        public long lastUpdated() {
            return this.lastUpdated;
        }

        public FileCoverageSummary getSummary() {
            return GradleCoverageProvider.createSummary(this.file, this.cov);
        }

        public CoverageType getType(int lineNo) {
            ILine line = this.cov.getLine(lineNo + 1);
            return STATUS_MAP[line.getStatus()];
        }

        public int getHitCount(int lineNo) {
            return 1;
        }
    }
}

