/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.BranchMapping;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class FetchBranchesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private String fetchUri;
    private GitRemoteConfig remote;
    private GitProgressSupport supp;
    private GitProgressSupport validatingSupp;
    private final Mode mode;
    private final File repository;
    private final ItemSelector<BranchMapping> branches;

    public FetchBranchesStep(File repository, Mode mode) {
        this.mode = mode;
        this.repository = repository;
        this.branches = new ItemSelector(NbBundle.getMessage(FetchBranchesStep.class, (String)"FetchBranchesPanel.jLabel1.text"));
        this.branches.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                FetchBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranches.remoteBranches"));
    }

    @Override
    protected final boolean validateBeforeNext() {
        boolean acceptEmptySelection;
        this.setValid(true, null);
        boolean bl = acceptEmptySelection = this.mode == Mode.ACCEPT_EMPTY_SELECTION;
        if (!acceptEmptySelection && this.branches.getSelectedBranches().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(FetchBranchesStep.class, (String)"MSG_FetchBranchesPanel.errorNoBranchSelected"), true));
        } else if (acceptEmptySelection && this.branches.isEmpty()) {
            this.setValid(true, new AbstractWizardPanel.Message(NbBundle.getMessage(FetchBranchesStep.class, (String)"MSG_FetchBranchesPanel.errorNoBranch"), true));
        } else {
            String msgDeletedBranches = FetchBranchesStep.getDeletedBranchesMessage(this.branches.getSelectedBranches());
            if (msgDeletedBranches == null) {
                this.setValid(true, null);
            } else {
                this.setValid(true, new AbstractWizardPanel.Message(msgDeletedBranches, true));
            }
        }
        return this.isValid();
    }

    @Override
    protected final JComponent getJComponent() {
        return this.branches.getPanel();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(FetchBranchesStep.class);
    }

    public void setFetchUri(String fetchUri, boolean loadRemoteBranches) {
        if (fetchUri != null && !fetchUri.equals(this.fetchUri) || fetchUri == null && this.fetchUri != null) {
            this.fetchUri = fetchUri;
            if (loadRemoteBranches) {
                this.refreshRemoteBranches();
            }
        }
    }

    public void setRemote(GitRemoteConfig remote) {
        this.remote = remote;
        this.validateBeforeNext();
    }

    public void fillRemoteBranches(final Map<String, GitBranch> branches) {
        if (this.repository == null) {
            this.fillRemoteBranches(branches, Collections.emptyMap());
        } else {
            this.fillRemoteBranches(Collections.emptyMap(), Collections.emptyMap());
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    final HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                    RepositoryInfo info = RepositoryInfo.getInstance(FetchBranchesStep.this.repository);
                    info.refresh();
                    localBranches.putAll(info.getBranches());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FetchBranchesStep.this.fillRemoteBranches(branches, localBranches);
                        }
                    });
                }
            }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(FetchBranchesStep.class, (String)"MSG_FetchBranchesPanel.loadingLocalBranches"));
        }
    }

    private void fillRemoteBranches(Map<String, GitBranch> branches, Map<String, GitBranch> localBranches) {
        ArrayList<BranchMapping> l = new ArrayList<BranchMapping>(branches.size());
        HashSet<CallSite> displayedBranches = new HashSet<CallSite>(localBranches.size());
        for (GitBranch branch : branches.values()) {
            String branchName = this.remote.getRemoteName() + "/" + branch.getName();
            displayedBranches.add((CallSite)((Object)branchName));
            GitBranch localBranch = localBranches.get(branchName);
            boolean preselected = localBranch != null && !localBranch.getId().equals(branch.getId());
            l.add(new BranchMapping(branch.getName(), branch.getId(), localBranch, this.remote, preselected));
        }
        for (GitBranch branch : localBranches.values()) {
            if (!branch.isRemote() || displayedBranches.contains(branch.getName()) || !branch.getName().startsWith(this.remote.getRemoteName() + "/")) continue;
            l.add(new BranchMapping(null, null, branch, this.remote, false));
        }
        this.branches.setBranches(l);
        this.validateBeforeNext();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    private void refreshRemoteBranches() {
        assert (EventQueue.isDispatchThread());
        this.cancelBackgroundTasks();
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.branches.setBranches(new ArrayList(0));
        if (this.fetchUri != null) {
            final String uri = this.fetchUri;
            model.addElement(NbBundle.getMessage(FetchBranchesStep.class, (String)"MSG_FetchBranchesPanel.loadingBranches"));
            this.branches.setEnabled(false);
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    final File tempRepository = Utils.getTempFolder();
                    FetchBranchesStep.this.supp = new GitProgressSupport.NoOutputLogging(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void perform() {
                            HashMap<String, GitBranch> localBranches;
                            HashMap<String, GitBranch> branches;
                            block4: {
                                branches = new HashMap<String, GitBranch>();
                                localBranches = new HashMap<String, GitBranch>();
                                try {
                                    GitClient client = this.getClient();
                                    client.init(this.getProgressMonitor());
                                    branches.putAll(client.listRemoteBranches(uri, this.getProgressMonitor()));
                                    if (FetchBranchesStep.this.repository == null) break block4;
                                    RepositoryInfo info = RepositoryInfo.getInstance(FetchBranchesStep.this.repository);
                                    info.refresh();
                                    localBranches.putAll(info.getBranches());
                                }
                                catch (GitException ex) {
                                    try {
                                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                                    }
                                    catch (Throwable throwable) {
                                        Utils.deleteRecursively((File)tempRepository);
                                        1 supp = this;
                                        EventQueue.invokeLater(new Runnable(){
                                            final /* synthetic */ GitProgressSupport val$supp;
                                            final /* synthetic */ Map val$branches;
                                            final /* synthetic */ Map val$localBranches;
                                            {
                                                this.val$supp = gitProgressSupport;
                                                this.val$branches = map;
                                                this.val$localBranches = map2;
                                            }

                                            @Override
                                            public void run() {
                                                if (!this.val$supp.isCanceled()) {
                                                    FetchBranchesStep.this.fillRemoteBranches(this.val$branches, this.val$localBranches);
                                                }
                                            }
                                        });
                                        throw throwable;
                                    }
                                    Utils.deleteRecursively((File)tempRepository);
                                    1 supp = this;
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            Utils.deleteRecursively((File)tempRepository);
                            1 supp = this;
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    FetchBranchesStep.this.supp.start(Git.getInstance().getRequestProcessor(tempRepository), tempRepository, NbBundle.getMessage(FetchBranchesStep.class, (String)"MSG_FetchBranchesPanel.loadingBranches"));
                }
            });
        }
    }

    static String getDeletedBranchesMessage(List<BranchMapping> selectedBranches) {
        StringBuilder sb = new StringBuilder(100);
        for (BranchMapping m : selectedBranches) {
            if (!m.isDestructive()) continue;
            sb.append(Bundle.MSG_FetchBranchesStep_toBeDeletedBranch(m.getLocalBranch().getName())).append("<br>");
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.delete(sb.length() - 4, sb.length());
        return sb.toString();
    }

    public void cancelBackgroundTasks() {
        if (this.supp != null) {
            this.supp.cancel();
        }
        if (this.validatingSupp != null) {
            this.validatingSupp.cancel();
        }
    }

    public List<String> getSelectedRefSpecs() {
        LinkedList<String> specs = new LinkedList<String>();
        for (BranchMapping b : this.branches.getSelectedBranches()) {
            specs.add(b.getRefSpec());
        }
        return specs;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public static enum Mode {
        ACCEPT_EMPTY_SELECTION,
        ACCEPT_NON_EMPTY_SELECTION_ONLY;

    }
}

