/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.remote.ConnectionSettings;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

public final class GitModuleConfig {
    private static GitModuleConfig instance;
    private static final String AUTO_OPEN_OUTPUT_WINDOW = "autoOpenOutput";
    private static final String AUTO_REPLACE_INVALID_BRANCH_NAME_CHARACTERS = "autoReplaceInvalidBranchNameCharacters";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    private static final String PROP_LAST_USED_MODE = "lastUsedMode";
    private static final String EXCLUDE_NEW_FILES = "excludeNewFiles";
    private static final String RECENT_COMMIT_AUTHORS = "recentCommitAuhtors";
    private static final String RECENT_COMMITERS = "recentCommiters";
    private static final String RECENT_GURI = "recent_guri";
    private static final String SIGN_OFF = "signOff";
    private static final String REVERT_ALL = "revertAll";
    private static final String REMOVE_ALL_NEW = "removeAllNew";
    private static final String REVERT_INDEX = "revertIndex";
    private static final String REVERT_WT = "revertWT";
    private static final String REMOVE_WT_NEW = "removeWTNew";
    private static final String PROP_LAST_USED_COMMIT_VIEW_MODE = "lastUsedCommitViewMode";
    private static final String AUTO_IGNORE_FILES = "autoIgnoreFiles";
    private static final String SHOW_CLONE_COMPLETED = "cloneCompleted.showCloneCompleted";
    private static final String GURI_PASSWORD = "guri_password";
    private static final String GURI_PASSPHRASE = "guri_passphrase";
    private static final String PROP_STATUS_VIEW_MODE = "statusViewMode";
    private static final String PROP_DIFF_VIEW_MODE = "diffViewMode";
    private static final String DELIMITER = "<=~=>";
    private static final String KEY_SHOW_HISTORY_MERGES = "showHistoryMerges";
    private static final String KEY_SHOW_FILE_INFO = "showFileInfo";
    private static final String KEY_SEARCH_ON_BRANCH = "searchOnBranch.enabled";
    private static final String PROP_ANNOTATIONFORMAT_PROJECT = "annotationFormat.project";
    private static final String KEY_ANNOTATION_DISPLAYED_FIELDS = "annotate.displayedFields";
    private String lastCanceledCommitMessage;
    private static final String DEFAULT_ANNOTATION_PROJECT = "[{repository_state} {branch} {tracking_status}]";
    private Set<String> exclusions;
    private final HashMap<String, ConnectionSettings> cachedConnectionSettings = new HashMap(5);

    public static GitModuleConfig getDefault() {
        if (instance == null) {
            instance = new GitModuleConfig();
        }
        return instance;
    }

    private GitModuleConfig() {
    }

    public boolean isExcludedFromCommit(String path) {
        Set<String> commitExclusions = this.getCommitExclusions();
        return commitExclusions.contains(path);
    }

    public Color getColor(String colorName, Color defaultColor) {
        int colorRGB = this.getPreferences().getInt(colorName, defaultColor.getRGB());
        return new Color(colorRGB);
    }

    public void setColor(String colorName, Color value) {
        this.getPreferences().putInt(colorName, value.getRGB());
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(GitModuleConfig.class);
    }

    public boolean getExludeNewFiles() {
        return this.getPreferences().getBoolean(EXCLUDE_NEW_FILES, false);
    }

    public void setExcludeNewFiles(boolean value) {
        this.getPreferences().putBoolean(EXCLUDE_NEW_FILES, value);
    }

    public String getLastCanceledCommitMessage() {
        return this.lastCanceledCommitMessage == null ? "" : this.lastCanceledCommitMessage;
    }

    public void setLastCanceledCommitMessage(String message) {
        this.lastCanceledCommitMessage = message;
    }

    public void addExclusionPaths(Collection<String> paths) {
        Set<String> commitExclusions = this.getCommitExclusions();
        if (commitExclusions.addAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(commitExclusions));
        }
    }

    public void removeExclusionPaths(Collection<String> paths) {
        Set<String> commitExclusions = this.getCommitExclusions();
        if (commitExclusions.removeAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(commitExclusions));
        }
    }

    public String getProjectAnnotationFormat() {
        return this.getPreferences().get(PROP_ANNOTATIONFORMAT_PROJECT, DEFAULT_ANNOTATION_PROJECT);
    }

    public void setProjectAnnotationFormat(String text) {
        this.getPreferences().put(PROP_ANNOTATIONFORMAT_PROJECT, text);
    }

    public boolean getAutoSyncBranch(File repository, String branch) {
        RepositoryInfo.NBGitConfig cfg = RepositoryInfo.getInstance(repository).getNetbeansConfig();
        return cfg.getAutoSyncBranch(branch);
    }

    public void setAutoSyncBranch(File repository, String branch, boolean autoSync) {
        RepositoryInfo.NBGitConfig cfg = RepositoryInfo.getInstance(repository).getNetbeansConfig();
        cfg.setAutoSyncBranch(branch, autoSync);
    }

    synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    public FileInformation.Mode getLastUsedModificationContext() {
        FileInformation.Mode mode;
        try {
            mode = FileInformation.Mode.valueOf(this.getPreferences().get(PROP_LAST_USED_MODE, FileInformation.Mode.HEAD_VS_WORKING_TREE.name()));
        }
        catch (IllegalArgumentException ex) {
            mode = null;
        }
        return mode == null ? FileInformation.Mode.HEAD_VS_WORKING_TREE : mode;
    }

    public void setLastUsedModificationContext(FileInformation.Mode mode) {
        this.getPreferences().put(PROP_LAST_USED_MODE, mode.name());
    }

    public FileInformation.Mode getLastUsedCommitViewMode() {
        FileInformation.Mode mode;
        try {
            mode = FileInformation.Mode.valueOf(this.getPreferences().get(PROP_LAST_USED_COMMIT_VIEW_MODE, FileInformation.Mode.HEAD_VS_WORKING_TREE.name()));
        }
        catch (IllegalArgumentException ex) {
            mode = null;
        }
        return mode == null ? FileInformation.Mode.HEAD_VS_WORKING_TREE : mode;
    }

    public void setLastUsedCommitViewMode(FileInformation.Mode mode) {
        this.getPreferences().put(PROP_LAST_USED_COMMIT_VIEW_MODE, mode.name());
    }

    public boolean getAutoOpenOutput() {
        return this.getPreferences().getBoolean(AUTO_OPEN_OUTPUT_WINDOW, true);
    }

    public void setAutoOpenOutput(boolean value) {
        this.getPreferences().putBoolean(AUTO_OPEN_OUTPUT_WINDOW, value);
    }

    public boolean getAutoReplaceInvalidBranchNameCharacters() {
        return this.getPreferences().getBoolean(AUTO_REPLACE_INVALID_BRANCH_NAME_CHARACTERS, false);
    }

    public void setAutoReplaceInvalidBranchNameCharacters(boolean value) {
        this.getPreferences().putBoolean(AUTO_REPLACE_INVALID_BRANCH_NAME_CHARACTERS, value);
    }

    public void putRecentCommitAuthors(String author) {
        if (author == null) {
            return;
        }
        if ((author = author.trim()).isEmpty()) {
            return;
        }
        Utils.insert((Preferences)this.getPreferences(), (String)RECENT_COMMIT_AUTHORS, (String)author, (int)10);
    }

    public void putRecentCommiter(String commiter) {
        if (commiter == null) {
            return;
        }
        if ((commiter = commiter.trim()).isEmpty()) {
            return;
        }
        Utils.insert((Preferences)this.getPreferences(), (String)RECENT_COMMITERS, (String)commiter, (int)10);
    }

    public List<String> getRecentCommitAuthors() {
        return Utils.getStringList((Preferences)this.getPreferences(), (String)RECENT_COMMIT_AUTHORS);
    }

    public List<String> getRecentCommiters() {
        return Utils.getStringList((Preferences)this.getPreferences(), (String)RECENT_COMMITERS);
    }

    public void setSignOff(boolean value) {
        this.getPreferences().putBoolean(SIGN_OFF, value);
    }

    public boolean getSignOff() {
        return this.getPreferences().getBoolean(SIGN_OFF, false);
    }

    public void putRevertAll(boolean value) {
        this.getPreferences().putBoolean(REVERT_ALL, value);
    }

    public void putRevertIndex(boolean value) {
        this.getPreferences().putBoolean(REVERT_INDEX, value);
    }

    public void putRevertWT(boolean value) {
        this.getPreferences().putBoolean(REVERT_WT, value);
    }

    public void putRemoveAllNew(boolean value) {
        this.getPreferences().putBoolean(REMOVE_ALL_NEW, value);
    }

    public void putRemoveWTNew(boolean value) {
        this.getPreferences().putBoolean(REMOVE_WT_NEW, value);
    }

    public boolean getRevertAll() {
        return this.getPreferences().getBoolean(REVERT_ALL, true);
    }

    public boolean getRevertIndex() {
        return this.getPreferences().getBoolean(REVERT_INDEX, false);
    }

    public boolean getRevertWT() {
        return this.getPreferences().getBoolean(REVERT_WT, true);
    }

    public boolean getRemoveWTNew() {
        return this.getPreferences().getBoolean(REMOVE_WT_NEW, false);
    }

    public boolean getRemoveAllNew() {
        return this.getPreferences().getBoolean(REMOVE_ALL_NEW, false);
    }

    public boolean getAutoIgnoreFiles() {
        return this.getPreferences().getBoolean(AUTO_IGNORE_FILES, true);
    }

    public void setAutoIgnoreFiles(boolean flag) {
        this.getPreferences().putBoolean(AUTO_IGNORE_FILES, flag);
    }

    public boolean getShowCloneCompleted() {
        return this.getPreferences().getBoolean(SHOW_CLONE_COMPLETED, true);
    }

    public void setShowCloneCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CLONE_COMPLETED, bl);
    }

    public boolean getShowHistoryMerges() {
        return this.getPreferences().getBoolean(KEY_SHOW_HISTORY_MERGES, true);
    }

    public void setShowHistoryMerges(boolean bShowMerges) {
        this.getPreferences().putBoolean(KEY_SHOW_HISTORY_MERGES, bShowMerges);
    }

    public boolean getShowFileInfo() {
        return this.getPreferences().getBoolean(KEY_SHOW_FILE_INFO, false);
    }

    public void setShowFileInfo(boolean info) {
        this.getPreferences().putBoolean(KEY_SHOW_FILE_INFO, info);
    }

    public void insertRecentConnectionSettings(ConnectionSettings toStore) {
        assert (!EventQueue.isDispatchThread());
        String guriString = this.getUriStringWithoutCredentials(toStore.getUri());
        if (guriString == null) {
            return;
        }
        Preferences prefs = this.getPreferences();
        this.removeStaleEntries(prefs, guriString);
        if (toStore.isSaveCredentials() && (toStore.getPassphrase() != null || toStore.getPassword() != null)) {
            this.storeCredentials(toStore);
            this.cachedConnectionSettings.remove(guriString);
        } else {
            this.deleteCredentials(toStore.getUri());
            this.cachedConnectionSettings.put(guriString, toStore);
        }
        if (!guriString.isEmpty()) {
            Utils.insert((Preferences)prefs, (String)RECENT_GURI, (String)new GitConnectionSettingsEntry(guriString, toStore).toString(), (int)-1);
        }
    }

    public void removeConnectionSettings(GitURI toRemove) {
        assert (!EventQueue.isDispatchThread());
        String guriString = this.getUriStringWithoutCredentials(toRemove);
        if (guriString == null) {
            return;
        }
        Preferences prefs = this.getPreferences();
        this.removeStaleEntries(prefs, guriString);
        this.cachedConnectionSettings.remove(guriString);
        this.deleteCredentials(toRemove);
    }

    private void removeStaleEntries(Preferences prefs, String guriString) {
        List urlValues = Utils.getStringList((Preferences)prefs, (String)RECENT_GURI);
        for (String rcOldString : urlValues) {
            GitURI guriOld = null;
            try {
                GitConnectionSettingsEntry entry = GitConnectionSettingsEntry.create(rcOldString);
                if (entry != null) {
                    guriOld = new GitURI(entry.guriString);
                }
            }
            catch (URISyntaxException ex) {
                Git.LOG.log(Level.WARNING, rcOldString, ex);
            }
            if (!guriString.equals(guriOld.toString())) continue;
            Utils.removeFromArray((Preferences)prefs, (String)RECENT_GURI, (String)rcOldString);
        }
    }

    public List<ConnectionSettings> getRecentConnectionSettings() {
        assert (!EventQueue.isDispatchThread());
        Preferences prefs = this.getPreferences();
        List urls = Utils.getStringList((Preferences)prefs, (String)RECENT_GURI);
        ArrayList<ConnectionSettings> ret = new ArrayList<ConnectionSettings>(urls.size());
        for (String guriString : urls) {
            GitConnectionSettingsEntry entry = GitConnectionSettingsEntry.create(guriString);
            if (entry == null) continue;
            ConnectionSettings connSettings = this.cachedConnectionSettings.get(entry.guriString);
            if (connSettings == null) {
                connSettings = entry.toConnectionSettings();
                if (connSettings.isPrivateKeyAuth()) {
                    char[] passphrase = KeyringSupport.read((String)GURI_PASSPHRASE, (String)connSettings.getUri().toString());
                    connSettings.setPassphrase(passphrase == null ? new char[]{} : passphrase);
                } else {
                    char[] password = KeyringSupport.read((String)GURI_PASSWORD, (String)connSettings.getUri().toString());
                    connSettings.setPassword(password == null ? new char[]{} : password);
                }
            }
            ret.add(connSettings);
        }
        return ret;
    }

    public ConnectionSettings getConnectionSettings(String uriString) {
        assert (!EventQueue.isDispatchThread());
        ConnectionSettings retval = null;
        String username = null;
        try {
            GitURI uri = new GitURI(uriString);
            username = uri.getUser();
            uriString = this.getUriStringWithoutCredentials(uri);
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        ConnectionSettings cachedSetting = this.cachedConnectionSettings.get(uriString);
        if (cachedSetting != null && (username == null || cachedSetting.getUser() == null || username.equals(cachedSetting.getUser()))) {
            return cachedSetting.copy();
        }
        Preferences prefs = this.getPreferences();
        List urls = Utils.getStringList((Preferences)prefs, (String)RECENT_GURI);
        for (String guriString : urls) {
            GitConnectionSettingsEntry entry = GitConnectionSettingsEntry.create(guriString);
            if (entry == null) continue;
            ConnectionSettings storedSettings = entry.toConnectionSettings();
            if (!uriString.equals(entry.guriString) || username != null && storedSettings.getUser() != null && !username.equals(storedSettings.getUser())) continue;
            if (storedSettings.isPrivateKeyAuth()) {
                char[] passphrase = KeyringSupport.read((String)GURI_PASSPHRASE, (String)storedSettings.getUri().toString());
                storedSettings.setPassphrase(passphrase == null ? new char[]{} : passphrase);
            } else {
                char[] password = KeyringSupport.read((String)GURI_PASSWORD, (String)storedSettings.getUri().toString());
                storedSettings.setPassword(password == null ? new char[]{} : password);
            }
            retval = storedSettings;
            break;
        }
        return retval;
    }

    private void storeCredentials(ConnectionSettings settings) {
        assert (!EventQueue.isDispatchThread());
        GitURI uri = settings.getUri().setUser(settings.getUser());
        KeyringSupport.save((String)GURI_PASSWORD, (String)uri.toString(), (char[])settings.getPassword(), null);
        KeyringSupport.save((String)GURI_PASSPHRASE, (String)uri.toString(), (char[])settings.getPassphrase(), null);
    }

    private void deleteCredentials(GitURI guri) {
        assert (!EventQueue.isDispatchThread());
        KeyringSupport.save((String)GURI_PASSWORD, (String)guri.toString(), null, null);
        KeyringSupport.save((String)GURI_PASSPHRASE, (String)guri.toString(), null, null);
    }

    private String getUriStringWithoutCredentials(GitURI guri) {
        String guriString = null;
        if (guri != null) {
            guriString = guri.setUser(null).setPass(null).toString();
        }
        return guriString;
    }

    public int getDiffViewMode(int def) {
        return this.getPreferences().getInt(PROP_DIFF_VIEW_MODE, def);
    }

    public void setDiffViewMode(int value) {
        this.getPreferences().putInt(PROP_DIFF_VIEW_MODE, value);
    }

    public int getStatusViewMode(int def) {
        return this.getPreferences().getInt(PROP_STATUS_VIEW_MODE, def);
    }

    public void setStatusViewMode(int value) {
        this.getPreferences().putInt(PROP_STATUS_VIEW_MODE, value);
    }

    public boolean isSearchOnlyCurrentBranchEnabled() {
        return this.getPreferences().getBoolean(KEY_SEARCH_ON_BRANCH, true);
    }

    public void setSearchOnlyCurrentBranchEnabled(boolean enabled) {
        this.getPreferences().putBoolean(KEY_SEARCH_ON_BRANCH, enabled);
    }

    public void setAnnotationDisplayedFields(int value) {
        this.getPreferences().putInt(KEY_ANNOTATION_DISPLAYED_FIELDS, value);
    }

    public int getAnnotationDisplayedFields(int defaultValue) {
        return this.getPreferences().getInt(KEY_ANNOTATION_DISPLAYED_FIELDS, defaultValue);
    }

    private static class GitConnectionSettingsEntry {
        final String guriString;
        private String stringValue;
        private final ConnectionSettings settings;

        static GitConnectionSettingsEntry create(String entryString) {
            String[] s = entryString.split(GitModuleConfig.DELIMITER);
            assert (s.length > 0);
            try {
                return new GitConnectionSettingsEntry(s[0], GitConnectionSettingsEntry.parse(s));
            }
            catch (URISyntaxException ex) {
                Git.LOG.log(Level.WARNING, "Cannot parse stored connection settings: {0}, {1}", new Object[]{s, ex.getMessage()});
                return null;
            }
        }

        GitConnectionSettingsEntry(String guriString, ConnectionSettings setts) {
            this.guriString = guriString;
            this.settings = setts;
        }

        public String toString() {
            if (this.stringValue == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.guriString);
                sb.append(GitModuleConfig.DELIMITER);
                sb.append(this.settings.getUser() == null ? "" : this.settings.getUser());
                sb.append(GitModuleConfig.DELIMITER);
                sb.append(this.settings.isSaveCredentials() ? "1" : "0");
                sb.append(GitModuleConfig.DELIMITER);
                sb.append(this.settings.isPrivateKeyAuth() ? "1" : "0");
                sb.append(GitModuleConfig.DELIMITER);
                sb.append(this.settings.getIdentityFile());
                this.stringValue = sb.toString();
            }
            return this.stringValue;
        }

        private static ConnectionSettings parse(String[] s) throws URISyntaxException {
            String uri = s[0].trim();
            ConnectionSettings setts = new ConnectionSettings(new GitURI(uri));
            if (s.length > 1) {
                setts.setUser(s[1].isEmpty() ? null : s[1]);
            }
            if (s.length > 2) {
                setts.setSaveCredentials("1".equals(s[2]));
            }
            if (s.length > 3) {
                setts.setPrivateKeyAuth("1".equals(s[3]));
            }
            if (s.length > 4) {
                setts.setIdentityFile(s[4]);
            }
            return setts;
        }

        private ConnectionSettings toConnectionSettings() {
            return this.settings;
        }
    }
}

