/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.netbeans.modules.docker.api.DockerEntity;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class CopyIdAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        Clipboard clipboard;
        assert (activatedNodes.length == 1);
        DockerEntity idProvider = (DockerEntity)activatedNodes[0].getLookup().lookup(DockerEntity.class);
        if (idProvider != null && (clipboard = CopyIdAction.getClipboard()) != null) {
            try {
                clipboard.setContents(new StringSelection(idProvider.getId()), null);
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_StatusCopyToClipboard(idProvider.getId()));
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CouldNotCopy());
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1 && activatedNodes[0].getLookup().lookup(DockerEntity.class) != null;
    }

    public String getName() {
        return Bundle.LBL_CopyIdAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static Clipboard getClipboard() {
        Clipboard ret = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (ret == null) {
            ret = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return ret;
    }
}

