/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.docker.api.ExposedPort;
import org.netbeans.modules.docker.api.PortMapping;
import org.netbeans.modules.docker.ui.node.Bundle;

public class ViewPortBindingsPanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JTable mappingsTable;

    public ViewPortBindingsPanel(List<PortMapping> bindings) {
        this.initComponents();
        this.setModel(bindings);
    }

    private void setModel(List<PortMapping> mappings) {
        int rowNumber = mappings.size();
        this.mappingsTable.setModel(new DefaultTableModel(new Object[rowNumber][], new String[]{Bundle.LBL_Type(), Bundle.LBL_Port(), Bundle.LBL_HostPort(), Bundle.LBL_HostAddress()}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        DefaultTableCellRenderer integerRenderer = (DefaultTableCellRenderer)this.mappingsTable.getDefaultRenderer(Integer.class);
        integerRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer stringRenderer = (DefaultTableCellRenderer)this.mappingsTable.getDefaultRenderer(String.class);
        stringRenderer.setHorizontalAlignment(0);
        int row = 0;
        TableModel model = this.mappingsTable.getModel();
        for (PortMapping mapping : mappings) {
            String type = mapping.getType().equals((Object)ExposedPort.Type.TCP) ? "tcp" : "udp";
            model.setValueAt(type, row, 0);
            model.setValueAt(mapping.getPort(), row, 1);
            model.setValueAt(mapping.getHostPort(), row, 2);
            model.setValueAt(mapping.getHostAddress(), row, 3);
            ++row;
        }
        this.mappingsTable.setRowSelectionAllowed(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mappingsTable = new JTable();
        this.jScrollPane1.setViewportView(this.mappingsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 171, Short.MAX_VALUE));
    }
}

