/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ObservableActionListener;

public abstract class ObservableAction<T>
extends AbstractAction
implements AsynchronousAction {
    private final List<ObservableActionListener<T>> listeners = Collections.synchronizedList(new ArrayList());
    private volatile Future<T> taskFutureResult = null;
    private final Object lock = ObservableAction.class.getName() + "Lock";

    public ObservableAction(String name) {
        super(name);
    }

    public final void addObservableActionListener(ObservableActionListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeObservableActionListener(ObservableActionListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected abstract T performAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(ActionEvent e) {
        Object object = this.lock;
        synchronized (object) {
            if (e == null) {
                // empty if block
            }
            if (this.taskFutureResult == null || this.taskFutureResult.isDone()) {
                this.taskFutureResult = NativeTaskExecutorService.submit(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        ObservableAction.this.fireStarted();
                        Object result = ObservableAction.this.performAction();
                        ObservableAction.this.fireCompleted(result);
                        return result;
                    }
                }, "Performing observable action " + this.getValue("Name"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke() {
        Object object = this.lock;
        synchronized (object) {
            this.actionPerformed(null);
            try {
                this.taskFutureResult.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private void fireStarted() {
        ArrayList<ObservableActionListener<T>> ll = new ArrayList<ObservableActionListener<T>>(this.listeners);
        for (ObservableActionListener observableActionListener : ll) {
            observableActionListener.actionStarted(this);
        }
    }

    private void fireCompleted(T result) {
        ArrayList<ObservableActionListener<T>> ll = new ArrayList<ObservableActionListener<T>>(this.listeners);
        for (ObservableActionListener observableActionListener : ll) {
            observableActionListener.actionCompleted(this, result);
        }
    }
}

