/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsFromGroup;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

public class BreakpointsReader
implements Properties.Reader,
PropertyChangeListener {
    private static final String BREAKPOINTS_TO_ENABLE = "breakpointsToEnable";
    private static final String BREAKPOINTS_TO_DISABLE = "breakpointsToDisable";
    private static final String BP_CUSTOM_GROUP = "CustomGroup";
    private static final String BP_FILE_GROUP = "FileGroup";
    private static final String BP_PROJECT_GROUP = "ProjectGroup";
    private static final String BP_TYPE_GROUP = "TypeGroup";
    private Map<JPDABreakpoint, String> cachedClassNames = new WeakHashMap<JPDABreakpoint, String>();
    private Map<JPDABreakpoint, String> cachedSourceRoots = new WeakHashMap<JPDABreakpoint, String>();

    public String[] getSupportedClassNames() {
        return new String[]{JPDABreakpoint.class.getName()};
    }

    synchronized String findCachedClassName(JPDABreakpoint b) {
        return this.cachedClassNames.get(b);
    }

    synchronized String findCachedSourceRoot(JPDABreakpoint b) {
        return this.cachedSourceRoots.get(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedClassName(JPDABreakpoint b, String className) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            if (b instanceof LineBreakpoint && !this.cachedClassNames.containsKey(b)) {
                b.addPropertyChangeListener("url", (PropertyChangeListener)this);
            }
            this.cachedClassNames.put(b, className);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedSourceRoot(JPDABreakpoint b, String sourceRoot) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            this.cachedSourceRoots.put(b, sourceRoot);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String typeID, Properties properties) {
        Object classFilters;
        BreakpointsReader breakpointsReader;
        LineBreakpoint b = null;
        if (typeID.equals(LineBreakpoint.class.getName()) || typeID.equals(LineBreakpoint.class.getName() + "$LineBreakpointImpl")) {
            LineBreakpoint lb = LineBreakpoint.create((String)properties.getString("url", null), (int)properties.getInt("lineNumber", 1));
            lb.setCondition(properties.getString("condition", ""));
            lb.setPreferredClassName(properties.getString("classNamePreferred", null));
            breakpointsReader = this;
            synchronized (breakpointsReader) {
                this.cachedClassNames.put((JPDABreakpoint)lb, properties.getString("className", null));
                lb.addPropertyChangeListener("url", (PropertyChangeListener)this);
                this.cachedSourceRoots.put((JPDABreakpoint)lb, properties.getString("sourceRoot", null));
            }
            b = lb;
        }
        if (typeID.equals(MethodBreakpoint.class.getName()) || typeID.equals(MethodBreakpoint.class.getName() + "$MethodBreakpointImpl")) {
            MethodBreakpoint mb = MethodBreakpoint.create();
            mb.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            mb.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            mb.setMethodName(properties.getString("methodName", ""));
            mb.setMethodSignature(properties.getString("signature", null));
            mb.setCondition(properties.getString("condition", ""));
            mb.setBreakpointType(properties.getInt("breakpointtType", 1));
            breakpointsReader = this;
            synchronized (breakpointsReader) {
                this.cachedSourceRoots.put((JPDABreakpoint)mb, properties.getString("sourceRoot", null));
            }
            b = mb;
        }
        if (typeID.equals(ClassLoadUnloadBreakpoint.class.getName()) || typeID.equals(ClassLoadUnloadBreakpoint.class.getName() + "$ClassLoadUnloadBreakpointImpl")) {
            ClassLoadUnloadBreakpoint cb = ClassLoadUnloadBreakpoint.create((int)properties.getInt("breakpointType", 1));
            cb.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            cb.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            breakpointsReader = this;
            synchronized (breakpointsReader) {
                this.cachedSourceRoots.put((JPDABreakpoint)cb, properties.getString("sourceRoot", null));
            }
            b = cb;
        }
        if (typeID.equals(ExceptionBreakpoint.class.getName()) || typeID.equals(ExceptionBreakpoint.class.getName() + "$ExceptionBreakpointImpl")) {
            String[] classExclusionFilters;
            ExceptionBreakpoint eb = ExceptionBreakpoint.create((String)properties.getString("exceptionClassName", null), (int)properties.getInt("catchType", 3));
            eb.setCondition(properties.getString("condition", ""));
            classFilters = (String[])properties.getArray("classFilters", null);
            if (classFilters != null) {
                eb.setClassFilters(classFilters);
            }
            if ((classExclusionFilters = (String[])properties.getArray("classExclusionFilters", null)) != null) {
                eb.setClassExclusionFilters(classExclusionFilters);
            }
            BreakpointsReader breakpointsReader2 = this;
            synchronized (breakpointsReader2) {
                this.cachedSourceRoots.put((JPDABreakpoint)eb, properties.getString("sourceRoot", null));
            }
            b = eb;
        }
        if (typeID.equals(FieldBreakpoint.class.getName()) || typeID.equals(FieldBreakpoint.class.getName() + "$FieldBreakpointImpl")) {
            FieldBreakpoint fb = FieldBreakpoint.create((String)properties.getString("className", ""), (String)properties.getString("fieldName", ""), (int)properties.getInt("breakpointType", 1));
            fb.setCondition(properties.getString("condition", ""));
            classFilters = this;
            synchronized (classFilters) {
                this.cachedSourceRoots.put((JPDABreakpoint)fb, properties.getString("sourceRoot", null));
            }
            b = fb;
        }
        if (typeID.equals(ThreadBreakpoint.class.getName()) || typeID.equals(ThreadBreakpoint.class.getName() + "$ThreadBreakpointImpl")) {
            ThreadBreakpoint tb = ThreadBreakpoint.create();
            tb.setBreakpointType(properties.getInt("breakpointtType", 3));
            b = tb;
        }
        if (b == null) {
            throw new IllegalStateException("Unknown breakpoint type: \"" + typeID + "\"");
        }
        b.setPrintText(properties.getString("printText", ""));
        b.setGroupName(properties.getString("groupName", ""));
        b.setSuspend(properties.getInt("suspend", 2));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        b.setBreakpointsToEnable(BreakpointsReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_ENABLE));
        b.setBreakpointsToDisable(BreakpointsReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_DISABLE));
        return b;
    }

    private static Set<Breakpoint> getBreakpointsFromGroup(Properties properties, String base) {
        FileObject fo;
        URL url2;
        String bpGroup = properties.getString(base + BP_CUSTOM_GROUP, null);
        if (bpGroup != null) {
            return new BreakpointsFromGroup(bpGroup);
        }
        bpGroup = properties.getString(base + BP_FILE_GROUP, null);
        if (bpGroup != null) {
            try {
                url2 = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url2);
                if (fo != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(fo));
                }
            }
            catch (MalformedURLException url2) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_PROJECT_GROUP, null)) != null) {
            try {
                Project project;
                url2 = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url2);
                if (fo != null && (project = ProjectManager.getDefault().findProject(fo)) != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(project));
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_TYPE_GROUP, null)) != null) {
            return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(bpGroup));
        }
        return Collections.emptySet();
    }

    private static void setBreakpointsFromGroup(Properties properties, String base, Set<Breakpoint> breakpointsFromGroup) {
        String customGroup = null;
        String fileURL = null;
        String projectURL = null;
        String type = null;
        if (breakpointsFromGroup instanceof BreakpointsFromGroup) {
            BreakpointsFromGroup bfg = (BreakpointsFromGroup)breakpointsFromGroup;
            customGroup = bfg.getGroupName();
            BreakpointsFromGroup.TestGroupProperties tgp = bfg.getTestGroupProperties();
            if (tgp != null) {
                Project project;
                FileObject fo = tgp.getFileObject();
                if (fo != null) {
                    try {
                        URL url = fo.getURL();
                        fileURL = url.toExternalForm();
                    }
                    catch (FileStateInvalidException url) {
                        // empty catch block
                    }
                }
                if ((project = tgp.getProject()) != null) {
                    fo = project.getProjectDirectory();
                    try {
                        URL url = fo.getURL();
                        projectURL = url.toExternalForm();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                type = tgp.getType();
            }
        }
        properties.setString(base + BP_CUSTOM_GROUP, customGroup);
        properties.setString(base + BP_FILE_GROUP, fileURL);
        properties.setString(base + BP_PROJECT_GROUP, projectURL);
        properties.setString(base + BP_TYPE_GROUP, type);
    }

    public void write(Object object, Properties properties) {
        JPDABreakpoint b = (JPDABreakpoint)object;
        properties.setString("printText", b.getPrintText());
        properties.setString("groupName", b.getGroupName());
        properties.setInt("suspend", b.getSuspend());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setInt("hitCountFilter", b.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE style = b.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", style != null ? style.ordinal() : 0);
        Set breakpointsToEnable = b.getBreakpointsToEnable();
        BreakpointsReader.setBreakpointsFromGroup(properties, BREAKPOINTS_TO_ENABLE, breakpointsToEnable);
        Set breakpointsToDisable = b.getBreakpointsToDisable();
        BreakpointsReader.setBreakpointsFromGroup(properties, BREAKPOINTS_TO_DISABLE, breakpointsToDisable);
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)object;
            properties.setString("url", lb.getURL());
            properties.setInt("lineNumber", lb.getLineNumber());
            properties.setString("condition", lb.getCondition());
            properties.setString("classNamePreferred", lb.getPreferredClassName());
            properties.setString("className", this.findCachedClassName((JPDABreakpoint)lb));
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)lb));
            return;
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint mb = (MethodBreakpoint)object;
            properties.setArray("classFilters", (Object[])mb.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])mb.getClassExclusionFilters());
            properties.setString("methodName", mb.getMethodName());
            properties.setString("signature", mb.getMethodSignature());
            properties.setString("condition", mb.getCondition());
            properties.setInt("breakpointtType", mb.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)mb));
            return;
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)object;
            properties.setArray("classFilters", (Object[])cb.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])cb.getClassExclusionFilters());
            properties.setInt("breakpointType", cb.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)cb));
            return;
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint eb = (ExceptionBreakpoint)object;
            properties.setString("exceptionClassName", eb.getExceptionClassName());
            properties.setInt("catchType", eb.getCatchType());
            properties.setArray("classFilters", (Object[])eb.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])eb.getClassExclusionFilters());
            properties.setString("condition", eb.getCondition());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)eb));
            return;
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fb = (FieldBreakpoint)object;
            properties.setString("className", fb.getClassName());
            properties.setString("fieldName", fb.getFieldName());
            properties.setString("condition", fb.getCondition());
            properties.setInt("breakpointType", fb.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)fb));
            return;
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint tb = (ThreadBreakpoint)object;
            properties.setInt("breakpointtType", tb.getBreakpointType());
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("url".equals(evt.getPropertyName())) {
            LineBreakpoint lb = (LineBreakpoint)evt.getSource();
            this.storeCachedClassName((JPDABreakpoint)lb, null);
        }
    }
}

