/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.RequestNotSupportedException;
import org.netbeans.modules.debugger.jpda.breakpoints.SourceRootsCache;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.MethodEntryEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.MethodExitEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MethodEntryRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MethodExitRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.jpda.BreakpointsClassFilter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodBreakpointImpl
extends ClassBasedBreakpoint {
    private static final Logger LOG = Logger.getLogger(MethodBreakpointImpl.class.getName());
    private final MethodBreakpoint breakpoint;
    private final Map<Event, Value> returnValueByEvent = new WeakHashMap<Event, Value>();

    MethodBreakpointImpl(MethodBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session, SourceRootsCache sourceRootsCache) {
        super((JPDABreakpoint)breakpoint, debugger, session, sourceRootsCache);
        LOG.log(Level.FINE, "new MethodBreakpointImpl for {0}", breakpoint);
        this.breakpoint = breakpoint;
        this.setSourceRoot("");
        this.set();
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected void setRequests() {
        BreakpointsClassFilter.ClassNames classNames = this.getClassFilter().filterClassNames(new BreakpointsClassFilter.ClassNames(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters()), (JPDABreakpoint)this.breakpoint);
        Object[] names = classNames.getClassNames();
        String[] disabledRootPtr = new String[]{null};
        names = this.checkSourcesEnabled((String[])names, disabledRootPtr);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Breakpoint {0}: setRequests() filters: {1}, exclusion filters: {2} => names: {3}", new Object[]{this.breakpoint, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), Arrays.toString(names)});
        }
        if (names.length == 0) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_DisabledSourceRoot", (Object)disabledRootPtr[0]));
            LOG.log(Level.FINE, "Breakpoint {0} set as invalid.", this.breakpoint);
            return;
        }
        String[] excludedNames = classNames.getExcludedClassNames();
        boolean wasSet = this.setClassRequests((String[])names, excludedNames, 1);
        if (wasSet) {
            for (Object filter : names) {
                this.checkLoadedClasses((String)filter, excludedNames);
            }
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (oldRequest instanceof BreakpointRequest) {
            return EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), BreakpointRequestWrapper.location((BreakpointRequest)oldRequest));
        }
        if (oldRequest instanceof MethodEntryRequest) {
            ObjectVariable[] varFilters;
            MethodEntryRequest entryReq = EventRequestManagerWrapper.createMethodEntryRequest(this.getEventRequestManager());
            ReferenceType referenceType = (ReferenceType)EventRequestWrapper.getProperty(oldRequest, "ReferenceType");
            MethodEntryRequestWrapper.addClassFilter(entryReq, referenceType);
            JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (threadFilters != null && threadFilters.length > 0) {
                for (JPDAThread t : threadFilters) {
                    MethodEntryRequestWrapper.addThreadFilter(entryReq, ((JPDAThreadImpl)t).getThreadReference());
                }
            }
            if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
                for (ObjectVariable v : varFilters) {
                    MethodEntryRequestWrapper.addInstanceFilter(entryReq, (ObjectReference)((JDIVariable)v).getJDIValue());
                }
            }
            Object entryMethodNames = EventRequestWrapper.getProperty(oldRequest, "methodNames");
            EventRequestWrapper.putProperty(entryReq, "methodNames", entryMethodNames);
            EventRequestWrapper.putProperty(entryReq, "ReferenceType", referenceType);
            return entryReq;
        }
        if (oldRequest instanceof MethodExitRequest) {
            JPDAThread[] varFilters;
            MethodExitRequest exitReq = EventRequestManagerWrapper.createMethodExitRequest(this.getEventRequestManager());
            ReferenceType referenceType = (ReferenceType)EventRequestWrapper.getProperty(oldRequest, "ReferenceType");
            MethodExitRequestWrapper.addClassFilter(exitReq, referenceType);
            JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (threadFilters != null && threadFilters.length > 0) {
                varFilters = threadFilters;
                int entryMethodNames = varFilters.length;
                for (int i = 0; i < entryMethodNames; ++i) {
                    JPDAThread t = varFilters[i];
                    MethodExitRequestWrapper.addThreadFilter(exitReq, ((JPDAThreadImpl)t).getThreadReference());
                }
            }
            if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
                for (JPDAThread v : varFilters) {
                    MethodExitRequestWrapper.addInstanceFilter(exitReq, (ObjectReference)((JDIVariable)v).getJDIValue());
                }
            }
            Object exitMethodNames = EventRequestWrapper.getProperty(oldRequest, "methodNames");
            EventRequestWrapper.putProperty(exitReq, "methodNames", exitMethodNames);
            EventRequestWrapper.putProperty(exitReq, "ReferenceType", referenceType);
            return exitReq;
        }
        return null;
    }

    @Override
    public boolean processCondition(Event event) {
        try {
            if (event instanceof BreakpointEvent) {
                return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((BreakpointEvent)event), null);
            }
            if (event instanceof MethodEntryEvent) {
                String methodName = TypeComponentWrapper.name(MethodEntryEventWrapper.method((MethodEntryEvent)event));
                Set methodNames = (Set)EventRequestWrapper.getProperty(EventWrapper.request(event), "methodNames");
                if (methodNames == null || methodNames.contains(methodName)) {
                    return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((MethodEntryEvent)event), null);
                }
                return false;
            }
            if (event instanceof MethodExitEvent) {
                String methodName = TypeComponentWrapper.name(MethodExitEventWrapper.method((MethodExitEvent)event));
                Set methodNames = (Set)EventRequestWrapper.getProperty(EventWrapper.request(event), "methodNames");
                if (methodNames == null || methodNames.contains(methodName)) {
                    boolean success;
                    Value returnValue = null;
                    VirtualMachine vm = MirrorWrapper.virtualMachine(event);
                    if (vm.canGetMethodReturnValues()) {
                        returnValue = ((MethodExitEvent)event).returnValue();
                    }
                    if (success = this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((MethodExitEvent)event), returnValue)) {
                        this.returnValueByEvent.put(event, returnValue);
                    }
                    return success;
                }
                return false;
            }
            return true;
        }
        catch (InternalExceptionWrapper e) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return true;
        }
    }

    @Override
    public boolean exec(Event event) {
        try {
            if (event instanceof BreakpointEvent) {
                return this.perform(event, LocatableEventWrapper.thread((BreakpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), null);
            }
            if (event instanceof MethodEntryEvent) {
                MethodEntryEvent me = (MethodEntryEvent)event;
                ReferenceType refType = null;
                if (LocatableWrapper.location(me) != null) {
                    refType = LocationWrapper.declaringType(LocatableWrapper.location(me));
                }
                return this.perform(event, LocatableEventWrapper.thread(me), refType, null);
            }
            if (event instanceof MethodExitEvent) {
                MethodExitEvent me = (MethodExitEvent)event;
                ReferenceType refType = null;
                if (LocatableWrapper.location(me) != null) {
                    refType = LocationWrapper.declaringType(LocatableWrapper.location(me));
                }
                Value returnValue = this.returnValueByEvent.remove(event);
                return this.perform(event, LocatableEventWrapper.thread(me), refType, returnValue);
            }
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        return super.exec(event);
    }

    @Override
    protected void classLoaded(List<ReferenceType> referenceTypes) {
        boolean submitted = false;
        String invalidMessage = null;
        int type = this.breakpoint.getBreakpointType();
        boolean methodEntryType = (type & 1) != 0;
        boolean methodExitType = (type & 2) != 0;
        int customHitCountFilter = this.breakpoint.getHitCountFilter();
        if (!methodEntryType || !methodExitType) {
            customHitCountFilter = 0;
        }
        this.setCustomHitCountFilter(customHitCountFilter);
        for (ReferenceType referenceType : referenceTypes) {
            Iterator<Method> methods;
            try {
                methods = ReferenceTypeWrapper.methods0(referenceType).iterator();
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                LOG.log(Level.FINE, "Breakpoint: {0} got class load: {1}, but class is not prepared!", new Object[]{this.breakpoint, referenceType});
                continue;
            }
            MethodEntryRequest entryReq = null;
            MethodExitRequest exitReq = null;
            HashSet<String> entryMethodNames = null;
            HashSet<String> exitMethodNames = null;
            boolean locationEntry = false;
            String methodName = this.breakpoint.getMethodName();
            String typeName = referenceType.name();
            String outerArgsSignature = null;
            String constructorName = typeName;
            int index = Math.max(constructorName.lastIndexOf(46), constructorName.lastIndexOf(36));
            if (index > 0) {
                constructorName = constructorName.substring(index + 1);
                if (typeName.charAt(index) == '$') {
                    int i;
                    for (i = index - 1; i > 0 && Character.isDigit(typeName.charAt(i)); --i) {
                    }
                    if (typeName.charAt(i) == '$' && constructorName.equals(typeName.substring(i + 1, index) + methodName)) {
                        methodName = constructorName;
                    }
                }
            }
            if (methodName.equals(constructorName)) {
                methodName = "<init>";
                if (!ReferenceTypeWrapper.isStatic0(referenceType)) {
                    outerArgsSignature = this.findOuterArgsSignature(typeName, referenceType);
                }
            }
            String signature = this.breakpoint.getMethodSignature();
            LOG.log(Level.FINE, "Breakpoint: {0} got class load: {1}, searching for method name ''{2}'' with signature: {3}", new Object[]{this.breakpoint, referenceType, methodName, signature});
            while (methods.hasNext()) {
                Method method = methods.next();
                if (MethodWrapper.isBridge0(method)) continue;
                try {
                    if (!methodName.equals("") && (!MethodBreakpointImpl.match(TypeComponentWrapper.name(method), methodName) || signature != null && !MethodBreakpointImpl.egualMethodSignatures(signature, outerArgsSignature, TypeComponentWrapper.signature(method)))) continue;
                    if (methodEntryType) {
                        Location location = MethodWrapper.location(method);
                        if (location != null && !MethodWrapper.isNative(method)) {
                            ObjectVariable[] varFilters;
                            int n;
                            BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
                            LOG.log(Level.FINE, "  creating breakpoint request on location {0}", location);
                            JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                            if (threadFilters != null && threadFilters.length > 0) {
                                JPDAThread[] jPDAThreadArray = threadFilters;
                                int n2 = jPDAThreadArray.length;
                                for (n = 0; n < n2; ++n) {
                                    JPDAThread t = jPDAThreadArray[n];
                                    BreakpointRequestWrapper.addThreadFilter(br, ((JPDAThreadImpl)t).getThreadReference());
                                }
                            }
                            if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
                                ObjectVariable[] objectVariableArray = varFilters;
                                n = objectVariableArray.length;
                                for (int t = 0; t < n; ++t) {
                                    ObjectVariable v = objectVariableArray[t];
                                    BreakpointRequestWrapper.addInstanceFilter(br, (ObjectReference)((JDIVariable)v).getJDIValue());
                                }
                            }
                            this.addEventRequest(br);
                            locationEntry = true;
                        } else {
                            if (entryReq == null) {
                                ObjectVariable[] varFilters;
                                try {
                                    entryReq = EventRequestManagerWrapper.createMethodEntryRequest(this.getEventRequestManager());
                                    LOG.log(Level.FINE, " no location or is native, created method entry request: {0}", entryReq);
                                }
                                catch (UnsupportedOperationException unsupported) {
                                    invalidMessage = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethodEntry");
                                    this.setValidity(Breakpoint.VALIDITY.INVALID, invalidMessage);
                                    LOG.fine(" method entry requests not supported => breakpoint set as invalid.");
                                    return;
                                }
                                MethodEntryRequestWrapper.addClassFilter(entryReq, referenceType);
                                JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                                if (threadFilters != null && threadFilters.length > 0) {
                                    for (JPDAThread t : threadFilters) {
                                        MethodEntryRequestWrapper.addThreadFilter(entryReq, ((JPDAThreadImpl)t).getThreadReference());
                                    }
                                }
                                if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
                                    for (ObjectVariable v : varFilters) {
                                        MethodEntryRequestWrapper.addInstanceFilter(entryReq, (ObjectReference)((JDIVariable)v).getJDIValue());
                                    }
                                }
                                entryMethodNames = new HashSet<String>();
                                EventRequestWrapper.putProperty(entryReq, "methodNames", entryMethodNames);
                                EventRequestWrapper.putProperty(entryReq, "ReferenceType", referenceType);
                            }
                            entryMethodNames.add(TypeComponentWrapper.name(method));
                        }
                    }
                    if (!methodExitType) continue;
                    if (exitReq == null) {
                        ObjectVariable[] varFilters;
                        try {
                            exitReq = EventRequestManagerWrapper.createMethodExitRequest(this.getEventRequestManager());
                            LOG.log(Level.FINE, " created method exit request: {0}", exitReq);
                        }
                        catch (UnsupportedOperationException unsupported) {
                            invalidMessage = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethodExit");
                            this.setValidity(Breakpoint.VALIDITY.INVALID, invalidMessage);
                            LOG.fine(" method exit requests not supported => breakpoint set as invalid.");
                            return;
                        }
                        MethodExitRequestWrapper.addClassFilter(exitReq, referenceType);
                        JPDAThread[] threadFilters = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                        if (threadFilters != null && threadFilters.length > 0) {
                            for (JPDAThread t : threadFilters) {
                                MethodExitRequestWrapper.addThreadFilter(exitReq, ((JPDAThreadImpl)t).getThreadReference());
                            }
                        }
                        if ((varFilters = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
                            for (ObjectVariable v : varFilters) {
                                MethodExitRequestWrapper.addInstanceFilter(exitReq, (ObjectReference)((JDIVariable)v).getJDIValue());
                            }
                        }
                        exitMethodNames = new HashSet<String>();
                        EventRequestWrapper.putProperty(exitReq, "methodNames", exitMethodNames);
                        EventRequestWrapper.putProperty(exitReq, "ReferenceType", referenceType);
                    }
                    exitMethodNames.add(TypeComponentWrapper.name(method));
                }
                catch (InternalExceptionWrapper threadFilters) {
                }
                catch (ObjectCollectedExceptionWrapper threadFilters) {
                }
                catch (InvalidRequestStateExceptionWrapper irse) {
                    Exceptions.printStackTrace((Throwable)irse);
                }
                catch (VMDisconnectedExceptionWrapper e) {
                    return;
                }
                catch (RequestNotSupportedException rnsex) {
                    this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_RequestNotSupported"));
                }
            }
            try {
                if (entryReq != null) {
                    try {
                        this.addEventRequest(entryReq);
                    }
                    catch (InternalExceptionWrapper e) {
                        entryReq = null;
                    }
                    catch (ObjectCollectedExceptionWrapper e) {
                        entryReq = null;
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                        entryReq = null;
                    }
                }
                if (exitReq != null) {
                    try {
                        this.addEventRequest(exitReq);
                    }
                    catch (InternalExceptionWrapper e) {
                        exitReq = null;
                    }
                    catch (ObjectCollectedExceptionWrapper e) {
                        exitReq = null;
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                        exitReq = null;
                    }
                }
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return;
            }
            catch (RequestNotSupportedException rnsex) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_RequestNotSupported"));
                return;
            }
            if (locationEntry || entryReq != null || exitReq != null) {
                submitted = true;
                continue;
            }
            if (signature == null) {
                invalidMessage = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethod", (Object)referenceType.name(), (Object)methodName);
                continue;
            }
            invalidMessage = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethodSign", (Object)referenceType.name(), (Object)methodName, (Object)signature);
        }
        if (submitted) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else {
            this.setValidity(Breakpoint.VALIDITY.INVALID, invalidMessage);
        }
    }

    private static boolean egualMethodSignatures(String s1, String outerArgsSignature1, String s2) {
        boolean equals;
        int i = s1.lastIndexOf(")");
        if (i > 0) {
            s1 = s1.substring(0, i);
        }
        if ((i = s2.lastIndexOf(")")) > 0) {
            s2 = s2.substring(0, i);
        }
        if (!(equals = s1.equals(s2)) && outerArgsSignature1 != null) {
            equals = ("(" + outerArgsSignature1 + s1.substring(1)).equals(s2);
        }
        return equals;
    }

    private String findOuterArgsSignature(String type, ReferenceType referenceType) {
        int index = type.lastIndexOf(36);
        if (index <= 0) {
            return null;
        }
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return null;
        }
        try {
            ClassLoaderReference classLoader = ReferenceTypeWrapper.classLoader(referenceType);
            int dot = Math.max(type.lastIndexOf(46), 0);
            if (--index > dot) {
                int i1 = Math.max(type.lastIndexOf(36, index), dot);
                String enclosingTypeName = type.substring(0, index + 1);
                Type enclosingType = null;
                for (ReferenceType rt : VirtualMachineWrapper.classesByName0(vm, enclosingTypeName)) {
                    block10: {
                        try {
                            ClassLoaderReference clref = ReferenceTypeWrapper.classLoader(rt);
                            if (!Objects.equals(classLoader, clref)) {
                            }
                            break block10;
                        }
                        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {}
                        continue;
                    }
                    enclosingType = rt;
                    break;
                }
                if (enclosingType == null) {
                    return null;
                }
                return enclosingType.signature();
            }
            return null;
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return null;
        }
    }
}

