/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

public final class DBIdentifier {
    private String name;
    private transient String fullName = null;

    public DBIdentifier() {
    }

    private DBIdentifier(String name) {
        this.name = name;
    }

    public static DBIdentifier create(String name) {
        Object shortName = name.intern();
        String longName = null;
        int semicolonIndex = name.indexOf(59);
        DBIdentifier returnId = null;
        if (semicolonIndex == -1) {
            String testName = DBIdentifier.findShortName(name);
            if (!testName.equals(name)) {
                shortName = testName.intern();
                longName = name;
            } else {
                int index = name.lastIndexOf(47);
                if (index != -1) {
                    shortName = name.substring(index + 1).intern();
                    longName = name;
                }
            }
        } else {
            String firstHalf = name.substring(0, semicolonIndex);
            String secondHalf = name.substring(semicolonIndex + 1);
            String testFirstName = DBIdentifier.findShortName(firstHalf);
            String testSecondName = DBIdentifier.findShortName(secondHalf);
            if (!testFirstName.equals(firstHalf) && !testSecondName.equals(secondHalf)) {
                shortName = testFirstName + ";" + testSecondName;
                longName = name;
            }
        }
        returnId = new DBIdentifier((String)shortName);
        if (longName != null) {
            returnId.setFullName(longName);
        }
        return returnId;
    }

    private static String findShortName(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String toString() {
        return this.name;
    }

    public boolean compareTo(DBIdentifier id, boolean source) {
        if (id.fullName != null && this.fullName != null) {
            return id.fullName.equals(this.fullName);
        }
        return id.name.equals(this.name);
    }
}

