/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class DriverClassLoader
extends URLClassLoader {
    private static Logger LOGGER = Logger.getLogger(DriverClassLoader.class.getName());

    public DriverClassLoader(JDBCDriver driver) {
        super(new URL[0]);
        URL[] urls;
        for (URL url : urls = driver.getURLs()) {
            if ("nbinst".equals(url.getProtocol())) {
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo == null) {
                    LOGGER.log(Level.WARNING, "Unable to find file object for driver url " + url);
                    continue;
                }
                URL localURL = URLMapper.findURL((FileObject)fo, (int)1);
                if (localURL == null) {
                    LOGGER.log(Level.WARNING, "Unable to get file url for nbinst url " + url);
                    continue;
                }
                super.addURL(localURL);
                continue;
            }
            super.addURL(url);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        permissions.setReadOnly();
        return permissions;
    }

    public String toString() {
        return "DbURLClassLoader[urls=" + Arrays.asList(this.getURLs()) + "]";
    }
}

