/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class StartManager {
    private static final StartManager DEFAULT = new StartManager();
    private static final Logger LOGGER = Logger.getLogger(StartManager.class.getName());
    private final PropertyChangeListener listener = new StartPropertyChangeListener();
    private final AtomicBoolean isStarting = new AtomicBoolean(false);
    private final AtomicBoolean startRequested = new AtomicBoolean(false);
    private volatile DatabaseServer server;
    private volatile String errorMessage;
    private volatile boolean waitOnUsersInput;
    private volatile boolean stopWaiting;

    private StartManager() {
    }

    public static StartManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getStartListener() {
        return this.listener;
    }

    public boolean isStartRequested() {
        return this.startRequested.get();
    }

    private synchronized void setIsStarting(boolean isStarting) {
        this.isStarting.set(isStarting);
    }

    public void start(final DatabaseServer server) {
        this.server = server;
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    StartManager.this.startRequested.set(true);
                    boolean starting = StartManager.this.isStarting.getAndSet(true);
                    if (starting) {
                        LOGGER.log(Level.FINE, "Server is already starting");
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StartManager.class, (String)"MSG_StartingMySQL"));
                    server.start();
                    StartManager.this.waitForStartAndConnect();
                }
                catch (DatabaseException dbe) {
                    Utils.displayError(Utils.getMessage("MSG_UnableToStartServer", new Object[0]), (Exception)((Object)dbe));
                }
                finally {
                    StartManager.this.setIsStarting(false);
                }
            }
        });
    }

    private void waitForStartAndConnect() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                ProgressHandle handle;
                block9: {
                    handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(StartManager.class, (String)"MSG_WaitingForServerToStart"));
                    handle.start();
                    handle.switchToIndeterminate();
                    StartManager.this.waitOnUsersInput = false;
                    StartManager.this.stopWaiting = false;
                    while (true) {
                        block8: {
                            if (!StartManager.this.waitForStart()) break block8;
                            StartManager.this.startRequested.set(false);
                            handle.finish();
                            StartManager.this.startRequested.set(false);
                            return;
                        }
                        try {
                            if (StartManager.this.stopWaiting) {
                                break;
                            }
                        }
                        catch (DatabaseException dbe) {
                            assert (!DatabaseUtils.isCommunicationsException(dbe)) : "Only other than an CommunicationsException excepted, was: " + (Object)((Object)dbe);
                            if (!StartManager.this.displayAdminProperties(StartManager.this.server, dbe)) break;
                        }
                        if (StartManager.this.waitOnUsersInput) continue;
                        StartManager.this.displayServerNotRunning();
                        continue;
                        break;
                    }
                    break block9;
                    catch (Throwable throwable) {
                        handle.finish();
                        StartManager.this.startRequested.set(false);
                        throw throwable;
                    }
                }
                handle.finish();
                StartManager.this.startRequested.set(false);
            }
        });
    }

    private void displayServerNotRunning() {
        this.waitOnUsersInput = true;
        Mutex.EVENT.postReadRequest(new Runnable(){

            @Override
            public void run() {
                JButton cancelButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.CancelButton"));
                cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.CancelButtonA11yDesc"));
                JButton keepWaitingButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)keepWaitingButton, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.KeepWaitingButton"));
                keepWaitingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.KeepWaitingButtonA11yDesc"));
                JButton propsButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)propsButton, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.PropsButton"));
                propsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.PropsButtonA11yDesc"));
                String message = NbBundle.getMessage(StartManager.class, (String)"MSG_ServerDoesNotAppearToHaveStarted", (Object)StartManager.this.errorMessage);
                final NotifyDescriptor ndesc = new NotifyDescriptor((Object)message, NbBundle.getMessage(StartManager.class, (String)"StartManager.ServerNotRunningTitle"), 1, 3, new Object[]{keepWaitingButton, propsButton, cancelButton}, NotifyDescriptor.CANCEL_OPTION);
                Object ret = Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

                    public Object run() {
                        return DialogDisplayer.getDefault().notify(ndesc);
                    }
                });
                if (cancelButton.equals(ret)) {
                    StartManager.this.startRequested.set(false);
                    StartManager.this.stopWaiting = true;
                } else if (keepWaitingButton.equals(ret)) {
                    StartManager.this.stopWaiting = false;
                } else {
                    StartManager.this.stopWaiting = !StartManager.this.displayAdminProperties(StartManager.this.server, null);
                }
                StartManager.this.waitOnUsersInput = false;
            }
        });
    }

    private boolean displayAdminProperties(DatabaseServer server, Throwable th) {
        PropertiesDialog pd = new PropertiesDialog(server);
        if (th != null) {
            while (th.getCause() != null) {
                th = th.getCause();
            }
            pd.setErrorMessage(th.getLocalizedMessage());
        }
        return pd.displayDialog();
    }

    private boolean waitForStart() throws DatabaseException {
        for (int tries = 0; tries <= 5 && !this.stopWaiting; ++tries) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.INFO, "Interrupted waiting for server to start", ie);
                Thread.currentThread().interrupt();
                return false;
            }
            try {
                this.server.reconnect();
                return true;
            }
            catch (DatabaseException dbe) {
                this.errorMessage = dbe.getMessage();
                LOGGER.log(Level.INFO, null, dbe);
                if (DatabaseUtils.isCommunicationsException(dbe)) continue;
                throw dbe;
            }
            catch (TimeoutException te) {
                this.errorMessage = te.getMessage();
                LOGGER.log(Level.INFO, null, te);
                continue;
            }
        }
        return false;
    }

    private class StartPropertyChangeListener
    implements PropertyChangeListener {
        private StartPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseServer server = (DatabaseServer)evt.getSource();
            if (("start-args".equals(evt.getPropertyName()) || "start-path".equals(evt.getPropertyName())) && StartManager.this.startRequested.get()) {
                StartManager.this.start(server);
            }
        }
    }
}

