/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.util.DriverClassLoader;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DatabaseUtils {
    private static final RequestProcessor PROCESSOR = new RequestProcessor();
    public static final String SQLSTATE_COMM_ERROR = "08S01";
    private static final String SQLSTATE_CLIENT_PREFIX = "20";
    private static final String DFLT_CONFIG_OPTIONS = "?zeroDateTimeBehavior=convertToNull";
    private static final Logger LOGGER = Logger.getLogger(DatabaseUtils.class.getName());
    private static Driver driver;

    public static boolean isEmpty(String val) {
        return val == null || val.length() == 0;
    }

    public static JDBCDriver getJDBCDriver() {
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(MySQLOptions.getDriverClass());
        if (drivers.length == 0) {
            return null;
        }
        return drivers[0];
    }

    public static Driver getDriver() throws DatabaseException {
        if (driver != null) {
            return driver;
        }
        JDBCDriver jdbcDriver = DatabaseUtils.getJDBCDriver();
        if (jdbcDriver == null) {
            throw new DatabaseException(Utils.getMessage("MSG_JDBCDriverNotRegistered", new Object[0]));
        }
        try {
            DriverClassLoader driverLoader = new DriverClassLoader(jdbcDriver);
            driver = (Driver)Class.forName(jdbcDriver.getClassName(), true, driverLoader).newInstance();
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException(Utils.getMessage("MSG_UnableToLoadJDBCDriver", new Object[0]) + e.getMessage());
            dbe.initCause((Throwable)e);
            throw dbe;
        }
        return driver;
    }

    public static Connection getConnection(DatabaseConnection dbconn) throws SQLException {
        Connection conn = dbconn.getJDBCConnection();
        if (conn == null || conn.isClosed()) {
            ConnectionManager.getDefault().showConnectionDialog(dbconn);
            conn = dbconn.getJDBCConnection();
        }
        return conn;
    }

    public static Connection connect(final String url, String user, String password, long timeToWait) throws DatabaseException, TimeoutException {
        final Driver theDriver = DatabaseUtils.getDriver();
        final Properties props = new Properties();
        props.put("user", user);
        if (password != null) {
            props.put("password", password);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Connection> future = executor.submit(new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                props.put("connectTimeout", MySQLOptions.getDefault().getConnectTimeout());
                try {
                    return theDriver.connect(url, props);
                }
                catch (SQLException sqle) {
                    if (DatabaseUtils.isCommunicationsException(sqle)) {
                        String msg = Utils.getMessage("ERR_MySQLCommunicationFailure", new Object[0]);
                        DatabaseException dbe = new DatabaseException(msg);
                        dbe.initCause((Throwable)sqle);
                        throw dbe;
                    }
                    throw new DatabaseException((Throwable)sqle);
                }
            }
        });
        try {
            return future.get(timeToWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DatabaseException((Throwable)ie);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DatabaseException) {
                throw new DatabaseException(e.getCause());
            }
            throw Utils.launderThrowable(e.getCause());
        }
        catch (TimeoutException te) {
            future.cancel(true);
            throw new TimeoutException(NbBundle.getMessage(DatabaseUtils.class, (String)"MSG_ConnectTimedOut"));
        }
    }

    public static Connection connect(String url, String user, String password) throws DatabaseException, TimeoutException {
        return DatabaseUtils.connect(url, user, password, 5000L);
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, null, e);
        }
    }

    public static DatabaseConnection findDatabaseConnection(String url, String user) {
        List<DatabaseConnection> conns = DatabaseUtils.findDatabaseConnections(url);
        for (DatabaseConnection conn : conns) {
            if (!conn.getUser().equals(user)) continue;
            return conn;
        }
        return null;
    }

    public static List<DatabaseConnection> findDatabaseConnections(String url) {
        DatabaseConnection[] connections;
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection conn : connections = ConnectionManager.getDefault().getConnections()) {
            if (!conn.getDriverClass().equals(MySQLOptions.getDriverClass()) || !conn.getDatabaseURL().equals(url)) continue;
            result.add(conn);
        }
        return result;
    }

    public static String getURL(String host, String port) {
        return DatabaseUtils.getURL(host, port, null);
    }

    public static String getURL(String host, String port, String database) {
        StringBuffer url = new StringBuffer("jdbc:mysql://");
        url.append(host == null || host.equals("") ? "localhost" : host);
        if (port != null && !port.equals("")) {
            url.append(":" + port);
        }
        if (database != null && !database.equals("")) {
            url.append("/" + database);
        }
        url.append(DFLT_CONFIG_OPTIONS);
        return url.toString();
    }

    public static boolean ensureConnected(DatabaseConnection dbconn) {
        try {
            Connection conn = dbconn.getJDBCConnection();
            if (conn == null || conn.isClosed()) {
                ConnectionManager.getDefault().showConnectionDialog(dbconn);
            }
            return (conn = dbconn.getJDBCConnection()) != null && !conn.isClosed();
        }
        catch (SQLException e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
    }

    public static boolean isCommunicationsException(DatabaseException dbe) {
        if (dbe.getCause() == null || !(dbe.getCause() instanceof SQLException)) {
            return false;
        }
        return DatabaseUtils.isCommunicationsException((SQLException)dbe.getCause());
    }

    public static boolean isCommunicationsException(SQLException sqle) {
        return sqle.getClass().getName().equals("com.mysql.jdbc.CommunicationsException");
    }

    public static boolean isServerException(SQLException e) {
        String sqlstate = e.getSQLState();
        SQLException nexte = e.getNextException();
        if (SQLSTATE_COMM_ERROR.equals(sqlstate)) {
            return false;
        }
        if (sqlstate.startsWith(SQLSTATE_CLIENT_PREFIX)) {
            return false;
        }
        if (nexte != null) {
            return DatabaseUtils.isServerException(nexte);
        }
        return true;
    }

    public static class URLParser {
        private static final String MYSQL_PROTOCOL = "jdbc:mysql://";
        private String host;
        private String port;
        private final String url;

        public URLParser(String url) {
            assert (url != null && url.startsWith(MYSQL_PROTOCOL));
            this.url = url.replaceFirst(MYSQL_PROTOCOL, "");
        }

        public String getHost() {
            if (this.host == null) {
                this.host = this.url.indexOf(":") >= 0 ? this.url.split(":")[0] : this.url.split("/")[0];
            }
            return this.host;
        }

        public String getPort() {
            if (this.port == null) {
                if (this.url.indexOf(":") >= 0) {
                    this.port = this.url.split(":")[1];
                    if (this.port.indexOf("/") >= 0) {
                        this.port = this.port.split("/")[0];
                    }
                } else {
                    this.port = "";
                }
            }
            return this.port;
        }
    }

    public static enum ConnectStatus {
        NO_SERVER,
        SERVER_RUNNING,
        CONNECT_SUCCEEDED;

    }
}

