/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DateType;
import org.netbeans.modules.db.dataview.util.FileBackedBlob;
import org.netbeans.modules.db.dataview.util.FileBackedClob;
import org.netbeans.modules.db.dataview.util.TimeType;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DBReadWriteHelper {
    public static final int SQL_TYPE_ORACLE_TIMESTAMP = -100;
    public static final int SQL_TYPE_ORACLE_TIMESTAMP_WITH_TZ = -101;
    private static final BigInteger maxUnsignedLong = new BigInteger("18446744073709551615");
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final long maxUnsignedInt = 0xFFFFFFFFL;
    private static final int maxUnsignedShort = 65535;
    private static final short maxUnsignedByte = 255;
    private static final Logger mLogger = Logger.getLogger(DBReadWriteHelper.class.getName());

    public static Object readResultSet(ResultSet rs, DBColumn col, int index) throws SQLException {
        int colType = col.getJdbcType();
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        switch (colType) {
            case 16: {
                boolean bdata = rs.getBoolean(index);
                if (rs.wasNull()) {
                    return null;
                }
                return bdata;
            }
            case 92: {
                Time tdata = rs.getTime(index);
                if (rs.wasNull()) {
                    return null;
                }
                return tdata;
            }
            case 91: {
                Date ddata = rs.getDate(index);
                if (rs.wasNull()) {
                    return null;
                }
                return ddata;
            }
            case -101: 
            case -100: 
            case 93: {
                try {
                    Timestamp tsdata = rs.getTimestamp(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return tsdata;
                }
                catch (SQLException sqe) {
                    if (sqe.getSQLState().equals("S1009")) {
                        return null;
                    }
                    throw sqe;
                }
            }
            case -5: {
                try {
                    long ldata = rs.getLong(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return ldata;
                }
                catch (SQLDataException ex) {
                    String sdata = rs.getString(index);
                    if (sdata == null) {
                        return null;
                    }
                    return new BigInteger(sdata);
                }
            }
            case 8: {
                double fdata = rs.getDouble(index);
                if (rs.wasNull()) {
                    return null;
                }
                return fdata;
            }
            case 6: 
            case 7: {
                float rdata = rs.getFloat(index);
                if (rs.wasNull()) {
                    return null;
                }
                return Float.valueOf(rdata);
            }
            case 2: 
            case 3: {
                BigDecimal bddata = rs.getBigDecimal(index);
                if (rs.wasNull()) {
                    return null;
                }
                return bddata;
            }
            case -6: 
            case 4: 
            case 5: {
                try {
                    int idata = rs.getInt(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return idata;
                }
                catch (SQLDataException ex) {
                    long ldata = rs.getLong(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return ldata;
                }
            }
            case -15: 
            case -9: 
            case -8: 
            case 1: 
            case 12: {
                String sdata = rs.getString(index);
                if (rs.wasNull()) {
                    return null;
                }
                return sdata;
            }
            case -7: {
                byte[] bdata = rs.getBytes(index);
                if (rs.wasNull() || bdata == null) {
                    return null;
                }
                String bStr = BinaryToStringConverter.convertToString(bdata, 2, true);
                if (colType == -7 && col.getPrecision() != 0 && col.getPrecision() < bStr.length()) {
                    return bStr.substring(bStr.length() - col.getPrecision());
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream is = rs.getBinaryStream(index);
                    if (is == null) {
                        return null;
                    }
                    return new FileBackedBlob(is);
                }
                catch (NullPointerException ex) {
                    return null;
                }
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                try {
                    Clob clob = rs.getClob(index);
                    if (clob == null) {
                        return null;
                    }
                    FileBackedClob result = null;
                    if (!rs.wasNull()) {
                        result = new FileBackedClob(clob.getCharacterStream());
                    }
                    try {
                        clob.free();
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return result;
                }
                catch (UnsupportedOperationException | SQLException clob) {
                    String sdata = rs.getString(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return new FileBackedClob(sdata);
                }
            }
        }
        return rs.getObject(index);
    }

    public static void setAttributeValue(PreparedStatement ps, int index, int jdbcType, Object valueObj) throws DBException {
        try {
            if (valueObj == null) {
                ps.setNull(index, jdbcType);
                return;
            }
            if (jdbcType == -7 && valueObj instanceof Boolean) {
                jdbcType = 16;
            }
            switch (jdbcType) {
                case 16: {
                    ps.setBoolean(index, (Boolean)valueObj);
                    break;
                }
                case 92: {
                    ps.setTime(index, TimeType.convert(valueObj));
                    break;
                }
                case 91: {
                    ps.setDate(index, DateType.convert(valueObj));
                    break;
                }
                case -101: 
                case -100: 
                case 93: {
                    ps.setTimestamp(index, TimestampType.convert(valueObj));
                    break;
                }
                case -5: {
                    if (valueObj instanceof BigInteger) {
                        BigInteger biValue = (BigInteger)valueObj;
                        if (biValue.compareTo(maxLong) > 0 || biValue.compareTo(minLong) < 0) {
                            ps.setString(index, valueObj.toString());
                            break;
                        }
                        ps.setLong(index, biValue.longValue());
                        break;
                    }
                    if (valueObj instanceof Number) {
                        Number numberValue = (Number)valueObj;
                        ps.setLong(index, numberValue.longValue());
                        break;
                    }
                    BigInteger biValue = new BigInteger(valueObj.toString());
                    if (biValue.compareTo(maxLong) > 0 || biValue.compareTo(minLong) < 0) {
                        ps.setString(index, valueObj.toString());
                        break;
                    }
                    ps.setLong(index, biValue.longValue());
                    break;
                }
                case 8: {
                    Number numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Double.valueOf(valueObj.toString());
                    ps.setDouble(index, numberObj.doubleValue());
                    break;
                }
                case 6: 
                case 7: {
                    Number numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Float.valueOf(valueObj.toString());
                    ps.setFloat(index, numberObj.floatValue());
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDec = valueObj instanceof BigDecimal ? (BigDecimal)valueObj : new BigDecimal(valueObj.toString());
                    ps.setBigDecimal(index, bigDec);
                    break;
                }
                case 4: {
                    Number numberObj;
                    Number number = numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Long.valueOf(valueObj.toString());
                    if (numberObj.longValue() > Integer.MAX_VALUE) {
                        ps.setLong(index, numberObj.longValue());
                        break;
                    }
                    ps.setInt(index, numberObj.intValue());
                    break;
                }
                case 5: {
                    Number numberObj;
                    Number number = numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Integer.valueOf(valueObj.toString());
                    if (numberObj.longValue() > 32767L) {
                        ps.setInt(index, numberObj.intValue());
                        break;
                    }
                    ps.setShort(index, numberObj.shortValue());
                    break;
                }
                case -6: {
                    Number numberObj;
                    Number number = numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Short.valueOf(valueObj.toString());
                    if (numberObj.longValue() > 127L) {
                        ps.setShort(index, numberObj.shortValue());
                        break;
                    }
                    ps.setByte(index, numberObj.byteValue());
                    break;
                }
                case -15: 
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    ps.setString(index, valueObj.toString());
                    break;
                }
                case -7: {
                    ps.setBytes(index, BinaryToStringConverter.convertBitStringToBytes(valueObj.toString()));
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    ps.setBinaryStream(index, ((Blob)valueObj).getBinaryStream(), (int)((Blob)valueObj).length());
                    break;
                }
                case -16: 
                case -1: 
                case 2005: 
                case 2011: {
                    ps.setCharacterStream(index, ((Clob)valueObj).getCharacterStream(), (int)((Clob)valueObj).length());
                    break;
                }
                default: {
                    ps.setObject(index, valueObj, jdbcType);
                }
            }
        }
        catch (RuntimeException | SQLException | DBException e) {
            mLogger.log(Level.SEVERE, "Invalid Data for" + jdbcType + "type -- ", e);
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_InvalidType", (Object)jdbcType, (Object)e));
        }
    }

    public static Object validate(Object valueObj, DBColumn col) throws DBException {
        int colType = col.getJdbcType();
        if (valueObj == null) {
            return null;
        }
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        try {
            switch (colType) {
                case 16: {
                    if (valueObj instanceof Boolean) {
                        return valueObj;
                    }
                    String str = valueObj.toString();
                    if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("1")) {
                        return Boolean.TRUE;
                    }
                    if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("0")) {
                        return Boolean.FALSE;
                    }
                    throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Boolean"));
                }
                case 92: {
                    return TimeType.convert(valueObj);
                }
                case 91: {
                    return DateType.convert(valueObj);
                }
                case -101: 
                case -100: 
                case 93: {
                    return TimestampType.convert(valueObj);
                }
                case -5: {
                    if (valueObj instanceof Long) {
                        return valueObj;
                    }
                    BigInteger value = new BigInteger(valueObj.toString());
                    if (value.compareTo(minLong) < 0 || value.compareTo(maxUnsignedLong) > 0) {
                        throw new NumberFormatException("Illegal value for BIGINT");
                    }
                    return value;
                }
                case 8: {
                    return valueObj instanceof Double ? valueObj : Double.valueOf(valueObj.toString());
                }
                case 6: 
                case 7: {
                    return valueObj instanceof Float ? valueObj : Float.valueOf(valueObj.toString());
                }
                case 2: 
                case 3: {
                    return valueObj instanceof BigDecimal ? valueObj : new BigDecimal(valueObj.toString());
                }
                case 4: {
                    long ldata = Long.parseLong(valueObj.toString());
                    if (ldata >= Integer.MIN_VALUE && ldata <= Integer.MAX_VALUE) {
                        return (int)ldata;
                    }
                    if (ldata < 0xFFFFFFFFL) {
                        return new Long(ldata);
                    }
                    throw new NumberFormatException("Illegal value for java.sql.Type.Integer");
                }
                case 5: {
                    int idata = Integer.parseInt(valueObj.toString());
                    if (idata >= Short.MIN_VALUE && idata <= Short.MAX_VALUE) {
                        return (short)idata;
                    }
                    if (idata < 65535) {
                        return idata;
                    }
                    throw new NumberFormatException("Illegal value for java.sql.Type.SMALLINT");
                }
                case -6: {
                    short sdata = Short.parseShort(valueObj.toString());
                    if (sdata >= -128 && sdata <= 127) {
                        return (byte)sdata;
                    }
                    if (sdata < 255) {
                        return sdata;
                    }
                    throw new NumberFormatException("Illegal value for java.sql.Type.TINYINT");
                }
                case -15: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (col.getPrecision() > 0 && valueObj.toString().length() > col.getPrecision()) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)valueObj, (Object)colName));
                    }
                    return valueObj;
                }
                case -7: {
                    if (valueObj.toString().length() > col.getPrecision()) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)valueObj, (Object)colName));
                    }
                    if (valueObj.toString().trim().length() == 0) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Invalid", (Object)valueObj, (Object)colName));
                    }
                    BinaryToStringConverter.convertBitStringToBytes(valueObj.toString());
                    return valueObj;
                }
            }
            return valueObj;
        }
        catch (RuntimeException | DBException e) {
            String type = col.getTypeName();
            String colName = col.getQualifiedName(false);
            int precision = col.getPrecision();
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_ErrLog", (Object[])new Object[]{colName, type, precision, e.getLocalizedMessage()}));
        }
    }

    public static boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }
}

