/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorPositionExtractor {
    private static final Logger LOG = Logger.getLogger(ErrorPositionExtractor.class.getName());
    private static final Pattern positionPatternDerby = Pattern.compile("at line (\\d+), column (\\d+)");
    private static final Pattern h2SyntaxPattern = Pattern.compile("Syntax error in SQL statement \"((([^\"])|(\"\"))*)\"");

    private ErrorPositionExtractor() {
    }

    public static int extractErrorPosition(Connection con, Statement stmt, Throwable ex, String sql) {
        try {
            if (ex == null || con == null) {
                return -1;
            }
            if (con.getMetaData().getDriverName().toLowerCase().contains("postgresql")) {
                return ErrorPositionExtractor.extractErrorPositionForPostgresql(con, stmt, ex, sql);
            }
            if (con.getMetaData().getDriverName().toLowerCase().contains("informix")) {
                return ErrorPositionExtractor.extractErrorPositionForInformix(con, stmt, ex, sql);
            }
            if (con.getMetaData().getDriverName().toLowerCase().contains("derby")) {
                return ErrorPositionExtractor.extractErrorPositionForDerby(con, stmt, ex, sql);
            }
            if (con.getMetaData().getDriverName().toLowerCase().contains("h2 jdbc")) {
                return ErrorPositionExtractor.extractErrorPositionForH2(con, stmt, ex, sql);
            }
            return -1;
        }
        catch (Exception innerEx) {
            LOG.log(Level.FINE, "Failed to extract ErrorPosition", innerEx);
            return -1;
        }
    }

    private static int extractErrorPositionForPostgresql(Connection con, Statement stmt, Throwable ex, String sql) {
        if (ex == null) {
            return -1;
        }
        Class<?> exceptionClass = ex.getClass();
        if (exceptionClass.getName().equals("org.postgresql.util.PSQLException")) {
            try {
                Method getServerErrorMessage = exceptionClass.getMethod("getServerErrorMessage", new Class[0]);
                Object serverErrorMessage = getServerErrorMessage.invoke((Object)ex, new Object[0]);
                Class<?> messageClass = serverErrorMessage.getClass();
                Method getPosition = messageClass.getMethod("getPosition", new Class[0]);
                Integer result = (Integer)getPosition.invoke(serverErrorMessage, new Object[0]);
                if (result != null && result > 0) {
                    return result - 1;
                }
                return -1;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException innerEx) {
                LOG.log(Level.FINE, "Failed to parse PostgreSQL error", innerEx);
                return -1;
            }
        }
        LOG.log(Level.FINE, "Caught PostgreSQL exception, that is not subclass of PSQLException", ex);
        return -1;
    }

    private static int extractErrorPositionForInformix(Connection con, Statement stmt, Throwable ex, String sql) {
        if (ex == null) {
            return -1;
        }
        Class<?> connectionClass = con.getClass();
        if (connectionClass.getName().startsWith("com.informix.jdbc")) {
            try {
                Method getSQLStatementOffset = connectionClass.getMethod("getSQLStatementOffset", new Class[0]);
                int column = (Integer)getSQLStatementOffset.invoke((Object)con, new Object[0]);
                if (column <= 0) {
                    return -1;
                }
                return column - 1;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException innerEx) {
                LOG.log(Level.FINE, "Failed to extract informix error location", innerEx);
                return -1;
            }
        }
        return -1;
    }

    private static int extractErrorPositionForDerby(Connection con, Statement stmt, Throwable ex, String sql) {
        if (!(ex instanceof SQLException)) {
            return -1;
        }
        SQLException se = (SQLException)ex;
        String msg = se.getMessage();
        Matcher matcher = positionPatternDerby.matcher(msg);
        if (matcher.find()) {
            int line = Integer.parseInt(matcher.group(1));
            int lineOffset = 0;
            int column = Integer.parseInt(matcher.group(2)) - 1;
            for (int toSkip = line - 1; toSkip > 0; --toSkip) {
                lineOffset = sql.indexOf("\n", lineOffset) + 1;
            }
            return lineOffset + column;
        }
        return -1;
    }

    private static int extractErrorPositionForH2(Connection con, Statement stmt, Throwable ex, String sql) {
        if (!(ex instanceof SQLException)) {
            return -1;
        }
        SQLException se = (SQLException)ex;
        if (se.getErrorCode() != 42000 && se.getErrorCode() != 42001) {
            return -1;
        }
        Matcher matcher = h2SyntaxPattern.matcher(se.getMessage());
        if (matcher.find()) {
            String errorSQL = matcher.group(1).replace("\"\"", "\"");
            String lowerReference = sql.toLowerCase();
            String lowerError = errorSQL.toLowerCase();
            int endIdx = Math.min(lowerReference.length(), lowerError.length());
            for (int i = 0; i < endIdx && i < lowerError.length() - 3; ++i) {
                if (lowerReference.charAt(i) == lowerError.charAt(i)) continue;
                if ("[*]".equals(errorSQL.substring(i, i + 3))) {
                    return i;
                }
                return -1;
            }
            if (lowerError.length() >= endIdx + 2 && lowerError.startsWith("[*]", endIdx)) {
                return endIdx;
            }
            return -1;
        }
        return -1;
    }
}

