/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;

public class DataViewTableUIModel
extends ResultSetTableModel {
    private final Map<Integer, Map<Integer, Object>> oldData = new LinkedHashMap<Integer, Map<Integer, Object>>();
    private int rowOffset = 0;

    protected DataViewTableUIModel(DBColumn[] columns) {
        super(columns);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Object oldval = this.getValueAt(row, col);
        if (this.noUpdateRequired(oldval, value)) {
            return;
        }
        this.addUpdates(row, col, oldval);
        super.setValueAt(value, row, col);
    }

    public Object getOriginalValueAt(int row, int col) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        if (this.hasUpdates(row, col)) {
            return this.oldData.get(row).get(col);
        }
        return this.getValueAt(row, col);
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
        this.fireTableDataChanged();
    }

    public int getTotalRowOffset(int row) {
        return this.rowOffset + row;
    }

    @Override
    public void setData(List<Object[]> data) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        super.setData(data);
        this.oldData.clear();
    }

    @Override
    public void removeRow(int row) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        super.removeRow(row);
        this.oldData.remove(row);
    }

    @Override
    public void clear() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        super.clear();
        this.oldData.clear();
    }

    private void addUpdates(int row, int col, Object value) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Map<Integer, Object> rowMap = this.oldData.get(row);
        if (rowMap == null) {
            rowMap = new LinkedHashMap<Integer, Object>();
            this.oldData.put(row, rowMap);
        }
        if (!rowMap.containsKey(col)) {
            rowMap.put(col, value);
        }
    }

    public void removeAllUpdates(boolean discardNewValue) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        for (Integer rowIndex : new HashSet<Integer>(this.oldData.keySet())) {
            Map<Integer, Object> oldRow = this.oldData.remove(rowIndex);
            if (!discardNewValue) continue;
            for (Integer columnIndex : new HashSet<Integer>(oldRow.keySet())) {
                super.setValueAt(oldRow.remove(columnIndex), rowIndex, columnIndex);
            }
        }
    }

    public void removeUpdateForSelectedRow(int row, boolean discardNewValue) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        if (this.oldData.containsKey(row)) {
            Map<Integer, Object> oldRow = this.oldData.remove(row);
            if (discardNewValue) {
                for (Integer columnIndex : new HashSet<Integer>(oldRow.keySet())) {
                    super.setValueAt(oldRow.remove(columnIndex), row, columnIndex);
                }
            }
        }
    }

    public void removeUpdate(int row, int col, boolean discardNewValue) {
        Map<Integer, Object> oldRow;
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        if (this.oldData.containsKey(row) && (oldRow = this.oldData.get(row)).containsKey(col)) {
            Object value = oldRow.get(col);
            if (oldRow.isEmpty()) {
                this.oldData.remove(row);
            }
            if (discardNewValue) {
                super.setValueAt(value, row, col);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public Set<Integer> getUpdateKeys() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.oldData.keySet();
    }

    public Map<Integer, Object> getChangedData(int row) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Set<Integer> changedColumns = this.oldData.get(row).keySet();
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        for (Integer column : changedColumns) {
            result.put(column, this.getValueAt(row, column));
        }
        return result;
    }

    boolean hasUpdates() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.oldData.size() > 0;
    }

    boolean hasUpdates(int row, int col) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Map<Integer, Object> rowMap = this.oldData.get(new Integer(row));
        return rowMap != null && rowMap.containsKey(col);
    }
}

