/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public final class DBMetaDataFactory {
    public static final int DB2 = 0;
    public static final int ORACLE = 1;
    public static final int SQLSERVER = 2;
    public static final int JDBC = 3;
    public static final int PostgreSQL = 4;
    public static final int MYSQL = 5;
    public static final int DERBY = 6;
    public static final int SYBASE = 7;
    public static final int AXION = 8;
    public static final int POINTBASE = 9;
    private final int dbType;
    private final DatabaseMetaData dbmeta;
    private final SQLIdentifiers.Quoter sqlquoter;
    private final String identifierQuoteString;

    public DBMetaDataFactory(Connection dbconn) throws SQLException {
        assert (dbconn != null);
        this.dbmeta = dbconn.getMetaData();
        this.dbType = this.dbmeta.getURL() != null ? DBMetaDataFactory.getDBTypeFromURL(this.dbmeta.getURL()) : 3;
        this.sqlquoter = SQLIdentifiers.createQuoter((DatabaseMetaData)this.dbmeta);
        String buildIdentifierQuoteString = "\"";
        try {
            buildIdentifierQuoteString = this.dbmeta.getIdentifierQuoteString().trim();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.identifierQuoteString = buildIdentifierQuoteString;
    }

    public boolean supportsLimit() {
        switch (this.dbType) {
            case 4: 
            case 5: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getDBType() throws SQLException {
        return this.dbType;
    }

    private static int getDBTypeFromURL(String url) {
        int dbtype = (url = url.toLowerCase()).contains("sybase") ? 7 : (url.contains("sqlserver") ? 2 : (url.contains("db2") ? 0 : (url.contains("orac") ? 1 : (url.contains("axion") ? 8 : (url.contains("derby") ? 6 : (url.contains("postgre") ? 4 : (url.contains("mysql") ? 5 : (url.contains("pointbase") ? 9 : 3))))))));
        return dbtype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBPrimaryKey getPrimaryKeys(String tcatalog, String tschema, String tname) {
        ResultSet rs = null;
        try {
            rs = this.dbmeta.getPrimaryKeys(this.setToNullIfEmpty(tcatalog), this.setToNullIfEmpty(tschema), tname);
            DBPrimaryKey dBPrimaryKey = new DBPrimaryKey(rs);
            DataViewUtils.closeResources(rs);
            return dBPrimaryKey;
        }
        catch (NullPointerException | SQLException e) {
            DBPrimaryKey dBPrimaryKey = null;
            return dBPrimaryKey;
        }
        finally {
            DataViewUtils.closeResources(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DBForeignKey> getForeignKeys(DBTable table) {
        Map<String, DBForeignKey> fkList = Collections.emptyMap();
        ResultSet rs = null;
        try {
            rs = this.dbmeta.getImportedKeys(this.setToNullIfEmpty(table.getCatalog()), this.setToNullIfEmpty(table.getSchema()), table.getName());
            fkList = DBForeignKey.createForeignKeyColumnMap(table, rs);
            DataViewUtils.closeResources(rs);
        }
        catch (NullPointerException | SQLException e) {
            Map<String, DBForeignKey> map = null;
            return map;
        }
        finally {
            DataViewUtils.closeResources(rs);
        }
        return fkList;
    }

    public synchronized Collection<DBTable> generateDBTables(ResultSet rs, String sql, boolean isSelect) throws SQLException {
        LinkedHashMap<String, DBTable> tables = new LinkedHashMap<String, DBTable>();
        String noTableName = "UNKNOWN";
        ResultSetMetaData rsMeta = rs.getMetaData();
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            int precision;
            DBTable table;
            String key;
            String catalogName;
            String schemaName;
            String tableName = rsMeta.getTableName(i);
            if (tableName == null) {
                tableName = noTableName;
            }
            if ((schemaName = rsMeta.getSchemaName(i)) == null) {
                schemaName = "";
            }
            if ((catalogName = rsMeta.getCatalogName(i)) == null) {
                catalogName = "";
            }
            if (schemaName.trim().length() == 0 && catalogName.equals(tableName)) {
                catalogName = "";
            }
            if ((key = catalogName + schemaName + tableName).equals("")) {
                key = noTableName;
            }
            if ((table = (DBTable)tables.get(key)) == null) {
                table = new DBTable(tableName, schemaName, catalogName);
                tables.put(key, table);
            }
            int sqlTypeCode = rsMeta.getColumnType(i);
            String sqlTypeStr = rsMeta.getColumnTypeName(i);
            if (sqlTypeCode == 1111 && this.dbType == 1) {
                if (sqlTypeStr.startsWith("TIMESTAMP")) {
                    sqlTypeCode = 93;
                } else if (sqlTypeStr.startsWith("FLOAT")) {
                    sqlTypeCode = 6;
                } else if (sqlTypeStr.startsWith("REAL")) {
                    sqlTypeCode = 7;
                } else if (sqlTypeStr.startsWith("BLOB")) {
                    sqlTypeCode = 2004;
                } else if (sqlTypeStr.startsWith("CLOB")) {
                    sqlTypeCode = 2005;
                }
            }
            String colName = rsMeta.getColumnName(i);
            int position = i;
            int scale = rsMeta.getScale(i);
            try {
                precision = rsMeta.getPrecision(i);
            }
            catch (NumberFormatException nfe) {
                precision = Integer.MAX_VALUE;
                Logger.getLogger(DBMetaDataFactory.class.getName()).log(Level.FINE, "Oracle classes12.jar driver throws NumberFormatException while getting precision, use Integer.MAX_VALUE as fallback.", nfe);
            }
            boolean isNullable = rsMeta.isNullable(i) == 1;
            String displayName = rsMeta.getColumnLabel(i);
            int displaySize = rsMeta.getColumnDisplaySize(i);
            boolean autoIncrement = rsMeta.isAutoIncrement(i);
            if (sqlTypeCode == 91 && this.dbType == 1) {
                sqlTypeCode = 93;
                displaySize = 22;
            }
            if (sqlTypeCode == -3 && this.dbType == 5 && sqlTypeStr.startsWith("BIT")) {
                sqlTypeCode = -7;
            }
            if (sqlTypeCode == -2 && this.dbType == 2 && precision == 8) {
                autoIncrement = true;
            }
            DBColumn col = new DBColumn(table, colName, sqlTypeCode, sqlTypeStr, scale, precision, isNullable, autoIncrement);
            col.setOrdinalPosition(position);
            col.setDisplayName(displayName);
            col.setDisplaySize(displaySize);
            table.addColumn(col);
            table.setQuoter(this.sqlquoter);
        }
        DBTable table = (DBTable)tables.get(noTableName);
        if (tables.size() == 1 && table != null && isSelect) {
            this.adjustTableMetadata(sql, (DBTable)tables.get(noTableName));
            for (DBColumn col : table.getColumns().values()) {
                col.setEditable(!table.getName().equals("") && !col.isGenerated());
            }
        }
        return tables.values();
    }

    public void postprocessTables(Collection<DBTable> tables) {
        DBModel dbModel = new DBModel();
        dbModel.setDBType(this.dbType);
        for (DBTable tbl : tables) {
            if (DataViewUtils.isNullString(tbl.getName())) continue;
            this.checkPrimaryKeys(tbl);
            this.checkForeignKeys(tbl);
            dbModel.addTable(tbl);
            this.populateDefaults(tbl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDefaults(DBTable table) {
        ResultSet rs = null;
        try {
            rs = this.dbmeta.getColumns(this.setToNullIfEmpty(table.getCatalog()), this.setToNullIfEmpty(table.getSchema()), table.getName(), "%");
            while (rs.next()) {
                String defaultValue = rs.getString("COLUMN_DEF");
                DBColumn col = table.getColumn(rs.getString("COLUMN_NAME"));
                if (col == null || defaultValue == null || defaultValue.trim().length() == 0) continue;
                col.setDefaultValue(defaultValue.trim());
            }
        }
        catch (NullPointerException | SQLException exception) {
            DataViewUtils.closeResources(rs);
        }
        catch (Throwable throwable) {
            DataViewUtils.closeResources(rs);
            throw throwable;
        }
        DataViewUtils.closeResources(rs);
    }

    private void adjustTableMetadata(String sql, DBTable table) {
        String[] splitByDot;
        String tableName = "";
        if (sql.toUpperCase().contains("FROM")) {
            String[] splitByFrom = sql.toUpperCase().split("FROM");
            String fromsql = sql.substring(sql.length() - splitByFrom[1].length());
            if (fromsql.toUpperCase().contains("WHERE")) {
                splitByFrom = fromsql.toUpperCase().split("WHERE");
                fromsql = fromsql.substring(0, splitByFrom[0].length());
            } else if (fromsql.toUpperCase().contains("ORDER BY")) {
                splitByFrom = fromsql.toUpperCase().split("ORDER BY");
                fromsql = fromsql.substring(0, splitByFrom[0].length());
            }
            if (!sql.toUpperCase().contains("JOIN")) {
                StringTokenizer t = new StringTokenizer(fromsql, ",");
                if (t.hasMoreTokens()) {
                    tableName = t.nextToken().trim();
                }
                if (t.hasMoreTokens()) {
                    tableName = "";
                }
            }
        }
        if ((splitByDot = tableName.split("\\.")).length == 3) {
            table.setCatalogName(this.unQuoteIfNeeded(splitByDot[0]));
            table.setSchemaName(this.unQuoteIfNeeded(splitByDot[1]));
            table.setName(this.unQuoteIfNeeded(splitByDot[2]));
        } else if (splitByDot.length == 2) {
            table.setSchemaName(this.unQuoteIfNeeded(splitByDot[0]));
            table.setName(this.unQuoteIfNeeded(splitByDot[1]));
        } else if (splitByDot.length == 1) {
            table.setName(this.unQuoteIfNeeded(splitByDot[0]));
        }
    }

    private String unQuoteIfNeeded(String id) {
        return id.replaceAll(this.identifierQuoteString, "");
    }

    private void checkPrimaryKeys(DBTable newTable) {
        DBPrimaryKey keys = this.getPrimaryKeys(newTable.getCatalog(), newTable.getSchema(), newTable.getName());
        if (keys != null && keys.getColumnCount() != 0) {
            newTable.setPrimaryKey(keys);
            List<DBColumn> columns = newTable.getColumnList();
            if (columns != null) {
                for (int i = 0; i < columns.size(); ++i) {
                    DBColumn col = columns.get(i);
                    if (!keys.contains(col.getName())) continue;
                    col.setPrimaryKey(true);
                }
            }
        }
    }

    private void checkForeignKeys(DBTable newTable) {
        Map<String, DBForeignKey> foreignKeys = this.getForeignKeys(newTable);
        if (foreignKeys != null && !foreignKeys.isEmpty()) {
            newTable.setForeignKeyMap(foreignKeys);
            HashSet<String> foreignKeysSet = new HashSet<String>();
            for (DBForeignKey key : foreignKeys.values()) {
                if (key == null) continue;
                foreignKeysSet.addAll(key.getColumnNames());
            }
            List<DBColumn> columns = newTable.getColumnList();
            if (columns != null) {
                for (int i = 0; i < columns.size(); ++i) {
                    DBColumn col = columns.get(i);
                    if (!foreignKeysSet.contains(col.getName())) continue;
                    col.setForeignKey(true);
                }
            }
        }
    }

    private String setToNullIfEmpty(String source) {
        if (source != null && source.equals("")) {
            source = null;
        }
        return source;
    }
}

