/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.refactoring;

import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, String name, OffsetRange range, Icon icon) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.parentFile);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhereUsedElement create(FileObject fileObject, String name, OffsetRange range, ElementKind kind) {
        ImageIcon icon = UiUtils.getElementIcon((ElementKind)kind, Collections.emptyList());
        int start = range.getStart();
        int end = range.getEnd();
        int sta = start;
        int en = start;
        String content = null;
        BaseDocument bdoc = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
        StringBuilder displayText = new StringBuilder();
        try {
            bdoc.readLock();
            content = bdoc.getText(0, bdoc.getLength());
            sta = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)bdoc, (int)start);
            if (sta == -1) {
                sta = LineDocumentUtils.getLineStartOffset((LineDocument)bdoc, (int)start);
            }
            en = (en = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)bdoc, (int)start)) == -1 ? LineDocumentUtils.getLineEndOffset((LineDocument)bdoc, (int)start) : ++en;
            if (end > en && (end = start + name.length()) > bdoc.getLength()) {
                end = bdoc.getLength();
            }
        }
        catch (Exception ex) {
            content = "n/a";
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            bdoc.readUnlock();
        }
        if (end < sta) {
            sta = end;
        }
        if (start < sta) {
            start = sta;
        }
        if (en < end) {
            en = end;
        }
        displayText.append(WhereUsedElement.encodeCharRefs(content.subSequence(sta, start).toString()));
        displayText.append("<b>");
        displayText.append(content.subSequence(start, end));
        displayText.append("</b>");
        displayText.append(WhereUsedElement.encodeCharRefs(content.subSequence(end, en).toString()));
        CloneableEditorSupport ces = GsfUtilities.findCloneableEditorSupport((FileObject)fileObject);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, displayText.toString().trim(), fileObject, name, new OffsetRange(start, end), icon);
    }

    private static String encodeCharRefs(String htmlCode) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < htmlCode.length(); ++i) {
            String repl;
            char c = htmlCode.charAt(i);
            switch (c) {
                case '<': {
                    repl = LT;
                    break;
                }
                case '>': {
                    repl = GT;
                    break;
                }
                default: {
                    repl = null;
                }
            }
            buf.append(repl == null ? Character.valueOf(c) : repl);
        }
        return buf.toString();
    }

    public static WhereUsedElement create(CloneableEditorSupport ces, FileObject fo, String name, String html, OffsetRange range, Icon icon) {
        int start = range.getStart();
        int end = range.getEnd();
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, html, fo, name, new OffsetRange(start, end), icon);
    }
}

