/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.netbeans.spi.sendopts.Env;

final class CodeNameMatcher {
    private final Pattern[] patterns;

    private CodeNameMatcher(Pattern[] arr) {
        this.patterns = arr;
    }

    static CodeNameMatcher create(Env env, String[] pattern) {
        Pattern[] arr = new Pattern[pattern.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                arr[i] = Pattern.compile(pattern[i]);
                continue;
            }
            catch (PatternSyntaxException e) {
                env.getErrorStream().println(Bundle.MSG_CantCompileRegex(pattern[i]));
            }
        }
        return new CodeNameMatcher(arr);
    }

    boolean matches(String txt) {
        for (Pattern p : this.patterns) {
            if (p == null || !p.matcher(txt).matches()) continue;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.patterns.length == 0;
    }

    public String toString() {
        return Arrays.toString(this.patterns);
    }
}

