/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import java.util.Map;
import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Packet;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Type;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Value;

public final class V8Event
extends V8Packet {
    private final Kind eventKind;
    private final V8Body body;
    private final ReferencedValue[] referencedValues;
    private Map<Long, V8Value> valuesByReferences;
    private final PropertyBoolean running;
    private final PropertyBoolean success;
    private final String errorMessage;

    public V8Event(long sequence, Kind eventKind, V8Body body, ReferencedValue[] referencedValues, Boolean running, Boolean success, String errorMessage) {
        super(sequence, V8Type.event);
        this.eventKind = eventKind;
        this.body = body;
        this.referencedValues = referencedValues;
        this.running = new PropertyBoolean(running);
        this.success = new PropertyBoolean(success);
        this.errorMessage = errorMessage;
    }

    public Kind getKind() {
        return this.eventKind;
    }

    public V8Body getBody() {
        return this.body;
    }

    public ReferencedValue[] getReferencedValues() {
        return this.referencedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8Value getReferencedValue(long reference) {
        if (this.referencedValues == null || this.referencedValues.length == 0) {
            return null;
        }
        V8Event v8Event = this;
        synchronized (v8Event) {
            if (this.valuesByReferences == null) {
                this.valuesByReferences = V8Response.createValuesByReference(this.referencedValues);
            }
            return this.valuesByReferences.get(reference);
        }
    }

    public PropertyBoolean isRunning() {
        return this.running;
    }

    public PropertyBoolean getSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum Kind {
        Break,
        Exception,
        AfterCompile,
        ScriptCollected,
        CompileError;


        public String toString() {
            String str = super.toString();
            return Character.toLowerCase(str.charAt(0)) + str.substring(1);
        }

        static Kind fromString(String eventName) {
            eventName = Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1);
            return Kind.valueOf(eventName);
        }
    }
}

