/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class MethodIdMap {
    private static final String ANONYMOUS_PACKAGE_STRING = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("MethodIdMap_AnonymousPackageString");
    private ArrayList classOrPackageNames;
    private Map classIdCache;
    private int[] classIds;
    private int curClassId;
    private int newView;

    public MethodIdMap(String[] methodLevelInstrClassNames, int nInstrMethods, int newView) {
        this.newView = newView;
        this.classIds = new int[nInstrMethods];
        this.classIdCache = new ConcurrentHashMap();
        this.classOrPackageNames = new ArrayList();
        this.curClassId = 0;
        this.classOrPackageNames.add(methodLevelInstrClassNames[0]);
        this.classIds[0] = 0;
        for (int i = 1; i < nInstrMethods; ++i) {
            this.classIds[i] = this.getClassId(methodLevelInstrClassNames[i]);
        }
        this.classIdCache = null;
    }

    public int getClassOrPackageIdForMethodId(int methodId) {
        return this.classIds[methodId];
    }

    public String[] getInstrClassesOrPackages() {
        String[] ret = this.classOrPackageNames.toArray(new String[0]);
        this.classOrPackageNames = null;
        return ret;
    }

    public int getNInstrClassesOrPackages() {
        return this.curClassId + 1;
    }

    private int getClassId(String className) {
        String name = this.newView == 1 ? className : this.getPackageName(className);
        Integer classId = (Integer)this.classIdCache.get(name);
        if (classId == null) {
            ++this.curClassId;
            this.classOrPackageNames.add(name);
            this.classIdCache.put(name, this.curClassId);
            return this.curClassId;
        }
        return classId;
    }

    private String getPackageName(String className) {
        int lastDivPos = className.lastIndexOf(46);
        if (lastDivPos == -1) {
            return ANONYMOUS_PACKAGE_STRING;
        }
        return className.substring(0, lastDivPos).intern();
    }
}

