/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.webkit;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.Reader;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.render.JSC;
import org.netbeans.html.presenters.render.Show;
import org.netbeans.html.presenters.webkit.UnJarResources;

public final class WebKitPresenter
implements Fn.Presenter,
Fn.KeepAlive,
Executor {
    private static final Logger LOG = Logger.getLogger(WebKitPresenter.class.getName());
    private final Show shell;
    private Runnable onPageLoad;
    private OnFinalize onFinalize;
    private Pointer ctx;
    private Pointer javaClazz;
    private final Map<Object, Object> toJava = new HashMap<Object, Object>();
    private Pointer arrayLength;
    private Pointer valueTrue;
    private Pointer valueFalse;
    private String onPageApp;
    private static final ReferenceQueue<? super Object> QUEUE = new ReferenceQueue();
    private static final Set<Protector> ALL = new HashSet<Protector>();

    public WebKitPresenter() {
        this(false);
    }

    public WebKitPresenter(boolean headless) {
        this.shell = Show.open((Fn.Presenter)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                WebKitPresenter.this.onPageLoad.run();
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                WebKitPresenter.this.jsContext(WebKitPresenter.this.shell.jsContext());
            }
        }, (boolean)headless);
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineFn(code, names, (boolean[])null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        PointerByReference exc;
        JSC jsc = this.shell.jsc();
        Pointer[] jsNames = new Pointer[names.length];
        for (int i = 0; i < jsNames.length; ++i) {
            jsNames[i] = jsc.JSStringCreateWithUTF8CString(names[i]);
        }
        Pointer jsCode = jsc.JSStringCreateWithUTF8CString(code);
        Pointer fn = jsc.JSObjectMakeFunction(this.ctx, null, names.length, jsNames, jsCode, null, 1, exc = new PointerByReference());
        if (fn == null) {
            throw new IllegalStateException("Cannot initialize function: " + exc.getValue());
        }
        jsc.JSStringRelease(jsCode);
        for (Pointer jsName : jsNames) {
            jsc.JSStringRelease(jsName);
        }
        return new JSCFn(fn, keepAlive);
    }

    public void displayPage(URL page, Runnable onPageLoad) {
        this.onPageLoad = onPageLoad;
        this.onPageApp = WebKitPresenter.findCalleeClassName();
        try {
            if ("jar".equals(page.getProtocol())) {
                page = UnJarResources.extract(page);
            }
            this.shell.show(page.toURI());
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception t) {
            if (t.getCause() instanceof Error) {
                throw (Error)t.getCause();
            }
            if (t.getCause() instanceof RuntimeException) {
                throw (RuntimeException)t.getCause();
            }
            throw new RuntimeException(t);
        }
    }

    public void loadScript(Reader code) throws Exception {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = code.read()) != -1) {
            sb.append((char)ch);
        }
        Pointer script = this.shell.jsc().JSStringCreateWithUTF8CString(sb.toString());
        PointerByReference ex = new PointerByReference();
        this.shell.jsc().JSEvaluateScript(this.ctx, script, null, null, 1, ex);
        this.shell.jsc().JSStringRelease(script);
        if (ex.getValue() != null) {
            throw new Exception(this.convertToString(this.shell.jsc(), ex.getValue()));
        }
    }

    Pointer[] convertFromJava(Object ... args) throws Exception {
        return this.convertFromJava(args, (boolean[])null);
    }

    Pointer[] convertFromJava(Object[] args, boolean[] keepAlive) throws Exception {
        JSC jsc = this.shell.jsc();
        Pointer[] arr = new Pointer[args.length];
        for (int i = 0; i < arr.length; ++i) {
            Pointer[] content;
            Object v = args[i];
            if (v == null) {
                v = jsc.JSValueMakeNull(this.ctx);
            } else if (v instanceof Number) {
                v = jsc.JSValueMakeNumber(this.ctx, ((Number)v).doubleValue());
            } else if (v instanceof Boolean) {
                v = (Boolean)v != false ? this.valueTrue : this.valueFalse;
            } else if (v instanceof String) {
                Pointer str = jsc.JSStringCreateWithUTF8CString((String)v);
                v = jsc.JSValueMakeString(this.ctx, str);
                jsc.JSStringRelease(str);
            } else if (v instanceof Enum) {
                Pointer str = jsc.JSStringCreateWithUTF8CString(((Enum)v).name());
                v = jsc.JSValueMakeString(this.ctx, str);
                jsc.JSStringRelease(str);
            } else if (v instanceof Character) {
                v = jsc.JSValueMakeNumber(this.ctx, (double)((Character)v).charValue());
            } else if (v instanceof JSObject) {
                v = ((JSObject)v).value;
            } else if (v instanceof int[]) {
                int[] numbers = (int[])v;
                content = new Pointer[numbers.length];
                for (int j = 0; j < content.length; ++j) {
                    content[j] = jsc.JSValueMakeNumber(this.ctx, (double)numbers[j]);
                }
                v = jsc.JSObjectMakeArray(this.ctx, content.length, content, null);
            } else if (v instanceof double[]) {
                double[] numbers = (double[])v;
                content = new Pointer[numbers.length];
                for (int j = 0; j < content.length; ++j) {
                    content[j] = jsc.JSValueMakeNumber(this.ctx, numbers[j]);
                }
                v = jsc.JSObjectMakeArray(this.ctx, content.length, content, null);
            } else if (v instanceof Object[]) {
                Pointer[] content2 = this.convertFromJava((Object[])v);
                v = jsc.JSObjectMakeArray(this.ctx, content2.length, content2, null);
            } else if (v.getClass().isArray()) {
                int len = Array.getLength(v);
                Object[] boxed = new Object[len];
                for (int j = 0; j < len; ++j) {
                    boxed[j] = Array.get(v, j);
                }
                Pointer[] content3 = this.convertFromJava(boxed);
                v = jsc.JSObjectMakeArray(this.ctx, content3.length, content3, null);
            } else if (v.getClass().getSimpleName().equals("$JsCallbacks$")) {
                Pointer vm = jsc.JSObjectMake(this.ctx, null, null);
                for (Method method : v.getClass().getMethods()) {
                    if (method.getDeclaringClass() != v.getClass()) continue;
                    Pointer name = jsc.JSStringCreateWithUTF8CString(method.getName());
                    FnCallback fnC = new FnCallback(v, method);
                    this.toJava.put(fnC, fnC);
                    Pointer fn = jsc.JSObjectMakeFunctionWithCallback(this.ctx, null, (Callback)fnC);
                    jsc.JSObjectSetProperty(this.ctx, vm, name, fn, 0, null);
                    jsc.JSStringRelease(name);
                }
                v = vm;
            } else {
                Pointer p = jsc.JSObjectMake(this.ctx, this.javaClazz, null);
                if (keepAlive == null || keepAlive[i]) {
                    this.toJava.put(p, v);
                } else {
                    this.toJava.put(p, new WeakVal(v));
                }
                this.protect(v, p);
                v = p;
            }
            arr[i] = (Pointer)v;
        }
        return arr;
    }

    final String convertToString(JSC jsc, Pointer value) {
        Object ret;
        int type = jsc.JSValueGetType(this.ctx, value);
        if (type == 5) {
            Pointer toStr = jsc.JSStringCreateWithUTF8CString("this.toString()");
            value = jsc.JSEvaluateScript(this.ctx, toStr, value, null, 0, null);
            jsc.JSStringRelease(toStr);
        }
        return (ret = this.convertToJava(jsc, String.class, value)) != null ? ret.toString() : "<null value>";
    }

    final Object convertToJava(JSC jsc, Class<?> expectedType, Pointer value) throws IllegalStateException {
        int type = jsc.JSValueGetType(this.ctx, value);
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                double probability = jsc.JSValueToNumber(this.ctx, value, null);
                if (expectedType == Boolean.TYPE) {
                    expectedType = Boolean.class;
                }
                return expectedType.cast(probability >= 0.5);
            }
            case 3: {
                Double ret = jsc.JSValueToNumber(this.ctx, value, null);
                if (expectedType.isInstance(ret) || expectedType == Double.TYPE) {
                    return ret;
                }
                if (expectedType == Integer.class || expectedType == Integer.TYPE) {
                    return ret.intValue();
                }
                if (expectedType == Float.class || expectedType == Float.TYPE) {
                    return Float.valueOf(ret.floatValue());
                }
                if (expectedType == Long.class || expectedType == Long.TYPE) {
                    return ret.longValue();
                }
                if (expectedType == Short.class || expectedType == Short.TYPE) {
                    return ret.shortValue();
                }
                if (expectedType == Byte.class || expectedType == Byte.TYPE) {
                    return ret.byteValue();
                }
                if (expectedType == Character.class || expectedType == Character.TYPE) {
                    return Character.valueOf((char)ret.intValue());
                }
                throw new ClassCastException("Cannot convert double to " + expectedType);
            }
            case 4: {
                Pointer val = jsc.JSValueToStringCopy(this.ctx, value, null);
                int max = jsc.JSStringGetMaximumUTF8CStringSize(val);
                Memory mem = new Memory((long)max);
                jsc.JSStringGetUTF8CString(val, mem, max);
                return expectedType.cast(mem.getString(0L));
            }
            case 5: {
                Object ret;
                if (this.isJavaClazz(value)) {
                    ret = this.toJava.get(value);
                    if (ret instanceof WeakVal) {
                        ret = ((WeakVal)ret).get();
                    }
                } else {
                    PointerByReference ex = new PointerByReference();
                    Pointer checkArray = jsc.JSObjectCallAsFunction(this.ctx, this.arrayLength, null, 1, new Pointer[]{value}, ex);
                    if (checkArray == null) {
                        throw new RuntimeException(this.convertToString(jsc, ex.getValue()));
                    }
                    int len = (int)jsc.JSValueToNumber(this.ctx, checkArray, null);
                    if (len >= 0) {
                        Object[] arr = new Object[len];
                        for (int i = 0; i < len; ++i) {
                            Pointer val = jsc.JSObjectGetPropertyAtIndex(this.ctx, value, i, null);
                            arr[i] = this.convertToJava(jsc, Object.class, val);
                        }
                        return arr;
                    }
                    ret = new JSObject(this, value);
                }
                return expectedType.cast(ret);
            }
        }
        throw new IllegalStateException("Uknown type: " + type);
    }

    @Override
    public void execute(Runnable command) {
        this.shell.execute(command);
    }

    final void jsContext(Pointer ctx) {
        Pointer arrFn;
        this.ctx = ctx;
        JSC jsc = this.shell.jsc();
        this.onFinalize = new OnFinalize();
        this.javaClazz = jsc.JSClassCreate(new JSC.JSClassDefinition((Callback)this.onFinalize));
        boolean testInstance = false;
        if (!$assertionsDisabled) {
            testInstance = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (testInstance) {
            Pointer testObj = jsc.JSObjectMake(ctx, this.javaClazz, null);
            assert (this.isJavaClazz(testObj)) : "Own classes has to be recognized";
        }
        Pointer jsGlobal = ctx;
        Pointer arrArg = jsc.JSStringCreateWithUTF8CString("x");
        Pointer arrT = jsc.JSStringCreateWithUTF8CString("var res = x.constructor === Array ? x.length : -1; return res;");
        this.arrayLength = arrFn = jsc.JSObjectMakeFunction(jsGlobal, null, 1, new Pointer[]{arrArg}, arrT, null, 0, null);
        jsc.JSValueProtect(ctx, arrFn);
        assert (!this.isJavaClazz(this.arrayLength)) : "functions aren't Java classes";
        Pointer trueScr = jsc.JSStringCreateWithUTF8CString("true");
        this.valueTrue = jsc.JSEvaluateScript(ctx, trueScr, null, null, 1, null);
        jsc.JSStringRelease(trueScr);
        jsc.JSValueProtect(ctx, this.valueTrue);
        int vT = jsc.JSValueGetType(ctx, this.valueTrue);
        assert (vT == 2);
        assert (!this.isJavaClazz(this.valueTrue)) : "true isn't Java class";
        Pointer falseScr = jsc.JSStringCreateWithUTF8CString("false");
        this.valueFalse = jsc.JSEvaluateScript(ctx, falseScr, null, null, 1, null);
        jsc.JSValueProtect(ctx, this.valueFalse);
        jsc.JSStringRelease(falseScr);
        int vF = jsc.JSValueGetType(ctx, this.valueFalse);
        assert (vF == 2);
        assert (!this.isJavaClazz(this.valueFalse)) : "false isn't Java class";
    }

    private boolean isJavaClazz(Pointer obj) {
        JSC jsc = this.shell.jsc();
        int type = jsc.JSValueGetType(this.ctx, obj);
        if (type != 5) {
            return false;
        }
        return jsc.JSValueIsObjectOfClass(this.ctx, obj, this.javaClazz);
    }

    final void onPageLoad() {
        String who = "WebKitPresenter:" + this.shell.getClass().getSimpleName();
        this.onPageLoad.run();
    }

    private void protect(Object obj, Pointer pointer) {
        JSC jsc = this.shell.jsc();
        jsc.JSValueProtect(this.ctx, pointer);
        ALL.add(new Protector(obj, pointer));
        this.cleanProtected();
    }

    private void cleanProtected() {
        Protector p;
        while ((p = (Protector)QUEUE.poll()) != null) {
            ALL.remove(p);
            p.unprotect();
        }
    }

    private static String findCalleeClassName() {
        StackTraceElement[] frames;
        for (StackTraceElement e : frames = new Exception().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.startsWith("com.dukescript.presenters.") || cn.startsWith("org.netbeans.html.") || cn.startsWith("net.java.html.") || cn.startsWith("java.") || cn.startsWith("javafx.") || cn.startsWith("com.sun.")) continue;
            return cn;
        }
        return "org.netbeans.html";
    }

    private static final class WeakVal
    extends WeakReference<Object> {
        public WeakVal(Object referent) {
            super(referent);
        }
    }

    private final class OnFinalize
    implements Callback {
        private OnFinalize() {
        }

        public void callback(Pointer obj) {
            Iterator it = WebKitPresenter.this.toJava.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != obj) continue;
                it.remove();
                break;
            }
        }
    }

    public final class FnCallback
    implements Callback {
        private final Object vm;
        private final Method method;

        public FnCallback(Object vm, Method method) {
            this.vm = vm;
            this.method = method;
        }

        public Pointer call(Pointer jsContextRef, Pointer jsFunction, Pointer thisObject, int argumentCount, PointerByReference ref, Pointer exception) throws Exception {
            JSC jsc = WebKitPresenter.this.shell.jsc();
            int size = Native.getNativeSize(Pointer.class);
            Object[] args = new Object[argumentCount];
            int i = 0;
            int offset = 0;
            while (i < argumentCount) {
                args[i] = WebKitPresenter.this.convertToJava(jsc, this.method.getParameterTypes()[i], ref.getPointer().getPointer((long)offset));
                ++i;
                offset += size;
            }
            return WebKitPresenter.this.convertFromJava(this.method.invoke(this.vm, args))[0];
        }
    }

    private final class JSCFn
    extends Fn {
        private final Pointer fn;
        private final boolean[] keepAlive;

        public JSCFn(Pointer fn, boolean[] keepAlive) {
            this.fn = fn;
            this.keepAlive = keepAlive;
            WebKitPresenter.this.protect((Object)this, fn);
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            WebKitPresenter.this.cleanProtected();
            JSC jsc = WebKitPresenter.this.shell.jsc();
            Pointer[] arr = WebKitPresenter.this.convertFromJava(args, this.keepAlive);
            Pointer jsThis = thiz == null ? null : WebKitPresenter.this.convertFromJava(thiz)[0];
            PointerByReference exception = new PointerByReference();
            Pointer ret = jsc.JSObjectCallAsFunction(WebKitPresenter.this.ctx, this.fn, jsThis, arr.length, arr, exception);
            if (exception.getValue() != null) {
                throw new Exception(WebKitPresenter.this.convertToString(jsc, exception.getValue()));
            }
            return WebKitPresenter.this.convertToJava(jsc, Object.class, ret);
        }
    }

    private final class Protector
    extends PhantomReference<Object> {
        private final Pointer pointer;

        public Protector(Object referent, Pointer p) {
            super(referent, QUEUE);
            this.pointer = p;
        }

        public void unprotect() {
            JSC jsc = WebKitPresenter.this.shell.jsc();
            jsc.JSValueUnprotect(WebKitPresenter.this.ctx, this.pointer);
        }
    }

    private static final class JSObject {
        private final Pointer value;

        public JSObject(WebKitPresenter p, Pointer val) {
            this.value = val;
            p.protect(this, val);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof JSObject && this.value.equals((Object)((JSObject)other).value);
        }
    }
}

