/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.spi;

import java.util.Iterator;
import java.util.List;
import org.netbeans.html.json.impl.SimpleList;
import org.netbeans.html.json.spi.Proto;

final class Observers {
    private static final List<Watcher> GLOBAL = SimpleList.asList(new Watcher[0]);
    private final List<Watcher> watchers = SimpleList.asList(new Watcher[0]);
    private final List<Ref> observers = SimpleList.asList(new Ref[0]);

    Observers() {
        assert (Thread.holdsLock(GLOBAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Usages beginComputing(Proto p, String name, Usages usages) {
        List<Watcher> list = GLOBAL;
        synchronized (list) {
            Observers.verifyUnlocked(p);
            Watcher nw = new Watcher(p, name);
            GLOBAL.add(nw);
            return Usages.register(name, nw, usages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyUnlocked(Proto p) {
        List<Watcher> list = GLOBAL;
        synchronized (list) {
            for (Watcher w : GLOBAL) {
                if (w.proto != p || w.owner != Thread.currentThread()) continue;
                throw new IllegalStateException("Re-entrant attempt to access " + p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void accessingValue(Proto p, String propName) {
        List<Watcher> list = GLOBAL;
        synchronized (list) {
            Observers.verifyUnlocked(p);
            for (Watcher w : GLOBAL) {
                Observers mine = p.observers(true);
                mine.add(w, new Ref(w, propName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void finishComputing(Proto p) {
        List<Watcher> list = GLOBAL;
        synchronized (list) {
            boolean found = false;
            Iterator<Watcher> it = GLOBAL.iterator();
            while (it.hasNext()) {
                Watcher w = it.next();
                if (w.proto != p || w.owner != Thread.currentThread()) continue;
                if (w.prop != null) {
                    Observers mine = p.observers(true);
                    mine.add(w);
                }
                found = true;
                it.remove();
            }
            if (!found) {
                throw new IllegalStateException("Cannot find " + p + " in " + GLOBAL);
            }
        }
    }

    private Watcher find(String prop) {
        if (prop == null) {
            return null;
        }
        for (Watcher w : this.watchers) {
            if (!prop.equals(w.prop)) continue;
            return w;
        }
        return null;
    }

    final void add(Watcher w) {
        for (int i = 0; i < this.watchers.size(); ++i) {
            Watcher ith = this.watchers.get(i);
            if (w.prop == null) {
                if (ith.prop != null) continue;
                this.watchers.set(i, w);
                return;
            }
            if (!w.prop.equals(ith.prop)) continue;
            this.watchers.set(i, w);
            return;
        }
        this.watchers.add(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void valueHasMutated(Proto p, String propName) {
        List<Watcher> mutated = SimpleList.asList(new Watcher[0]);
        List<Watcher> list = GLOBAL;
        synchronized (list) {
            Observers mine = p.observers(false);
            if (mine == null) {
                return;
            }
            Iterator<Ref> it = mine.observers.iterator();
            while (it.hasNext()) {
                Watcher w;
                Ref ref = it.next();
                if (ref.get() == null) {
                    it.remove();
                    continue;
                }
                if (!ref.prop.equals(propName) || (w = ref.watcher()) == null) continue;
                mutated.add(w);
            }
        }
        for (Watcher w : mutated) {
            w.proto.valueHasMutated(w.prop);
        }
    }

    void add(Watcher w, Ref r) {
        Thread.holdsLock(GLOBAL);
        if (w == null) {
            return;
        }
        Iterator<Ref> it = this.observers.iterator();
        while (it.hasNext()) {
            Ref ref = it.next();
            if (r == ref) {
                return;
            }
            Watcher rw = ref.get();
            if (rw == null) {
                it.remove();
                continue;
            }
            if (rw != w || !ref.prop.equals(r.prop)) continue;
            return;
        }
        this.observers.add(r);
    }

    static final class Usages {
        private final List<String> names = SimpleList.asList(new String[0]);
        private final List<Watcher> watchers = SimpleList.asList(new Watcher[0]);

        private Usages() {
        }

        static Usages register(String propName, Watcher w, Usages usages) {
            if (propName != null) {
                int index;
                if (usages == null) {
                    usages = new Usages();
                }
                if ((index = usages.names.indexOf(propName)) == -1) {
                    usages.names.add(propName);
                    usages.watchers.add(w);
                } else {
                    Watcher prev = usages.watchers.get(index);
                    prev.destroy();
                    usages.watchers.set(index, w);
                }
            }
            return usages;
        }
    }

    private static final class Watcher {
        Proto proto;
        final Thread owner = Thread.currentThread();
        final String prop;

        Watcher(Proto proto, String prop) {
            this.proto = proto;
            this.prop = prop;
        }

        public String toString() {
            return "Watcher: " + this.proto + ", " + this.prop;
        }

        void destroy() {
            this.proto = null;
        }
    }

    private static final class Ref {
        private final Watcher ref;
        private final String prop;

        public Ref(Watcher ref, String prop) {
            this.ref = ref;
            this.prop = prop;
        }

        final Watcher watcher() {
            Watcher w = this.get();
            if (w == null) {
                return null;
            }
            Observers o = w.proto.observers(false);
            if (o == null) {
                return null;
            }
            if (o.find(w.prop) == w) {
                return w;
            }
            return null;
        }

        Watcher get() {
            return this.ref.proto == null ? null : this.ref;
        }
    }
}

