/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.java.html.BrwsrCtx;
import org.netbeans.html.json.impl.Bindings;
import org.netbeans.html.json.impl.JSON;
import org.netbeans.html.json.impl.PropertyBindingAccessor;
import org.netbeans.html.json.impl.RcvrJSON;
import org.netbeans.html.json.spi.JSONCall;
import org.netbeans.html.json.spi.Proto;

public abstract class PropertyBinding {
    PropertyBinding() {
    }

    public abstract String getPropertyName();

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public abstract boolean isReadOnly();

    public abstract PropertyBinding weak();

    static {
        new PropertyBindingAccessor(){

            @Override
            protected JSONCall newCall(BrwsrCtx ctx, RcvrJSON callback, String urlBefore, String urlAfter, String method, Object data) {
                return new JSONCall(ctx, callback, urlBefore, urlAfter, method, data);
            }

            @Override
            protected Bindings bindings(Proto proto, boolean initialize) {
                return initialize ? proto.initBindings() : proto.getBindings();
            }

            @Override
            protected void notifyChange(Proto proto, int propIndex) {
                proto.onChange(propIndex);
            }

            @Override
            protected Proto findProto(Proto.Type<?> type, Object object) {
                return type.protoFor(object);
            }

            @Override
            protected <Model> Model cloneTo(Proto.Type<Model> type, Model model, BrwsrCtx c) {
                return type.cloneTo(model, c);
            }

            @Override
            protected Object read(Proto.Type<?> from, BrwsrCtx c, Object data) {
                return from.read(c, data);
            }

            @Override
            protected <M> PropertyBinding newBinding(Proto.Type<M> access, Bindings<?> bindings, String name, int index, M model, boolean readOnly) {
                return new Impl<M>(model, bindings, name, index, access, readOnly);
            }
        };
    }

    private static final class Weak<M>
    extends AImpl<M> {
        private final Reference<M> ref;

        public Weak(M model, Bindings<?> bindings, String name, int index, Proto.Type<M> access, boolean readOnly) {
            super(bindings, name, index, access, readOnly);
            this.ref = new WeakReference<M>(model);
        }

        @Override
        protected M model() {
            return this.ref.get();
        }

        @Override
        public PropertyBinding weak() {
            return this;
        }
    }

    private static final class Impl<M>
    extends AImpl<M> {
        private final M model;

        public Impl(M model, Bindings<?> bindings, String name, int index, Proto.Type<M> access, boolean readOnly) {
            super(bindings, name, index, access, readOnly);
            this.model = model;
        }

        @Override
        protected M model() {
            return this.model;
        }

        @Override
        public PropertyBinding weak() {
            return new Weak<M>(this.model, this.bindings, this.name, this.index, this.access, this.readOnly);
        }
    }

    private static abstract class AImpl<M>
    extends PropertyBinding {
        public final String name;
        public final boolean readOnly;
        final Proto.Type<M> access;
        final Bindings<?> bindings;
        final int index;

        public AImpl(Bindings<?> bindings, String name, int index, Proto.Type<M> access, boolean readOnly) {
            this.bindings = bindings;
            this.name = name;
            this.index = index;
            this.access = access;
            this.readOnly = readOnly;
        }

        protected abstract M model();

        @Override
        public void setValue(Object v) {
            M model = this.model();
            if (model == null) {
                return;
            }
            this.access.setValue(model, this.index, v);
        }

        @Override
        public Object getValue() {
            M model = this.model();
            if (model == null) {
                return null;
            }
            Object v = this.access.getValue(model, this.index);
            Object r = JSON.find(v, this.bindings);
            return r == null ? v : r;
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public String getPropertyName() {
            return this.name;
        }
    }
}

