/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.ArchetypeData;
import net.java.html.json.tests.ConstantModel;
import net.java.html.json.tests.KnockoutModel;
import net.java.html.json.tests.Pair;
import net.java.html.json.tests.PairModel;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.PhaseExecutor;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class KnockoutTest {
    private PhaseExecutor[] phases = new PhaseExecutor[1];

    static List<Integer> resultLengths(List<String> results) {
        Object[] arr = new Integer[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = results.get(i).length();
        }
        return Models.asList((Object[])arr);
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnEnum() throws Throwable {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: choice\"></input>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setChoice(Choice.A);
            m.applyBindings();
            return m;
        }).then(m -> {
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("A", v, "Value is really A: " + v);
            KnockoutTest.getSetInput("input", "B");
            KnockoutTest.triggerEvent("input", "change");
        }).then(m -> Utils.assertEquals((Object)Choice.B, (Object)m.getChoice(), "Enum property updated: " + (Object)((Object)m.getChoice()))).then(data -> {}).finalize(data -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void modifyRadioValueOnEnum() throws Throwable {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<input id='i1' type=\"radio\" name=\"choice\" value=\"A\" data-bind=\"checked: choice\"></input>Right\n<input id='input' type=\"radio\" name=\"choice\" value=\"B\" data-bind=\"checked: choice\"></input>Never\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setChoice(Choice.B);
            m.applyBindings();
            return m;
        }).then(m -> {
            Utils.assertFalse(KnockoutTest.isChecked("i1"), "B should be checked now");
            Utils.assertTrue(KnockoutTest.isChecked("input"), "B should be checked now");
            KnockoutTest.triggerEvent("i1", "click");
        }).then(m -> {
            Utils.assertEquals((Object)Choice.A, (Object)m.getChoice(), "Switched to A");
            Utils.assertTrue(KnockoutTest.isChecked("i1"), "A should be checked now");
            Utils.assertFalse(KnockoutTest.isChecked("input"), "A should be checked now");
            KnockoutTest.triggerEvent("input", "click");
        }).then(m -> Utils.assertEquals((Object)Choice.B, (Object)m.getChoice(), "Enum property updated: " + (Object)((Object)m.getChoice()))).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnDouble() throws Throwable {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: latitude\"></input>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setLatitude(50.5);
            m.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("50.5", v, "Value is really 50.5: " + v);
            KnockoutTest.getSetInput("input", "49.5");
            KnockoutTest.triggerEvent("input", "change");
            return m;
        }).then(m -> Utils.assertEquals(49.5, m.getLatitude(), "Double property updated: " + m.getLatitude())).finalize(data -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void rawObject() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            BrwsrCtx ctx = KnockoutTest.newContext();
            Person p1 = (Person)Models.bind((Object)new Person(), (BrwsrCtx)ctx);
            p1.setFirstName("Jarda");
            p1.setLastName("Tulach");
            Object raw = Models.toRaw((Object)p1);
            Person p2 = (Person)Models.fromRaw((BrwsrCtx)ctx, Person.class, (Object)raw);
            Utils.assertEquals(p2.getFirstName(), "Jarda", "First name");
            Utils.assertEquals(p2.getLastName(), "Tulach", "Last name");
            p2.setFirstName("Jirka");
            Utils.assertEquals(p2.getFirstName(), "Jirka", "First name updated");
            KnockoutModel js = new KnockoutModel();
            js.getPeople().add(p1);
            js.getPeople().add(p2);
            return js;
        }).then(js -> {
            Person p1 = js.getPeople().get(0);
            if (js.getPeople().size() == 2) {
                if (!"Jirka".equals(p1.getFirstName())) {
                    throw new InterruptedException();
                }
                Utils.assertEquals(p1.getFirstName(), "Jirka", "First name updated in original object");
                p1.setFirstName("Ondra");
                Utils.assertEquals(p1.getFirstName(), "Ondra", "1st name updated in original object");
                js.getPeople().add(p1);
            }
        }).then(js -> {
            Person p2 = js.getPeople().get(1);
            if (!"Ondra".equals(p2.getFirstName())) {
                throw new InterruptedException();
            }
            Utils.assertEquals(p2.getFirstName(), "Ondra", "1st name updated in copied object");
        }).start();
    }

    @KOTest
    public void modifyComputedProperty() throws Throwable {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "Full name: <div data-bind='with:firstPerson'>\n<input id='input' data-bind=\"value: fullName\"></input>\n</div>\n");
            KnockoutModel m = new KnockoutModel();
            m.getPeople().add(new Person());
            m = (KnockoutModel)Models.bind((Object)m, (BrwsrCtx)KnockoutTest.newContext());
            m.getFirstPerson().setFirstName("Jarda");
            m.getFirstPerson().setLastName("Tulach");
            m.applyBindings();
            return m;
        }).then(m -> {
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Jarda Tulach", v, "Value: " + v);
            KnockoutTest.getSetInput("input", "Mickey Mouse");
            KnockoutTest.triggerEvent("input", "change");
        }).then(m -> {
            Utils.assertEquals("Mickey", m.getFirstPerson().getFirstName(), "First name updated");
            Utils.assertEquals("Mouse", m.getFirstPerson().getLastName(), "Last name updated");
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void modifyValueAssertChangeInModelOnBoolean() throws Throwable {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "Latitude: <input id='input' data-bind=\"value: enabled\"></input>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setEnabled(true);
            m.applyBindings();
            return m;
        }).then(m -> {
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("true", v, "Value is really true: " + v);
            KnockoutTest.getSetInput("input", "false");
            KnockoutTest.triggerEvent("input", "change");
        }).then(m -> Utils.assertFalse(m.isEnabled(), "Boolean property updated: " + m.isEnabled())).then(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void modifyValueAssertChangeInModel() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.setName("Kukuc");
            m.applyBindings();
            return m;
        }).then(m -> {
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Kukuc", v, "Value is really kukuc: " + v);
        }).then(m -> {
            KnockoutTest.getSetInput("input", "Jardo");
            KnockoutTest.triggerEvent("input", "change");
        }).then(m -> Utils.assertEquals("Jardo", m.getName(), "Name property updated: " + m.getName())).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    private static String getSetSelected(int index, Object value) throws Exception {
        String s = "var index = arguments[0];\nvar n = window.document.getElementById('input');\n if (index >= 0) {\n    n.options.selectedIndex = index;\n    ko.utils.triggerEvent(n, 'change');\n}\n var op = n.options[n.selectedIndex];\nreturn op ? op.text : n.selectedIndex;\n";
        Object ret = Utils.executeScript(KnockoutTest.class, s, index, value);
        return ret == null ? null : ret.toString();
    }

    @KOTest
    public void selectWorksOnModels() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Utils.exposeHTML(KnockoutTest.class, "<select id='input' data-bind=\"options: archetypes,\n                       optionsText: 'name',\n                       value: archetype\">\n                  </select>\n");
            KnockoutModel km = new KnockoutModel();
            km.getArchetypes().add(new ArchetypeData("ko4j", "org.netbeans.html", "0.8.3", "ko4j", "ko4j", null));
            km.getArchetypes().add(new ArchetypeData("crud", "org.netbeans.html", "0.8.3", "crud", "crud", null));
            km.getArchetypes().add(new ArchetypeData("3rd", "org.netbeans.html", "0.8.3", "3rd", "3rd", null));
            KnockoutModel js = (KnockoutModel)Models.bind((Object)km, (BrwsrCtx)KnockoutTest.newContext());
            js.setArchetype(js.getArchetypes().get(1));
            js.applyBindings();
            return js;
        }).then(js -> {
            String v = KnockoutTest.getSetSelected(-1, null);
            Utils.assertEquals("crud", v, "Second index (e.g. crud) is selected: " + v);
            String sel = KnockoutTest.getSetSelected(2, Models.toRaw((Object)js.getArchetypes().get(2)));
            Utils.assertEquals("3rd", sel, "3rd is selected now: " + sel);
        }).then(js -> {
            if (js.getArchetype() != js.getArchetypes().get(2)) {
                throw new InterruptedException();
            }
        }).finalize(js -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void nestedObjectEqualsChange() throws Exception {
        this.nestedObjectEqualsChange(true);
    }

    @KOTest
    public void nestedObjectChange() throws Exception {
        this.nestedObjectEqualsChange(false);
    }

    private void nestedObjectEqualsChange(boolean preApply) throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: archetype'>\n    <input id='input' data-bind='value: groupId'></input>\n</div>\n");
            KnockoutModel js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            if (preApply) {
                js.applyBindings();
            }
            js.setArchetype((ArchetypeData)Models.bind((Object)new ArchetypeData(), (BrwsrCtx)KnockoutTest.newContext()));
            js.getArchetype().setGroupId("org.netbeans.html");
            js.applyBindings();
            return js;
        }).then(js -> {
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("org.netbeans.html", v, "groupId has been changed");
        }).finalize(js -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void modifyValueAssertAsyncChangeInModel() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Utils.exposeHTML(KnockoutTest.class, "<h1 data-bind=\"text: helloMessage\">Loading Bck2Brwsr's Hello World...</h1>\nYour name: <input id='input' data-bind=\"value: name\"></input>\n<button id=\"hello\">Say Hello!</button>\n");
            final KnockoutModel js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            js.setName("Kukuc");
            js.applyBindings();
            String v = KnockoutTest.getSetInput("input", null);
            Utils.assertEquals("Kukuc", v, "Value is really kukuc: " + v);
            Utils.scheduleLater(1, new Runnable(){

                @Override
                public void run() {
                    js.setName("Jardo");
                }
            });
            return js;
        }).then(data -> {
            String v = KnockoutTest.getSetInput("input", null);
            if (!"Jardo".equals(v)) {
                throw new InterruptedException();
            }
        }).finalize(data -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void nonMutableDouble() throws Exception {
        Utils.exposeTypeOf(KnockoutTest.class);
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: getTypeof(doubleValue)\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(10.0);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "number", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableString() throws Exception {
        Utils.exposeTypeOf(KnockoutTest.class);
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: getTypeof(stringValue)\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(10.0);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "string", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableBoolean() throws Exception {
        Utils.exposeTypeOf(KnockoutTest.class);
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: getTypeof(boolValue)\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignBoolValue(true);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "boolean", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    @KOTest
    public void nonMutableIntArray() throws Exception {
        Utils.exposeTypeOf(KnockoutTest.class);
        Utils.exposeHTML(KnockoutTest.class, "Type: <input id='input' data-bind=\"value: getTypeof(intArray)\"></input>\n");
        ConstantModel model = (ConstantModel)Models.bind((Object)new ConstantModel(), (BrwsrCtx)KnockoutTest.newContext());
        model.assignStringValue("Hello").assignDoubleValue(9.223372036854776E18).assignIntArray(1, 2, 3, 4);
        model.applyBindings();
        String v = KnockoutTest.getSetInput("input", null);
        Utils.assertEquals(v, "object", "Right type found: " + v);
        Utils.exposeHTML(KnockoutTest.class, "");
    }

    private static String getSetInput(String id, String value) throws Exception {
        String s = "var value = arguments[0];\nvar n = window.document.getElementById(arguments[1]);\n if (value != null) n['value'] = value;\n return n['value'];";
        Object ret = Utils.executeScript(KnockoutTest.class, s, value, id);
        return ret == null ? null : ret.toString();
    }

    private static boolean isChecked(String id) throws Exception {
        String s = "var n = window.document.getElementById(arguments[0]);\n return n['checked'];";
        Object ret = Utils.executeScript(KnockoutTest.class, s, id);
        return Boolean.TRUE.equals(ret);
    }

    public static void triggerEvent(String id, String ev) throws Exception {
        Utils.executeScript(KnockoutTest.class, "ko.utils.triggerEvent(window.document.getElementById(arguments[0]), arguments[1]);", id, ev);
    }

    @KOTest
    public void displayContentOfArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            m.getResults().add("Hi");
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(m -> {
            Utils.assertEquals(1, m.getCallbackCount(), "One callback " + m.getCallbackCount());
            Utils.assertEquals("Hi", m.getName(), "We got callback from 2nd child " + m.getName());
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfAsyncArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data, click: $root.call'/>\n</ul>\n");
            KnockoutModel js = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            js.getResults().add("Ahoj");
            js.applyBindings();
            return js;
        }).then(js -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            Utils.scheduleLater(1, new Runnable(){
                final /* synthetic */ KnockoutModel val$js;
                {
                    this.val$js = knockoutModel;
                }

                @Override
                public void run() {
                    this.val$js.getResults().add("Hi");
                }
            });
        }).then(js -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            if (cnt != 2) {
                throw new InterruptedException();
            }
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(js -> {
            Utils.assertEquals(1, js.getCallbackCount(), "One callback " + js.getCallbackCount());
            Utils.assertEquals("Hi", js.getName(), "We got callback from 2nd child " + js.getName());
        }).finalize(js -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfComputedArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul>\n");
            Pair m = (Pair)Models.bind((Object)new Pair("First", "Last", null), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(m -> {
            Utils.assertEquals("Last", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName());
            m.setLastName("Verylast");
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(m -> Utils.assertEquals("Verylast", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName())).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfComputedArrayOnASubpair() throws Exception {
        class ModelCtx {
            final Pair m;
            final BrwsrCtx ctx;

            ModelCtx(Pair m, BrwsrCtx ctx) {
                this.m = m;
                this.ctx = ctx;
            }
        }
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: next'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
            BrwsrCtx ctx = KnockoutTest.newContext();
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)ctx);
            m.applyBindings();
            return new ModelCtx(m, ctx);
        }).then(data -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(data -> {
            Utils.assertEquals(PairModel.ctx, data.ctx, "Context remains the same");
            Utils.assertEquals("Last", data.m.getFirstName(), "We got callback from 2nd child " + data.m.getFirstName());
        }).finalize(data -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfComputedArrayOnComputedASubpair() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div data-bind='with: nextOne'>\n<ul id='ul' data-bind='foreach: bothNames'>\n  <li data-bind='text: $data, click: $root.assignFirstName'/>\n</ul></div>\n");
            Pair m = (Pair)Models.bind((Object)new Pair(null, null, new Pair("First", "Last", null)), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(m -> Utils.assertEquals("Last", m.getFirstName(), "We got callback from 2nd child " + m.getFirstName())).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void checkBoxToBooleanBinding() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<input type='checkbox' id='b' data-bind='checked: enabled'></input>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            Utils.assertFalse(m.isEnabled(), "Is disabled");
            KnockoutTest.triggerClick("b");
            return m;
        }).then(m -> Utils.assertTrue(m.isEnabled(), "Now the model is enabled")).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfDerivedArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: cmpResults'>\n  <li><b data-bind='text: $data'></b></li>\n</ul>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            m.getResults().add("hello");
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void displayContentOfArrayOfPeople() throws Exception {
        class Data {
            final KnockoutModel m;
            final BrwsrCtx c;
            final Person first;

            Data(KnockoutModel m, BrwsrCtx c, Person first) {
                this.m = m;
                this.c = c;
                this.first = first;
            }
        }
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: $root.removePerson'></li>\n</ul>\n");
            BrwsrCtx c = KnockoutTest.newContext();
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)c);
            Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
            first.setFirstName("first");
            m.getPeople().add(first);
            m.applyBindings();
            return new Data(m, c, first);
        }).then(test -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            Person second = (Person)Models.bind((Object)new Person(), (BrwsrCtx)test.c);
            second.setFirstName("second");
            test.m.getPeople().add(second);
        }).then(test -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children now, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 1);
        }).then(test -> {
            KnockoutModel m = test.m;
            Utils.assertEquals(1, m.getCallbackCount(), "One callback " + m.getCallbackCount());
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "Again one child, but was " + cnt);
            String txt = KnockoutTest.childText("ul", 0);
            Utils.assertEquals("first", txt, "Expecting 'first': " + txt);
            test.first.setFirstName("changed");
            txt = KnockoutTest.childText("ul", 0);
            Utils.assertEquals("changed", txt, "Expecting 'changed': " + txt);
        }).finalize(test -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    static Person firstPerson(List<Person> people) {
        return people.isEmpty() ? null : people.get(0);
    }

    @KOTest
    public void accessFirstPersonWithOnFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<p id='ul' data-bind='with: firstPerson'>\n  <span data-bind='text: firstName, click: changeSex'></span>\n</p>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    @KOTest
    public void onPersonFunction() throws Exception {
        Object exp = Utils.exposeHTML(KnockoutTest.class, "<ul id='ul' data-bind='foreach: people'>\n  <li data-bind='text: $data.firstName, click: changeSex'></li>\n</ul>\n");
        try {
            this.trasfertToFemale();
        }
        finally {
            Utils.exposeHTML(KnockoutTest.class, "");
        }
    }

    private void trasfertToFemale() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            Person first = (Person)Models.bind((Object)new Person(), (BrwsrCtx)KnockoutTest.newContext());
            first.setFirstName("first");
            first.setSex(Sex.MALE);
            m.getPeople().add(first);
            m.applyBindings();
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            KnockoutTest.triggerChildClick("ul", 0);
            return first;
        }).then(first -> Utils.assertEquals((Object)first.getSex(), (Object)Sex.FEMALE, "Transverted to female: " + (Object)((Object)first.getSex()))).start();
    }

    @KOTest
    public void stringArrayModificationVisible() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: results'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            return m;
        }).then(data -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
        }).then(m -> {
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getResults().size(), 3, "Three java strings: " + m.getResults());
        }).finalize(data -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void intArrayModificationVisible() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: numbers'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getNumbers().add(1);
            m.getNumbers().add(31);
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "numbers", 42);
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
        }).then(m -> {
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getNumbers().size(), 3, "Three java ints: " + m.getNumbers());
            Utils.assertEquals(m.getNumbers().get(2), 42, "Meaning of world: " + m.getNumbers());
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void derivedIntArrayModificationVisible() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: resultLengths'>\n  <li data-bind='text: $data'></li>\n</ul>\n</div>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.getResults().add("Ahoj");
            m.getResults().add("Hello");
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Two children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "results", "Hi");
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 3, "Three elements in the array " + len);
        }).then(m -> {
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 3, "Three children in the DOM: " + newCnt);
            Utils.assertEquals(m.getResultLengths().size(), 3, "Three java ints: " + m.getResultLengths());
            Utils.assertEquals(m.getResultLengths().get(2), 2, "Size is two: " + m.getResultLengths());
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    @KOTest
    public void archetypeArrayModificationVisible() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object exp = Utils.exposeHTML(KnockoutTest.class, "<div>\n<ul id='ul' data-bind='foreach: archetypes'>\n  <li data-bind='text: artifactId'></li>\n</ul>\n</div>\n");
            KnockoutModel m = (KnockoutModel)Models.bind((Object)new KnockoutModel(), (BrwsrCtx)KnockoutTest.newContext());
            m.applyBindings();
            return m;
        }).then(m -> {
            int cnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 0, "No children " + cnt);
            Object arr = Utils.addChildren(KnockoutTest.class, "ul", "archetypes", new ArchetypeData("aid", "gid", "v", "n", "d", "u"));
            Utils.assertTrue(arr instanceof Object[], "Got back an array: " + arr);
            int len = ((Object[])arr).length;
            Utils.assertEquals(len, 1, "One element in the array " + len);
        }).then(m -> {
            int newCnt = Utils.countChildren(KnockoutTest.class, "ul");
            Utils.assertEquals(newCnt, 1, "One child in the DOM: " + newCnt);
            Utils.assertEquals(m.getArchetypes().size(), 1, "One archetype: " + m.getArchetypes());
            Utils.assertNotNull(m.getArchetypes().get(0), "Not null: " + m.getArchetypes());
            Utils.assertEquals(m.getArchetypes().get(0).getArtifactId(), "aid", "'aid' == " + m.getArchetypes());
        }).finalize(m -> Utils.exposeHTML(KnockoutTest.class, "")).start();
    }

    static void call(KnockoutModel m, String data) {
        m.setName(data);
        m.setCallbackCount(m.getCallbackCount() + 1);
    }

    static void removePerson(KnockoutModel model, Person data) {
        model.setCallbackCount(model.getCallbackCount() + 1);
        model.getPeople().remove(data);
    }

    static String helloMessage(String name) {
        return "Hello " + name + "!";
    }

    static List<String> cmpResults(List<String> results) {
        return results;
    }

    private static void triggerClick(String id) throws Exception {
        String s = "var id = arguments[0];var e = window.document.getElementById(id);\n if (e.checked) throw 'It should not be checked yet: ' + e;\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n e.dispatchEvent(ev);\n if (!e.checked) {\n  e.checked = true;\n   e.dispatchEvent(ev);\n }\n";
        Utils.executeScript(KnockoutTest.class, s, id);
    }

    private static void triggerChildClick(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];\nvar e = window.document.getElementById(id);\n var ev = window.document.createEvent('MouseEvents');\n ev.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n var list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].dispatchEvent(ev);\n}\nreturn null;\n";
        Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static String childText(String id, int pos) throws Exception {
        String s = "var id = arguments[0]; var pos = arguments[1];var e = window.document.getElementById(id);\nvar list = e.childNodes;\nvar cnt = -1;\nfor (var i = 0; i < list.length; i++) {\n  if (list[i].nodeType == 1) cnt++;\n  if (cnt == pos) return list[i].innerHTML;\n}\nreturn null;\n";
        return (String)Utils.executeScript(KnockoutTest.class, s, id, pos);
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(KnockoutTest.class);
    }

    static enum Choice {
        A,
        B;

    }

    static class ConstantCntrl {
        ConstantCntrl() {
        }
    }

    static class ArchModel {
        ArchModel() {
        }
    }
}

