/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.js.tests;

import net.java.html.js.tests.AsyncJava;
import net.java.html.js.tests.AsyncJavaScriptAction;
import net.java.html.js.tests.Bodies;
import net.java.html.js.tests.JavaScriptBodyTest;
import net.java.html.json.tests.PhaseExecutor;
import org.netbeans.html.json.tck.KOTest;

public class AsyncJavaTest {
    private final PhaseExecutor[] phases = new PhaseExecutor[]{null};

    @KOTest
    public void dontWaitForJavaFactorial() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            Object[] arr = new Object[]{null, false};
            arr[0] = AsyncJava.computeInAsyncJava(5, n -> {
                int acc = 1;
                for (int i = 1; i <= n; ++i) {
                    acc *= i;
                }
                return acc;
            }, () -> {
                arr[1] = true;
            });
            JavaScriptBodyTest.assertFalse((Boolean)arr[1], "Promise.then shall only be called when the code ends");
            return arr;
        }).then(arr -> {
            int result = Bodies.readIntX(arr[0]);
            JavaScriptBodyTest.assertEquals(result, 120);
        }).start();
    }

    @KOTest
    public void initializedFromJavaScript() throws Exception {
        this.initializedFromJavaScript(true);
    }

    @KOTest
    public void initializedFromJavaScriptNoWait4js() throws Exception {
        this.initializedFromJavaScript(false);
    }

    private void initializedFromJavaScript(boolean wait4js) throws Exception {
        PhaseExecutor.schedule(this.phases, () -> AsyncJavaScriptAction.defineCallback(wait4js)).then(action -> action.invokeCallbackLater(33)).then(action -> {
            int r = action.getResult();
            JavaScriptBodyTest.assertEquals(r, 33, "Set to 33");
        }).then(action -> action.invokeCallbackLater(42)).then(action -> JavaScriptBodyTest.assertEquals(action.getResult(), 42, "Set to 42")).start();
    }
}

