/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.js.tests;

import java.util.List;
import net.java.html.js.tests.Bodies;
import net.java.html.js.tests.JavaScriptBodyTest;
import net.java.html.js.tests.Sum;
import net.java.html.json.Models;
import org.netbeans.html.json.tck.KOTest;

public class ExposedPropertiesTest {
    @KOTest
    public void exposedPropertiesOfAJavaObject() {
        Sum s = new Sum();
        Object[] props = Bodies.forIn(s);
        List all = Models.asList((Object[])props);
        JavaScriptBodyTest.assertEquals(0, all.size(), "No own properties: " + all);
    }

    @KOTest
    public void exposedEqualsOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "equals", s);
    }

    @KOTest
    public void exposedHashCodeOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "hashCode", null);
    }

    @KOTest
    public void exposedWaitOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "wait", null);
    }

    @KOTest
    public void exposedGetClassOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "getClass", null);
    }

    @KOTest
    public void exposedNotifyOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "notify", null);
    }

    @KOTest
    public void exposedNotifyAllOfAJavaObject() {
        Sum s = new Sum();
        ExposedPropertiesTest.assertNoProp(s, "notifyAll", null);
    }

    @KOTest
    public void exposedEqualsOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "equals", s);
    }

    @KOTest
    public void exposedHashCodeOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "hashCode", null);
    }

    @KOTest
    public void exposedWaitOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "wait", null);
    }

    @KOTest
    public void exposedGetClassOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "getClass", null);
    }

    @KOTest
    public void exposedNotifyOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "notify", null);
    }

    @KOTest
    public void exposedNotifyAllOfAJavaArray() {
        Object[] s = new Object[5];
        ExposedPropertiesTest.assertNoProp(s, "notifyAll", null);
    }

    @KOTest
    public void exposedEqualsOfAJavaPrimitiveArray() {
        int[] s = new int[5];
        ExposedPropertiesTest.assertNoProp(s, "equals", s);
    }

    @KOTest
    public void exposedHashCodeOfAJavaPrimitiveArray() {
        int[] s = new int[5];
        ExposedPropertiesTest.assertNoProp(s, "hashCode", null);
    }

    @KOTest
    public void exposedWaitOfAJavaPrimitiveArray() {
        int[] s = new int[5];
        ExposedPropertiesTest.assertNoProp(s, "wait", null);
    }

    @KOTest
    public void exposedGetClassOfAJavaPrimitiveArray() {
        int[] s = new int[5];
        ExposedPropertiesTest.assertNoProp(s, "getClass", null);
    }

    @KOTest
    public void exposedNotifyOfAJavaPrimitiveArray() {
        int[] s = new int[5];
        ExposedPropertiesTest.assertNoProp(s, "notify", null);
    }

    private static void assertNoProp(Object obj, String name, Object arg) {
        Object prop = Bodies.get(obj, name);
        JavaScriptBodyTest.assertNull(prop, "Expecting no value for property " + name + ", but was " + Bodies.typeof(prop, false));
        try {
            Object res = Bodies.invoke(obj, name, arg);
            if (name.equals(res)) {
                return;
            }
            JavaScriptBodyTest.fail("Invoking " + name + " on " + obj + " returned " + res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

