/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.ArrayList;
import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.ObtainData;
import net.java.html.json.tests.ObtainMessage;
import net.java.html.json.tests.ObtainUser;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public class ObtainAndComputeTest {
    ObtainData m;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void obtainAndComputeTest() throws Throwable {
        if (this.m == null) {
            BrwsrCtx ctx = Utils.newContext(ObtainAndComputeTest.class);
            Utils.exposeHTML(ObtainAndComputeTest.class, "<input type=\"text\" data-bind=\"textInput: filter\">\n<ul id='list' data-bind=\"foreach: filteredUsers\">\n   <li><div data-bind=\"text: email\"></div></li>\n</ul>\n<button id='button' data-bind=\"click: nextUsers\">more...</button>");
            String d = "{\n    \"data\": [{\n            \"id\": 1,\n            \"email\": \"george.bluth@gmail.com\"\n        }, {\n            \"id\": 2,\n            \"email\": \"janet.weaver@gmail.com\"\n        }, {\n            \"id\": 3,\n            \"email\": \"emma.wong@gmail.com\"\n        }, {\n            \"email\": \"eve.holt@gmail.com\"\n        }, {\n            \"email\": \"charles.morris@rgmail.com\"\n        }, {\n            \"id\": 6,\n            \"email\": \"tracey.ramos@gmail.com\"\n        }]\n}\n";
            String url = Utils.prepareURL(ObtainAndComputeTest.class, d, "application/json", new String[0]);
            this.m = (ObtainData)Models.bind((Object)new ObtainData("holt", url, false, new ObtainUser[0]), (BrwsrCtx)ctx);
            this.m.applyBindings();
            int cnt = Utils.countChildren(ObtainAndComputeTest.class, "list");
            Utils.assertEquals(cnt, 0, "No filtered users so far: " + cnt);
            Utils.scheduleClick(ObtainAndComputeTest.class, "button", 100);
        }
        if (!this.m.isGotReply()) {
            throw new InterruptedException();
        }
        try {
            Utils.assertEquals(6, this.m.getUsers().size(), "Expecting some users: " + this.m);
            Utils.assertEquals(1, this.m.getFilteredUsers().size(), "Only one holt matching filter: " + this.m);
            int cnt = Utils.countChildren(ObtainAndComputeTest.class, "list");
            Utils.assertEquals(cnt, 1, "Also one user: " + cnt);
        }
        finally {
            Utils.exposeHTML(ObtainAndComputeTest.class, "");
        }
    }

    static final class ObtainModel {
        ObtainModel() {
        }

        public static List<ObtainUser> filteredUsers(List<ObtainUser> users, String filter) {
            ArrayList<ObtainUser> res = new ArrayList<ObtainUser>();
            for (ObtainUser user : users) {
                if (!user.getEmail().contains(filter)) continue;
                res.add(user);
            }
            return res;
        }

        public static void nextUsers(ObtainData model) {
            model.loadUsers(model.getUrl());
        }

        public static void loadUsers(ObtainData model, ObtainMessage reply) {
            model.getUsers().addAll(reply.getData());
            model.setGotReply(true);
        }

        public static class UserVMD {
        }

        public static class MessageVMD {
        }
    }
}

