/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class ConvertTypesTest {
    private static InputStream createIS(boolean includeSex, boolean includeAddress, int array) throws UnsupportedEncodingException {
        int repeat;
        StringBuilder sb = new StringBuilder();
        if (array != -1) {
            sb.append("[\n");
            repeat = array;
        } else {
            repeat = 1;
        }
        for (int i = 0; i < repeat; ++i) {
            sb.append("{ \"firstName\" : \"son\",\n");
            sb.append("  \"lastName\" : \"dj\" \n");
            if (includeSex) {
                sb.append(",  \"sex\" : \"MALE\" \n");
            }
            if (includeAddress) {
                sb.append(",  \"address\" : { \"street\" : \"Schnirchova\" } \n");
            }
            sb.append("}\n");
            if (i >= array - 1) continue;
            sb.append(",");
        }
        if (array != -1) {
            sb.append(']');
        }
        return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
    }

    private static Object createJSON(boolean includeSex) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("firstName", "son");
        map.put("lastName", "dj");
        if (includeSex) {
            map.put("sex", "MALE");
        }
        return Utils.createObject(map, ConvertTypesTest.class);
    }

    @KOTest
    public void testConvertToPeople() throws Exception {
        Object o = ConvertTypesTest.createJSON(true);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeople() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, false, -1);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeopleWithAddress() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, true, -1);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
        assert (p.getAddress() != null) : "Some address provided";
        assert (p.getAddress().getStreet().equals("Schnirchova")) : "Is Schnirchova: " + p.getAddress();
    }

    @KOTest
    public void parseConvertToPeopleWithAddressIntoAnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, true, -1);
        ArrayList arr = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)o, arr);
        assert (arr.size() == 1) : "There is one item in " + arr;
        Person p = (Person)arr.get(0);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
        assert (p.getAddress() != null) : "Some address provided";
        assert (p.getAddress().getStreet().equals("Schnirchova")) : "Is Schnirchova: " + p.getAddress();
    }

    @KOTest
    public void parseNullValue() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"firstName\" : \"son\",\n");
        sb.append("  \"lastName\" : null } \n");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)is);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert (null == p.getLastName()) : "Last name: " + p.getLastName();
    }

    @KOTest
    public void parseNullArrayValue() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        StringBuilder sb = new StringBuilder();
        sb.append("[ null, { \"firstName\" : \"son\",\n");
        sb.append("  \"lastName\" : null } ]\n");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        ArrayList arr = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)is, arr);
        assert (arr.size() == 2) : "There are two items in " + arr;
        assert (arr.get(0) == null) : "first is null " + arr;
        Person p = (Person)arr.get(1);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert (null == p.getLastName()) : "Last name: " + p.getLastName();
    }

    @KOTest
    public void testConvertToPeopleWithoutSex() throws Exception {
        Object o = ConvertTypesTest.createJSON(false);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeopleWithoutSex() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false, -1);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeopleWithAddressOnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, true, 1);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
        assert (p.getAddress() != null) : "Some address provided";
        assert (p.getAddress().getStreet().equals("Schnirchova")) : "Is Schnirchova: " + p.getAddress();
    }

    @KOTest
    public void parseConvertToPeopleWithoutSexOnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false, 1);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseFirstElementFromAbiggerArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false, 5);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseAllElementFromAbiggerArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false, 5);
        ArrayList res = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)o, res);
        assert (res.size() == 5) : "Five elements found" + res;
        for (Person p : res) {
            assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
            assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
            assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
        }
    }

    @KOTest
    public void parseOnEmptyArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false, 0);
        try {
            Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        }
        catch (EOFException ex) {
            return;
        }
        throw new IllegalStateException("Should throw end of file exception, as the array is empty");
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(ConvertTypesTest.class);
    }
}

