/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.js.tests;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.java.html.js.tests.Bodies;
import net.java.html.js.tests.Receiver;
import net.java.html.js.tests.Sum;
import org.netbeans.html.json.tck.KOTest;

public class GCBodyTest {
    Reference<?> ref;
    int[] arr;

    @KOTest
    public void callbackInterfaceCanDisappear() throws InterruptedException {
        if (this.ref != null) {
            GCBodyTest.assertGC(this.ref, "Can disappear!");
            return;
        }
        Sum s = new Sum();
        int res = Bodies.sumIndirect(s, 22, 20);
        assert (res == 42) : "Expecting 42";
        WeakReference<Sum> ref = new WeakReference<Sum>(s);
        s = null;
        GCBodyTest.assertGC(ref, "Can disappear!");
    }

    private Object assignInst() {
        Object obj = Bodies.instance(0);
        EmptyInstance s = new EmptyInstance();
        Bodies.setX(obj, s);
        assert (s == Bodies.readX(obj));
        this.ref = new WeakReference<EmptyInstance>(s);
        return obj;
    }

    @KOTest
    public void holdObjectAndReleaseObject() throws InterruptedException {
        if (this.ref != null) {
            GCBodyTest.assertGC(this.ref, "Can disappear!");
            return;
        }
        Object obj = this.assignInst();
        assert (this.ref != null);
        GCBodyTest.assertGC(this.ref, "Can disappear as it is keepAlive false!");
        assert (obj != null) : "Object is still present";
    }

    @KOTest
    public void strongReceiverBehavior() {
        EmptyInstance v = new EmptyInstance();
        Receiver r = new Receiver(v);
        r.apply();
        assert (v == r.value) : "Value is as expected";
    }

    @KOTest
    public void gcReceiverBehavior() throws InterruptedException {
        Receiver r = new Receiver(new EmptyInstance());
        GCBodyTest.assertGC(r.ref, "The empty instance can be GCed even when referenced from JS");
        r.apply();
        assert (r.value == null) : "Setter called with null value";
    }

    private static Reference<?> sendRunnable(final int[] arr) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                arr[0] = arr[0] + 1;
            }
        };
        Bodies.asyncCallback(r);
        return new WeakReference<1>(r);
    }

    @KOTest
    public void parametersNeedToRemainInAsyncMode() throws InterruptedException {
        if (this.ref != null) {
            if (this.arr[0] != 1) {
                throw new InterruptedException();
            }
            GCBodyTest.assertGC(this.ref, "Now the runnable can disappear");
            return;
        }
        this.arr = new int[]{0};
        this.ref = GCBodyTest.sendRunnable(this.arr);
        if (this.arr[0] == 1) {
            return;
        }
        GCBodyTest.assertNotGC(this.ref, false, "The runnable should not be GCed");
        throw new InterruptedException();
    }

    private static void assertGC(Reference<?> ref, String msg) throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            if (GCBodyTest.isGone(ref)) {
                return;
            }
            long then = System.currentTimeMillis();
            int size = Bodies.gc(Math.pow(2.0, i));
            long took = System.currentTimeMillis() - then;
            if (took > 3000L) {
                throw new InterruptedException(msg + " - giving up after " + took + " ms at size of " + size);
            }
            try {
                System.gc();
                System.runFinalization();
                continue;
            }
            catch (Error err) {
                err.printStackTrace();
            }
        }
        throw new InterruptedException(msg);
    }

    private static boolean isGone(Reference<?> ref) {
        return ref.get() == null;
    }

    private static void assertNotGC(Reference<?> ref, boolean clearJS, String msg) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            if (ref.get() == null) {
                throw new IllegalStateException(msg);
            }
            if (clearJS) {
                Bodies.gc(Math.pow(2.0, i));
            }
            try {
                System.gc();
                System.runFinalization();
                continue;
            }
            catch (Error err) {
                err.printStackTrace();
            }
        }
    }

    private static class EmptyInstance {
        private EmptyInstance() {
        }
    }
}

