/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.geo;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.html.geo.impl.JsG;

public final class Position {
    static final Logger LOG = Logger.getLogger(Position.class.getName());
    private final long timestamp;
    private final Coordinates coords;

    Position(Object position) {
        Object obj = JsG.get(position, "timestamp");
        this.timestamp = obj instanceof Number ? ((Number)obj).longValue() : 0L;
        this.coords = new Coordinates(JsG.get(position, "coords"));
    }

    public Coordinates getCoords() {
        return this.coords;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static abstract class Handle {
        private final boolean oneTime;
        private boolean enableHighAccuracy;
        private long timeout;
        private long maximumAge;
        volatile JsH handle;

        protected Handle(boolean oneTime) {
            this.oneTime = oneTime;
        }

        protected abstract void onLocation(Position var1) throws Throwable;

        protected abstract void onError(Exception var1) throws Throwable;

        public final boolean isSupported() {
            return JsG.hasGeolocation();
        }

        public final void setHighAccuracy(boolean enable) {
            this.enableHighAccuracy = enable;
        }

        public final void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public final void setMaximumAge(long age) {
            this.maximumAge = age;
        }

        public final void start() {
            if (this.handle != null) {
                return;
            }
            this.handle = new JsH();
            try {
                if (!this.isSupported()) {
                    throw new IllegalStateException("geolocation API not supported");
                }
                this.handle.start();
            }
            catch (Exception ex) {
                try {
                    this.onError(ex);
                }
                catch (Throwable thr) {
                    LOG.log(Level.INFO, "Problems delivering onError report", thr);
                }
            }
        }

        public final void stop() {
            JsH h = this.handle;
            if (h == null) {
                return;
            }
            this.handle = null;
            h.stop();
        }

        private final class JsH
        extends JsG {
            long watch;

            private JsH() {
            }

            @Override
            public void onLocation(Object position) {
                if (Handle.this.handle != this) {
                    return;
                }
                if (Handle.this.oneTime) {
                    this.stop();
                }
                try {
                    Handle.this.onLocation(new Position(position));
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void onError(final String message, int code) {
                if (Handle.this.handle != this) {
                    return;
                }
                if (Handle.this.oneTime) {
                    this.stop();
                }
                try {
                    Exception err = new Exception(message + " errno: " + code){

                        @Override
                        public String getLocalizedMessage() {
                            return message;
                        }
                    };
                    Handle.this.onError(err);
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }

            final void start() {
                this.watch = this.start(Handle.this.oneTime, Handle.this.enableHighAccuracy, Handle.this.timeout, Handle.this.maximumAge);
            }

            protected final void stop() {
                super.stop(this.watch);
            }
        }
    }

    public static final class Coordinates {
        private final Object data;

        Coordinates(Object data) {
            this.data = data;
        }

        public double getLatitude() {
            return ((Number)JsG.get(this.data, "latitude")).doubleValue();
        }

        public double getLongitude() {
            return ((Number)JsG.get(this.data, "longitude")).doubleValue();
        }

        public double getAccuracy() {
            return ((Number)JsG.get(this.data, "accuracy")).doubleValue();
        }

        public Double getAltitude() {
            return (Double)JsG.get(this.data, "altitude");
        }

        public Double getAltitudeAccuracy() {
            return (Double)JsG.get(this.data, "altitudeAccuracy");
        }

        public Double getHeading() {
            return (Double)JsG.get(this.data, "heading");
        }

        public Double getSpeed() {
            return (Double)JsG.get(this.data, "speed");
        }
    }
}

