/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.netbeans.html.boot.fx.FXConsole;
import org.netbeans.html.boot.fx.FXPresenter;

public class FXBrwsr
extends Application {
    private static final Logger LOG = Logger.getLogger(FXBrwsr.class.getName());
    private static FXBrwsr INSTANCE;
    private static final CountDownLatch FINISHED;
    private BorderPane root;

    public static synchronized WebView findWebView(final URL url, final FXPresenter onLoad) {
        if (INSTANCE == null) {
            Executors.newFixedThreadPool(1).submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FXBrwsr.launch(FXBrwsr.class, (String[])new String[0]);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        FINISHED.countDown();
                    }
                }
            });
        }
        while (INSTANCE == null) {
            try {
                FXBrwsr.class.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (!Platform.isFxApplicationThread()) {
            final WebView[] arr = new WebView[]{null};
            final CountDownLatch waitForResult = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    arr[0] = INSTANCE.newView(url, onLoad);
                    waitForResult.countDown();
                }
            });
            while (true) {
                try {
                    waitForResult.await();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, null, ex);
                    continue;
                }
                break;
            }
            return arr[0];
        }
        return INSTANCE.newView(url, onLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage primaryStage) throws Exception {
        Class<FXBrwsr> clazz = FXBrwsr.class;
        synchronized (FXBrwsr.class) {
            INSTANCE = this;
            FXBrwsr.class.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            BorderPane r = new BorderPane();
            Scene scene = new Scene((Parent)r, 800.0, 600.0);
            primaryStage.setScene(scene);
            primaryStage.show();
            this.root = r;
            return;
        }
    }

    private WebView newView(final URL url, final FXPresenter onLoad) {
        final WebView view = new WebView();
        view.setContextMenuEnabled(false);
        view.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                final Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.setTitle("Warning");
                Button button = new Button("Close");
                Text text = new Text((String)t.getData());
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(new Insets(10.0));
                box.getChildren().addAll((Object[])new Node[]{text, button});
                dialogStage.setScene(new Scene((Parent)box));
                button.setCancelButton(true);
                button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        dialogStage.close();
                    }
                });
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
            }
        });
        this.root.setCenter((Node)view);
        final Worker w = view.getEngine().getLoadWorker();
        w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
            private String previous;

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                    FXConsole.register(view.getEngine());
                    onLoad.onPageLoad();
                }
                if (newState.equals((Object)Worker.State.FAILED)) {
                    throw new IllegalStateException("Failed to load " + url);
                }
            }

            private boolean checkValid() {
                String crnt = view.getEngine().getLocation();
                if (this.previous != null && !this.previous.equals(crnt)) {
                    w.stateProperty().removeListener((ChangeListener)this);
                    return false;
                }
                this.previous = crnt;
                return true;
            }
        });
        return view;
    }

    static void waitFinished() {
        while (true) {
            try {
                FINISHED.await();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, null, ex);
                continue;
            }
            break;
        }
    }

    static {
        FINISHED = new CountDownLatch(1);
    }
}

