/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import org.netbeans.html.boot.fx.FXInspect;
import org.netbeans.html.boot.fx.WatchDir;

final class FXToolbar
extends ToolBar {
    private final ArrayList<ResizeBtn> resizeButtons;
    private final WebView webView;
    private final BorderPane container;
    private final ToggleGroup resizeGroup = new ToggleGroup();
    private final ComboBox<String> comboZoom = new ComboBox();
    private WatchDir watcher;

    FXToolbar(WebView wv, BorderPane container) {
        this.webView = wv;
        this.container = container;
        List<ResizeOption> options = ResizeOption.loadAll();
        options.add(0, ResizeOption.SIZE_TO_FIT);
        this.resizeButtons = new ArrayList(options.size());
        for (ResizeOption ro : options) {
            ResizeBtn button = new ResizeBtn(ro);
            this.resizeButtons.add(button);
            this.resizeGroup.getToggles().add((Object)button);
            this.getItems().add((Object)button);
        }
        this.resizeButtons.get(0).setSelected(true);
        this.resizeGroup.selectedToggleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                FXToolbar.this.resize();
            }
        });
        this.getItems().add((Object)new Separator());
        this.getItems().add(this.comboZoom);
        ArrayList<String> zoomModel = new ArrayList<String>(6);
        zoomModel.add("200%");
        zoomModel.add("150%");
        zoomModel.add("100%");
        zoomModel.add("75%");
        zoomModel.add("50%");
        this.comboZoom.setItems(FXCollections.observableList(zoomModel));
        this.comboZoom.setEditable(true);
        this.comboZoom.setValue((Object)"100%");
        this.comboZoom.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                String newZoom = FXToolbar.this.zoom(t1);
                FXToolbar.this.comboZoom.setValue((Object)newZoom);
            }
        });
        this.getItems().add((Object)new Separator());
        final CheckBox automatic = new CheckBox("Automatic");
        final Preferences prefs = Preferences.userNodeForPackage(FXToolbar.class);
        String ar = "automaticReload";
        automatic.setSelected(prefs.getBoolean("automaticReload", true));
        this.getItems().add((Object)automatic);
        Button reload = new Button("Reload");
        this.getItems().add((Object)reload);
        reload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXToolbar.this.webView.getEngine().reload();
            }
        });
        automatic.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                prefs.putBoolean("automaticReload", automatic.isSelected());
                FXToolbar.this.listenOnChanges(automatic.isSelected());
            }
        });
        this.webView.getEngine().locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FXToolbar.this.listenOnChanges(automatic.isSelected());
            }
        });
    }

    private String zoom(String zoomFactor) {
        if (zoomFactor.trim().isEmpty()) {
            return null;
        }
        try {
            zoomFactor = zoomFactor.replaceAll("\\%", "");
            zoomFactor = zoomFactor.trim();
            double zoom = Double.parseDouble(zoomFactor);
            zoom = Math.abs(zoom) / 100.0;
            if (zoom <= 0.0) {
                return null;
            }
            this.webView.setScaleX(zoom);
            this.webView.setScaleY(zoom);
            this.webView.setScaleZ(zoom);
            return (int)(100.0 * zoom) + "%";
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void resize() {
        Toggle selection = this.resizeGroup.getSelectedToggle();
        if (selection instanceof ResizeBtn) {
            ResizeOption ro = ((ResizeBtn)selection).getResizeOption();
            if (ro == ResizeOption.SIZE_TO_FIT) {
                this._autofit();
            } else {
                this._resize(ro.getWidth(), ro.getHeight());
            }
        }
    }

    private void _resize(double width, double height) {
        ScrollPane scroll;
        if (this.container.getCenter() == this.webView) {
            scroll = new ScrollPane();
            scroll.setContent((Node)this.webView);
            this.container.setCenter((Node)scroll);
        } else {
            scroll = (ScrollPane)this.container.getCenter();
        }
        scroll.setPrefViewportWidth(width);
        scroll.setPrefViewportHeight(height);
        this.webView.setMaxWidth(width);
        this.webView.setMaxHeight(height);
        this.webView.setMinWidth(width);
        this.webView.setMinHeight(height);
    }

    private void _autofit() {
        if (this.container.getCenter() != this.webView) {
            this.container.setCenter((Node)this.webView);
        }
        this.webView.setMaxWidth(2.147483647E9);
        this.webView.setMaxHeight(2.147483647E9);
        this.webView.setMinWidth(-1.0);
        this.webView.setMinHeight(-1.0);
        this.webView.autosize();
    }

    private void listenOnChanges(boolean turnOn) {
        try {
            if (this.watcher != null) {
                this.watcher.close();
                this.watcher = null;
            }
            if (turnOn) {
                this.watcher = new WatchDir(this.webView.getEngine());
            }
        }
        catch (Exception ex) {
            FXInspect.LOG.log(Level.SEVERE, null, ex);
        }
    }

    static final class ResizeOption {
        private final Type type;
        private final String displayName;
        private final int width;
        private final int height;
        private final boolean isDefault;
        public static final ResizeOption SIZE_TO_FIT = new ResizeOption(Type.CUSTOM, "Size To Fit", -1, -1, true, true);

        private ResizeOption(Type type, String displayName, int width, int height, boolean showInToolbar, boolean isDefault) {
            this.type = type;
            this.displayName = displayName;
            this.width = width;
            this.height = height;
            this.isDefault = isDefault;
        }

        static List<ResizeOption> loadAll() {
            ArrayList<ResizeOption> res = new ArrayList<ResizeOption>(10);
            res.add(ResizeOption.create(Type.DESKTOP, "Desktop", 1280, 1024, true, true));
            res.add(ResizeOption.create(Type.TABLET_LANDSCAPE, "Tablet Landscape", 1024, 768, true, true));
            res.add(ResizeOption.create(Type.TABLET_PORTRAIT, "Tablet Portrait", 768, 1024, true, true));
            res.add(ResizeOption.create(Type.SMARTPHONE_LANDSCAPE, "Smartphone Landscape", 480, 320, true, true));
            res.add(ResizeOption.create(Type.SMARTPHONE_PORTRAIT, "Smartphone Portrait", 320, 480, true, true));
            res.add(ResizeOption.create(Type.WIDESCREEN, "Widescreen", 1680, 1050, false, true));
            res.add(ResizeOption.create(Type.NETBOOK, "Netbook", 1024, 600, false, true));
            return res;
        }

        public static ResizeOption create(Type type, String displayName, int width, int height, boolean showInToolbar, boolean isDefault) {
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("Invalid screen dimensions: " + width + " x " + height);
            }
            return new ResizeOption(type, displayName, width, height, showInToolbar, isDefault);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Type getType() {
            return this.type;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String toString() {
            return this.displayName;
        }

        public String getToolTip() {
            if (this.width < 0 || this.height < 0) {
                return this.displayName;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.width);
            sb.append(" x ");
            sb.append(this.height);
            sb.append(" (");
            sb.append(this.displayName);
            sb.append(')');
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResizeOption other = (ResizeOption)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            if (this.width != other.width) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            return this.isDefault == other.isDefault;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.type != null ? this.type.hashCode() : 0);
            hash = 11 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            hash = 11 * hash + this.width;
            hash = 11 * hash + this.height;
            hash = 11 * hash + (this.isDefault ? 1 : 0);
            return hash;
        }

        static enum Type {
            DESKTOP("desktop.png"),
            TABLET_PORTRAIT("tabletPortrait.png"),
            TABLET_LANDSCAPE("tabletLandscape.png"),
            SMARTPHONE_PORTRAIT("handheldPortrait.png"),
            SMARTPHONE_LANDSCAPE("handheldLandscape.png"),
            WIDESCREEN("widescreen.png"),
            NETBOOK("netbook.png"),
            CUSTOM("sizeToFit.png");

            private final String resource;

            private Type(String r) {
                this.resource = r;
            }

            public Image getImage() {
                return new Image(Type.class.getResourceAsStream(this.resource));
            }
        }
    }

    static final class ResizeBtn
    extends ToggleButton {
        private final ResizeOption resizeOption;

        ResizeBtn(ResizeOption resizeOption) {
            super(null, (Node)new ImageView(ResizeBtn.toImage(resizeOption)));
            this.resizeOption = resizeOption;
            this.setTooltip(new Tooltip(resizeOption.getToolTip()));
        }

        ResizeOption getResizeOption() {
            return this.resizeOption;
        }

        static Image toImage(ResizeOption ro) {
            if (ro == ResizeOption.SIZE_TO_FIT) {
                return ResizeOption.Type.CUSTOM.getImage();
            }
            return ro.getType().getImage();
        }
    }
}

