/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.fx;

import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebView;
import net.java.html.boot.BrowserBuilder;
import org.netbeans.html.boot.fx.AbstractFXPresenter;

public final class FXBrowsers {
    private FXBrowsers() {
    }

    public static void load(WebView webView, URL url, Class<?> onPageLoad, String methodName, String ... args) {
        BrowserBuilder.newBrowser((Object[])new Object[]{new Load(webView)}).loadPage(url.toExternalForm()).loadClass(onPageLoad).invoke(methodName, args).showAndWait();
    }

    public static void load(WebView webView, URL url, Runnable onPageLoad) {
        BrowserBuilder.newBrowser((Object[])new Object[]{new Load(webView)}).loadPage(url.toExternalForm()).loadFinished(onPageLoad).showAndWait();
    }

    public static void runInBrowser(WebView webView, Runnable code) {
        Object ud = webView.getUserData();
        if (!(ud instanceof Load)) {
            throw new IllegalArgumentException();
        }
        ((Load)ud).execute(code);
    }

    private static class Load
    extends AbstractFXPresenter {
        private final WebView webView;

        public Load(WebView webView) {
            webView.setUserData((Object)this);
            this.webView = webView;
        }

        @Override
        protected void waitFinished() {
        }

        @Override
        protected WebView findView(final URL resource) {
            final Worker w = this.webView.getEngine().getLoadWorker();
            w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
                private String previous;

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                    if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                        Load.this.onPageLoad();
                    }
                    if (newState.equals((Object)Worker.State.FAILED)) {
                        this.checkValid();
                        throw new IllegalStateException("Failed to load " + resource);
                    }
                }

                private boolean checkValid() {
                    String crnt = Load.this.webView.getEngine().getLocation();
                    if (this.previous != null && !this.previous.equals(crnt)) {
                        w.stateProperty().removeListener((ChangeListener)this);
                        return false;
                    }
                    this.previous = crnt;
                    return true;
                }
            });
            return this.webView;
        }
    }
}

