/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import javafx.util.Callback;
import org.netbeans.html.boot.fx.Dbgr;

final class FXInspect
implements Runnable {
    private static final Logger LOG = Logger.getLogger(FXInspect.class.getName());
    private final WebEngine engine;
    private final ObjectInputStream input;
    private Dbgr dbg;

    private FXInspect(WebEngine engine, int port) throws IOException {
        this.engine = engine;
        Socket socket = new Socket(InetAddress.getByName(null), port);
        ObjectOutputStream output = new ObjectOutputStream(socket.getOutputStream());
        this.input = new ObjectInputStream(socket.getInputStream());
        this.initializeDebugger(output);
    }

    static boolean initialize(WebEngine engine) {
        int inspectPort = Integer.getInteger("netbeans.inspect.port", -1);
        if (inspectPort != -1) {
            try {
                FXInspect inspector = new FXInspect(engine, inspectPort);
                Thread t = new Thread((Runnable)inspector, "FX<->NetBeans Inspector");
                t.start();
                return true;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Cannot connect to NetBeans IDE to port " + inspectPort, ex);
            }
        }
        return false;
    }

    private void initializeDebugger(final ObjectOutputStream output) {
        Platform.runLater((Runnable)new Runnable(){

            public void run() {
                FXInspect.this.dbg = new Dbgr(FXInspect.this.engine, new Callback<String, Void>(){

                    public Void call(String message) {
                        try {
                            byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
                            output.writeInt(bytes.length);
                            output.write(bytes);
                            output.flush();
                        }
                        catch (IOException ioex) {
                            ioex.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public void run() {
        try {
            while (true) {
                int length = this.input.readInt();
                byte[] bytes = new byte[length];
                this.input.readFully(bytes);
                final String message = new String(bytes, StandardCharsets.UTF_8);
                Platform.runLater((Runnable)new Runnable(){

                    public void run() {
                        FXInspect.this.dbg.sendMessage(message);
                    }
                });
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
            return;
        }
    }
}

