/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.ClassReader;

@Mojo(name="process-js-annotations", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public final class ProcessJsAnnotationsMojo
extends AbstractMojo {
    @Component
    private MavenProject prj;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File classes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedList<URL> arr = new LinkedList<URL>();
        boolean foundAsm = false;
        for (Artifact a : this.prj.getArtifacts()) {
            File f = a.getFile();
            if (f == null) continue;
            if (a.getArtifactId().equals("asm")) {
                foundAsm = true;
            }
            try {
                arr.add(f.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (!foundAsm) {
            URL loc = ClassReader.class.getProtectionDomain().getCodeSource().getLocation();
            arr.addFirst(loc);
        }
        URLClassLoader l = new URLClassLoader(arr.toArray(new URL[arr.size()]));
        try {
            File master = new File(new File(this.classes, "META-INF"), "net.java.html.js.classes");
            this.processClasses(l, master, this.classes);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Problem converting JavaScriptXXX annotations", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClasses(ClassLoader l, File master, File f) throws IOException, MojoExecutionException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            boolean classes = new File(f, "net.java.html.js.classes").exists();
            File[] arr = f.listFiles();
            if (arr != null) {
                for (File file : arr) {
                    if (!classes && !file.isDirectory()) continue;
                    this.processClasses(l, master, file);
                }
            }
            return;
        }
        if (!f.getName().endsWith(".class")) {
            return;
        }
        byte[] arr = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        try {
            ProcessJsAnnotationsMojo.readArr(arr, is);
        }
        finally {
            is.close();
        }
        byte[] newArr = null;
        try {
            Class<?> fnUtils = l.loadClass("org.netbeans.html.boot.impl.FnUtils");
            Method transform = fnUtils.getMethod("transform", byte[].class, ClassLoader.class);
            newArr = (byte[])transform.invoke(null, arr, l);
            if (newArr == null || newArr == arr) {
                return;
            }
            ProcessJsAnnotationsMojo.filterClass(new File(f.getParentFile(), "net.java.html.js.classes"), f.getName());
            ProcessJsAnnotationsMojo.filterClass(master, f.getName());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Can't process " + f, ex);
        }
        this.getLog().info((CharSequence)("Processing " + f));
        this.writeArr(f, newArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArr(File f, byte[] newArr) throws IOException, FileNotFoundException {
        FileOutputStream os = new FileOutputStream(f);
        try {
            os.write(newArr);
        }
        finally {
            os.close();
        }
    }

    private static void readArr(byte[] arr, InputStream is) throws IOException {
        int read;
        for (int off = 0; off < arr.length && (read = is.read(arr, off, arr.length - off)) != -1; off += read) {
        }
    }

    private static void filterClass(File f, String className) throws IOException {
        String line;
        if (!f.exists()) {
            return;
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        ArrayList<String> arr = new ArrayList<String>();
        boolean modified = false;
        while ((line = r.readLine()) != null) {
            if (line.endsWith(className)) {
                modified = true;
                continue;
            }
            arr.add(line);
        }
        r.close();
        if (modified) {
            if (arr.isEmpty()) {
                f.delete();
            } else {
                FileWriter w = new FileWriter(f);
                for (String l : arr) {
                    w.write(l);
                    w.write("\n");
                }
                w.close();
            }
        }
    }
}

