/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.spi;

import java.io.Flushable;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.spi.Level;
import org.netbeans.html.presenters.spi.ProtoPresenterBuilder;
import org.netbeans.html.presenters.spi.Strings;

abstract class Generic
implements Fn.Presenter,
Fn.KeepAlive,
Flushable {
    private String msg;
    private Item call;
    private final NavigableSet<Exported> exported;
    private final int key;
    private final boolean synchronous;
    private final boolean evalJS;
    private final String type;
    private final String app;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private Map<Key, Integer> ids = new HashMap<Key, Integer>();
    private StringBuilder deferred;
    private Collection<Object> arguments = new LinkedList<Object>();
    static final AtomicInteger COUNTER = new AtomicInteger(0);

    Generic(boolean synchronous, boolean evalJS, String type, String app) {
        this.exported = new TreeSet<Exported>();
        this.key = (int)(System.currentTimeMillis() / 777L) % 1000;
        this.synchronous = synchronous;
        this.evalJS = evalJS;
        this.type = type;
        this.app = app;
    }

    final Object lock() {
        return this.initialized;
    }

    abstract void log(Level var1, String var2, Object ... var3);

    final void init() {
        if (this.msg != null) {
            while (true) {
                try {
                    this.log(Level.FINE, "Awaiting as of {0}", this.msg);
                    this.initialized.await();
                    this.log(Level.FINE, "Waiting is over", new Object[0]);
                    return;
                }
                catch (InterruptedException ex) {
                    this.log(Level.INFO, "Interrupt", ex);
                    continue;
                }
                break;
            }
        }
        this.msg = "";
        this.callbackFn(new ProtoPresenterBuilder.OnPrepared(){

            @Override
            public void callbackIsPrepared(String clbk) {
                Generic.this.log(Level.FINE, "callbackReady with {0}", clbk);
                Generic.this.loadJS(Strings.begin(clbk).toString());
                Generic.this.log(Level.FINE, "checking OK state", new Object[0]);
                if (!Generic.this.assertOK()) {
                    CharSequence err = Strings.error(Generic.this.msg);
                    Generic.this.log(Level.WARNING, "no OK: {0}", err);
                    throw new IllegalStateException(err.toString());
                }
                Generic.this.log(Level.FINE, "assertOK", new Object[0]);
                Generic.this.loadJS(Strings.init(Generic.this.key, clbk).toString());
                Generic.this.log(Level.FINE, "callbackReady: countingDown", new Object[0]);
                Generic.this.initialized.countDown();
            }
        });
    }

    abstract void callbackFn(ProtoPresenterBuilder.OnPrepared var1);

    abstract void loadJS(String var1);

    public final String js2java(String method, String a1, String a2, String a3, String a4) throws Exception {
        if ("r".equals(method)) {
            this.result(a1, a2);
            return null;
        }
        if ("c".equals(method)) {
            return this.javacall(a1, a2, a3, a4);
        }
        if ("jr".equals(method)) {
            return this.javaresult();
        }
        throw new IllegalArgumentException(method);
    }

    abstract void dispatch(Runnable var1);

    @Override
    public void flush() throws IOException {
        if (this.initialized.getCount() == 0L) {
            this.flushImpl();
        }
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        this.init();
        return new GFn(code, names, keepAlive);
    }

    public Fn defineFn(String code, String ... names) {
        this.init();
        return new GFn(code, names, null);
    }

    int identityHashCode(Object o) {
        Key k = new Key(o);
        Integer val = this.ids.get(k);
        if (val == null) {
            int s = this.ids.size();
            this.ids.put(k, s);
            return s;
        }
        return val;
    }

    final int registerObject(Object o, boolean weak, boolean[] justAdded, String[] valueOf) {
        int id;
        Object exp;
        if (o instanceof Enum && valueOf != null) {
            valueOf[0] = o.toString();
        }
        if (o == (exp = this.findObject(id = this.identityHashCode(o)))) {
            return id;
        }
        if (exp == null) {
            if (justAdded != null) {
                justAdded[0] = true;
            }
            this.exported.add(new Exported(id, weak, o));
            return id;
        }
        throw new IllegalStateException("Collision!");
    }

    final Object findObject(int id) {
        Exported obj = this.exported.floor(new Exported(id, false, null));
        return obj == null || obj.id != id ? null : obj.get();
    }

    final Integer exportVm(Object vm) {
        int jNumber = this.registerObject(vm, false, null, null);
        int vmNumber = COUNTER.getAndIncrement();
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.fnHead());
        for (Method m : vm.getClass().getMethods()) {
            int i;
            String sep;
            if (m.getDeclaringClass() == Object.class) continue;
            Class<?>[] types = m.getParameterTypes();
            boolean instanceMethod = types.length > 0 && m.getName().startsWith(types[0].getName().replace('.', '_') + "$");
            int params = instanceMethod ? types.length - 1 : types.length;
            sb.append(Strings.fnName(m.getName()));
            if (instanceMethod) {
                sb.append(Strings.fnThiz());
                sep = Strings.fnSep();
            } else {
                sep = "";
            }
            for (i = 0; i < params; ++i) {
                sb.append(sep);
                sb.append(Strings.fnParam(i));
                sep = Strings.fnSep();
            }
            sb.append(Strings.fnClose());
            if (!instanceMethod) {
                sb.append(Strings.fnNoThiz());
            }
            sb.append(Strings.fnBegin(this.key));
            for (i = 0; i < params; ++i) {
                sb.append(Strings.fnPPar(i, i == 0 ? "" : ","));
            }
            sb.append(Strings.fnBody(jNumber, m.getName(), this.key, this.evalJS));
        }
        sb.append(Strings.fnFoot(vmNumber, this.key));
        this.deferExec(sb);
        return vmNumber;
    }

    final Object valueOf(String typeof, String res) {
        if (Strings.v_null().equals(typeof)) {
            return null;
        }
        if (Strings.v_number().equals(typeof)) {
            return Double.valueOf(res);
        }
        if (Strings.v_java().equals(typeof)) {
            return this.findObject(Integer.parseInt(res));
        }
        if (Strings.v_object().equals(typeof)) {
            return new JSObject(Integer.parseInt(res));
        }
        if (Strings.v_array().equals(typeof)) {
            int at = res.indexOf(58);
            int size = Integer.parseInt(res.substring(0, at));
            Object[] arr = new Object[size];
            ++at;
            for (int i = 0; i < size; ++i) {
                int next = res.indexOf(58, at);
                int length = Integer.parseInt(res.substring(at, next));
                at = next + 1 + length;
                arr[i] = this.valueOf(res.substring(next + 1, at));
            }
            return arr;
        }
        if (Strings.v_boolean().equals(typeof)) {
            return Boolean.valueOf(res);
        }
        if (Strings.v_error().equals(typeof)) {
            throw new IllegalStateException(res);
        }
        return res;
    }

    final Object valueOf(String typeAndValue) {
        int colon = typeAndValue.indexOf(58);
        return this.valueOf(typeAndValue.substring(0, colon), typeAndValue.substring(colon + 1));
    }

    final void encodeObject(Object a, boolean weak, StringBuilder sb, int[] vmId) {
        if (a == null) {
            sb.append(Strings.v_null());
        } else if (a.getClass().isArray()) {
            int len = Array.getLength(a);
            sb.append('[');
            String sep = "";
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(a, i);
                sb.append(sep);
                this.encodeObject(o, weak, sb, null);
                sep = ",";
            }
            sb.append(']');
        } else if (a instanceof Number) {
            sb.append(a.toString());
        } else if (a instanceof String) {
            sb.append('\"');
            String s = (String)a;
            int len = s.length();
            block6: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
        } else if (a instanceof Boolean) {
            sb.append(a.toString());
        } else if (a instanceof Character) {
            sb.append((int)((Character)a).charValue());
        } else if (a instanceof JSObject) {
            sb.append("ds(").append(this.key).append(").o(").append(((JSObject)a).index).append(")");
        } else if (vmId != null) {
            sb.append("ds(").append(this.key).append(").v(").append(vmId[0]).append(")");
        } else {
            String[] valueOf = new String[]{null};
            sb.append("ds(").append(this.key).append(").j(").append(this.registerObject(a, weak, null, valueOf));
            sb.append(",");
            this.encodeObject(valueOf[0], weak, sb, null);
            if (a instanceof Object[]) {
                for (Object n : (Object[])a) {
                    sb.append(",");
                    this.encodeObject(n, weak, sb, null);
                }
            }
            sb.append(")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void result(String typeof, String res) {
        this.log(Level.FINE, "result@{0}: {1}", typeof, res);
        Object object = this.lock();
        synchronized (object) {
            if ("OK".equals(typeof)) {
                this.log(Level.FINE, "init: {0}", res);
                this.msg = res;
                this.lock().notifyAll();
                return;
            }
            this.call.result(typeof, res);
            this.call = this.call.prev;
            this.lock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String javacall(String vmNumber, String fnName, String thizId, String encParams) throws Exception {
        Object object = this.lock();
        synchronized (object) {
            Object vm = this.findObject(Integer.parseInt(vmNumber));
            assert (vm != null);
            Object obj = thizId == null || "null".equals(thizId) ? null : this.valueOf("java", thizId);
            Method method = null;
            for (Method m : vm.getClass().getMethods()) {
                if (!m.getName().equals(fnName)) continue;
                method = m;
                break;
            }
            assert (method != null);
            ArrayList<Object> params = new ArrayList<Object>();
            if (obj != null) {
                params.add(obj);
            }
            params.addAll(Arrays.asList((Object[])this.valueOf(encParams)));
            Object[] converted = Generic.adaptParams(method, params);
            boolean first = this.call == null;
            this.log(Level.FINE, "jc: {0}@{1}args: {2} is first: {3}, now: {4}", method.getName(), vm, params, first, this.call);
            this.call = new Item(this.call, method, vm, converted);
            if (first || this.synchronous) {
                if (this.call != null) {
                    this.dispatch(this.call);
                }
            } else {
                this.lock().notifyAll();
            }
            return this.javaresult();
        }
    }

    final String javaresult() throws IllegalStateException, InterruptedException {
        Object object = this.lock();
        synchronized (object) {
            boolean[] finished = new boolean[]{false};
            while (true) {
                if (this.deferred != null) {
                    this.deferred.insert(0, "javascript:");
                    String ret = this.deferred.toString();
                    this.deferred = null;
                    return ret;
                }
                finished[0] = false;
                String jsToExec = this.call.inJavaScript(finished);
                this.log(Level.FINE, "jr: {0} jsToExec: {1} finished: {2}", this.call, jsToExec, finished[0]);
                if (jsToExec != null) {
                    if (finished[0]) {
                        this.call = this.call.prev;
                    }
                    return jsToExec;
                }
                this.lock().wait();
            }
        }
    }

    public final void loadScript(Reader reader) throws Exception {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] arr = new char[4092];
        while ((len = reader.read(arr)) != -1) {
            sb.append(arr, 0, len);
        }
        this.deferExec(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deferExec(StringBuilder sb) {
        Object object = this.lock();
        synchronized (object) {
            this.log(Level.FINE, "deferExec: {0} empty: {1}, call: {2}", sb, this.deferred == null, this.call);
            if (this.deferred == null) {
                this.deferred = sb;
            } else {
                this.deferred.append((CharSequence)sb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushImpl() {
        Object object = this.lock();
        synchronized (object) {
            if (this.deferred != null) {
                this.log(Level.FINE, "flush: {0}", this.deferred);
                this.exec(Strings.flushExec(this.key).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object exec(String fn) {
        Object ret;
        boolean first;
        Object object = this.lock();
        synchronized (object) {
            boolean load;
            Item myCall;
            if (this.deferred != null) {
                this.deferred.append(fn);
                fn = this.deferred.toString();
                this.deferred = null;
                this.log(Level.FINE, "Flushing {0}", fn);
            }
            if (this.call != null) {
                this.call = myCall = new Item(this.call, fn);
                this.lock().notifyAll();
                load = this.synchronous;
                first = false;
            } else {
                this.call = myCall = new Item(null, null);
                load = true;
                first = true;
            }
            if (load) {
                this.loadJS(fn);
            }
            while (myCall.typeof == null) {
                try {
                    this.lock().wait();
                }
                catch (InterruptedException ex) {
                    this.log(Level.SEVERE, null, ex);
                }
                if (this.call != null) {
                    this.call.inJava();
                }
                this.lock().notifyAll();
            }
            ret = this.valueOf(myCall.typeof, (String)myCall.result);
        }
        if (first) {
            this.arguments.clear();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean assertOK() {
        Object object = this.lock();
        synchronized (object) {
            if (this.msg == null || this.msg.length() == 0) {
                try {
                    this.lock().wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return "OK".equals(this.msg) || "Initialized".equals(this.msg);
        }
    }

    private static Object[] adaptParams(Method toCall, List<Object> args) {
        Object[] arr = new Object[args.size()];
        Class<?>[] types = toCall.getParameterTypes();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Generic.adaptType(types[i], args.get(i));
        }
        return arr;
    }

    private static Object adaptType(Class<?> type, Object value) {
        if (type.isPrimitive() && value instanceof Number) {
            Number n = (Number)value;
            if (type == Byte.TYPE) {
                return n.byteValue();
            }
            if (type == Short.TYPE) {
                return n.shortValue();
            }
            if (type == Integer.TYPE) {
                return n.intValue();
            }
            if (type == Long.TYPE) {
                return n.longValue();
            }
            if (type == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (type == Double.TYPE) {
                return n.doubleValue();
            }
            if (type == Character.TYPE) {
                return Character.valueOf((char)n.intValue());
            }
        }
        return value;
    }

    private static final class WeakHolder
    extends PhantomReference<Object> {
        private static final ReferenceQueue QUEUE = new ReferenceQueue();
        private static final Set<WeakHolder> active = new HashSet<WeakHolder>();
        private final Object knockout;

        public WeakHolder(Object referent, Object knockout) {
            super(referent, QUEUE);
            this.knockout = knockout;
        }

        static void clean() {
            WeakHolder h;
            while ((h = (WeakHolder)QUEUE.poll()) != null) {
                active.remove(h);
            }
        }

        void register() {
            active.add(this);
        }
    }

    private static final class Exported
    implements Comparable<Exported> {
        private final int id;
        private final Object obj;
        private final boolean ref;

        Exported(int id, boolean ref, Object obj) {
            this.id = id;
            this.obj = ref ? Exported.createReferenceFor(obj) : obj;
            this.ref = ref;
            WeakHolder.clean();
        }

        protected Object get() {
            if (this.ref) {
                return ((Reference)this.obj).get();
            }
            return this.obj;
        }

        @Override
        public int compareTo(Exported o) {
            return this.id - o.id;
        }

        private static Object createReferenceFor(Object obj) {
            WeakReference<Object> ref = new WeakReference<Object>(obj);
            if (obj instanceof Reference) {
                Reference myRef = (Reference)obj;
                if (obj.getClass().getName().equals("org.netbeans.html.ko4j.Knockout")) {
                    WeakHolder h = new WeakHolder(myRef.get(), obj);
                    h.register();
                }
            }
            return ref;
        }
    }

    private final class GFn
    extends Fn {
        private final int id;
        private final int[] vmId;
        private final boolean[] keepAlive;

        public GFn(String code, String[] names, boolean[] ka) {
            int[] nArray;
            super((Fn.Presenter)Generic.this);
            this.id = COUNTER.getAndIncrement();
            this.keepAlive = ka;
            StringBuilder sb = new StringBuilder(1024);
            sb.append(Strings.registerFn(this.id, Generic.this.key));
            String sep = "";
            boolean isVm = false;
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
                isVm = false;
                if (!Strings.v_vm().equals(n)) continue;
                isVm = true;
            }
            sb.append(Strings.registerCode(code));
            if (isVm) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
            } else {
                nArray = null;
            }
            this.vmId = nArray;
            Generic.this.deferExec(sb);
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(true, thiz, args);
        }

        public void invokeLater(Object thiz, Object ... args) throws Exception {
            this.invokeImpl(false, thiz, args);
        }

        private Object invokeImpl(boolean wait4js, Object thiz, Object ... args) throws Exception {
            if (this.vmId != null && this.vmId[0] < 0) {
                this.vmId[0] = Generic.this.exportVm(args[args.length - 1]);
            }
            StringBuilder sb = new StringBuilder(256);
            sb.append(Strings.invokeImplFn(this.id, wait4js, Generic.this.key));
            Generic.this.encodeObject(thiz, false, sb, null);
            for (int i = 0; i < args.length; ++i) {
                sb.append(", ");
                boolean weak = this.keepAlive != null && !this.keepAlive[i];
                Generic.this.encodeObject(args[i], weak, sb, i == args.length - 1 ? this.vmId : null);
            }
            sb.append(");");
            Generic.this.arguments.add(thiz);
            Generic.this.arguments.add(args);
            if (wait4js) {
                return Generic.this.exec(sb.toString());
            }
            Generic.this.deferExec(sb);
            return null;
        }
    }

    private static final class JSObject {
        private final int index;

        public JSObject(int index) {
            this.index = index;
        }

        public int hashCode() {
            return 37 * this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JSObject other = (JSObject)obj;
            return this.index == other.index;
        }

        public String toString() {
            return Strings.jsObject(this.index).toString();
        }
    }

    private class Item
    implements Runnable {
        final Item prev;
        Boolean done;
        final Method method;
        final Object thiz;
        final Object[] params;
        Object result;
        private final String toExec;
        private String typeof;

        Item(Item prev, Method method, Object thiz, Object[] params) {
            this.prev = prev;
            this.method = method;
            this.thiz = thiz;
            this.params = Generic.adaptParams(method, Arrays.asList(params));
            this.toExec = null;
        }

        protected final String inJavaScript(boolean[] finished) {
            if (this.method != null) {
                return this.js(finished);
            }
            return this.sj(finished);
        }

        protected final void inJava() {
            if (this.method == null) {
                return;
            }
            if (this.done == null) {
                this.done = false;
                try {
                    Generic.this.log(Level.FINE, "Calling {0}", this.method);
                    this.result = this.method.invoke(this.thiz, this.params);
                }
                catch (Exception ex) {
                    try {
                        Generic.this.log(Level.SEVERE, "Cannot invoke " + this.method + " on " + this.thiz + " with " + Arrays.toString(this.params), ex);
                    }
                    catch (Throwable throwable) {
                        this.done = true;
                        Generic.this.log(Level.FINE, "Result: {0}", this.result);
                        throw throwable;
                    }
                    this.done = true;
                    Generic.this.log(Level.FINE, "Result: {0}", this.result);
                }
                this.done = true;
                Generic.this.log(Level.FINE, "Result: {0}", this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Generic.this.lock();
            synchronized (object) {
                Generic.this.log(Level.FINE, "run: {0}", this);
                this.inJava();
                Generic.this.lock().notifyAll();
            }
        }

        protected String js(boolean[] finished) {
            if (Boolean.TRUE.equals(this.done)) {
                StringBuilder sb = new StringBuilder();
                Generic.this.encodeObject(this.result, false, sb, null);
                finished[0] = true;
                return sb.toString();
            }
            return null;
        }

        public Item(Item prev, String toExec) {
            this.prev = prev;
            this.toExec = toExec;
            this.method = null;
            this.params = null;
            this.thiz = null;
        }

        protected String sj(boolean[] finished) {
            finished[0] = false;
            if (Boolean.TRUE.equals(this.done)) {
                return null;
            }
            this.done = true;
            return "javascript:" + this.toExec;
        }

        protected final void result(String typeof, String result) {
            if (this.method != null) {
                throw new UnsupportedOperationException();
            }
            this.typeof = typeof;
            this.result = result;
            Generic.this.log(Level.FINE, "result ({0}): {1} for {2}", typeof, result, this.toExec);
        }
    }

    static interface OnReady {
        public void callbackReady(String var1);
    }

    private static final class Key
    extends WeakReference<Object> {
        private int hash;

        public Key(Object obj) {
            super(obj);
            this.hash = System.identityHashCode(obj);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + this.hash;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.hash == other.hash;
            }
            return false;
        }
    }
}

