/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.serializer;

import java.util.Iterator;
import java.util.Map;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MapSerializer
extends TypeSerializerImpl {
    public static final String STRUCT_TAG = "struct";
    public static final String MEMBER_TAG = "member";
    public static final String NAME_TAG = "name";
    private final XmlRpcStreamConfig config;
    private final TypeFactory typeFactory;

    public MapSerializer(TypeFactory pTypeFactory, XmlRpcStreamConfig pConfig) {
        this.typeFactory = pTypeFactory;
        this.config = pConfig;
    }

    protected void writeEntry(ContentHandler pHandler, Object pKey, Object pValue) throws SAXException {
        pHandler.startElement("", MEMBER_TAG, MEMBER_TAG, ZERO_ATTRIBUTES);
        pHandler.startElement("", NAME_TAG, NAME_TAG, ZERO_ATTRIBUTES);
        if (this.config.isEnabledForExtensions() && !(pKey instanceof String)) {
            this.writeValue(pHandler, pKey);
        } else {
            String key = pKey.toString();
            pHandler.characters(key.toCharArray(), 0, key.length());
        }
        pHandler.endElement("", NAME_TAG, NAME_TAG);
        this.writeValue(pHandler, pValue);
        pHandler.endElement("", MEMBER_TAG, MEMBER_TAG);
    }

    private void writeValue(ContentHandler pHandler, Object pValue) throws SAXException {
        TypeSerializer ts = this.typeFactory.getSerializer(this.config, pValue);
        if (ts == null) {
            throw new SAXException("Unsupported Java type: " + pValue.getClass().getName());
        }
        ts.write(pHandler, pValue);
    }

    protected void writeData(ContentHandler pHandler, Object pData) throws SAXException {
        Map map = (Map)pData;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.writeEntry(pHandler, entry.getKey(), entry.getValue());
        }
    }

    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
        pHandler.startElement("", STRUCT_TAG, STRUCT_TAG, ZERO_ATTRIBUTES);
        this.writeData(pHandler, pObject);
        pHandler.endElement("", STRUCT_TAG, STRUCT_TAG);
        pHandler.endElement("", "value", "value");
    }
}

