/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class PropertyNode
extends Node {
    private final Expression key;
    private final Expression value;
    private final FunctionNode getter;
    private final FunctionNode setter;
    private final List<Expression> decorators;
    private final boolean isStatic;
    private final boolean computed;

    public PropertyNode(long l, int n, Expression expression, Expression expression2, FunctionNode functionNode, FunctionNode functionNode2, boolean bl, boolean bl2, List<Expression> list) {
        super(l, n);
        this.key = expression;
        this.value = expression2;
        this.getter = functionNode;
        this.setter = functionNode2;
        this.isStatic = bl;
        this.computed = bl2;
        this.decorators = list;
    }

    private PropertyNode(PropertyNode propertyNode, Expression expression, Expression expression2, FunctionNode functionNode, FunctionNode functionNode2, boolean bl, boolean bl2, List<Expression> list) {
        super(propertyNode);
        this.key = expression;
        this.value = expression2;
        this.getter = functionNode;
        this.setter = functionNode2;
        this.isStatic = bl;
        this.computed = bl2;
        this.decorators = list;
    }

    public String getKeyName() {
        return this.key instanceof PropertyKey ? ((PropertyKey)((Object)this.key)).getPropertyName() : null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterPropertyNode(this)) {
            return nodeVisitor.leavePropertyNode(this.setKey((Expression)this.key.accept(nodeVisitor)).setValue(this.value == null ? null : (Expression)this.value.accept(nodeVisitor)).setGetter(this.getter == null ? null : (FunctionNode)this.getter.accept(nodeVisitor)).setSetter(this.setter == null ? null : (FunctionNode)this.setter.accept(nodeVisitor)).setDecorators(Node.accept(nodeVisitor, this.decorators)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterPropertyNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        if (this.value instanceof FunctionNode && ((FunctionNode)this.value).getIdent() != null) {
            this.value.toString(stringBuilder);
        }
        if (this.value != null) {
            this.key.toString(stringBuilder, bl);
            stringBuilder.append(": ");
            this.value.toString(stringBuilder, bl);
        }
        if (this.getter != null) {
            stringBuilder.append(' ');
            this.getter.toString(stringBuilder, bl);
        }
        if (this.setter != null) {
            stringBuilder.append(' ');
            this.setter.toString(stringBuilder, bl);
        }
    }

    public FunctionNode getGetter() {
        return this.getter;
    }

    public PropertyNode setGetter(FunctionNode functionNode) {
        if (this.getter == functionNode) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, functionNode, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public Expression getKey() {
        return this.key;
    }

    private PropertyNode setKey(Expression expression) {
        if (this.key == expression) {
            return this;
        }
        return new PropertyNode(this, expression, this.value, this.getter, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public FunctionNode getSetter() {
        return this.setter;
    }

    public PropertyNode setSetter(FunctionNode functionNode) {
        if (this.setter == functionNode) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, this.getter, functionNode, this.isStatic, this.computed, this.decorators);
    }

    public Expression getValue() {
        return this.value;
    }

    public PropertyNode setValue(Expression expression) {
        if (this.value == expression) {
            return this;
        }
        return new PropertyNode(this, this.key, expression, this.getter, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public List<Expression> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    private PropertyNode setDecorators(List<Expression> list) {
        if (this.decorators == list) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, this.getter, this.setter, this.isStatic, this.computed, list);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isComputed() {
        return this.computed;
    }
}

