/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.openide.util.NbBundle;

final class CharsetValidator
extends StringValidator {
    CharsetValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        try {
            Charset.forName(model);
        }
        catch (IllegalCharsetNameException badName) {
            problems.add(NbBundle.getMessage(CharsetValidator.class, (String)"ILLEGAL_CHARSET_NAME", (Object)compName, (Object)model));
        }
        catch (UnsupportedCharsetException unsup) {
            problems.add(NbBundle.getMessage(CharsetValidator.class, (String)"UNSUPPORTED_CHARSET_NAME", (Object)compName, (Object)model));
        }
    }
}

