/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.batch;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.pm.BulkSearch;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class BatchSearch {
    private static final Logger LOG = Logger.getLogger(BatchSearch.class.getName());

    public static BatchResult findOccurrences(Iterable<? extends HintDescription> patterns, Scope scope) {
        return BatchSearch.findOccurrences(patterns, scope, new ProgressHandleWrapper(null), HintsSettings.getGlobalSettings());
    }

    public static BatchResult findOccurrences(Iterable<? extends HintDescription> patterns, Scope scope, ProgressHandleWrapper progress, @NullAllowed HintsSettings settingsProvider) {
        return BatchSearch.findOccurrencesLocal(patterns, scope.getIndexMapper(patterns), scope.getTodo(), progress, settingsProvider);
    }

    private static BatchResult findOccurrencesLocal(Iterable<? extends HintDescription> patterns, MapIndices indexMapper, Collection<? extends Folder> todo, ProgressHandleWrapper progress, @NullAllowed HintsSettings settingsProvider) {
        BatchResult[] result = new BatchResult[1];
        try {
            JavaSource.create((ClasspathInfo)Utilities.createUniversalCPInfo(), (FileObject[])new FileObject[0]).runUserActionTask(parameter -> {
                result[0] = BatchSearch.findOccurrencesLocalImpl((CompilationInfo)parameter, patterns, indexMapper, todo, progress, settingsProvider);
            }, true);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result[0];
    }

    private static BatchResult findOccurrencesLocalImpl(final CompilationInfo info, final Iterable<? extends HintDescription> patterns, MapIndices indexMapper, Collection<? extends Folder> todo, ProgressHandleWrapper progress, HintsSettings settingsProvider) {
        boolean hasKindPatterns = false;
        for (HintDescription hintDescription : patterns) {
            if (hintDescription.getTrigger() instanceof Trigger.PatternDescription) continue;
            hasKindPatterns = true;
            break;
        }
        Callable<BulkSearch.BulkPattern> bulkPattern = hasKindPatterns ? null : new Callable<BulkSearch.BulkPattern>(){
            private final AtomicReference<BulkSearch.BulkPattern> pattern = new AtomicReference();

            @Override
            public BulkSearch.BulkPattern call() {
                if (this.pattern.get() == null) {
                    this.pattern.set(BatchSearch.preparePattern(patterns, info));
                }
                return this.pattern.get();
            }
        };
        HashMap<FileSystemBasedIndexEnquirer, Collection<? extends Resource>> hashMap = new HashMap<FileSystemBasedIndexEnquirer, Collection<? extends Resource>>();
        LinkedList problems = new LinkedList();
        ProgressHandleWrapper innerForAll = progress.startNextPartWithEmbedding(ProgressHandleWrapper.prepareParts(2 * todo.size()));
        for (Folder folder : todo) {
            LOG.log(Level.FINE, "Processing: {0}", FileUtil.getFileDisplayName((FileObject)folder.getFileObject()));
            FileSystemBasedIndexEnquirer indexEnquirer = new FileSystemBasedIndexEnquirer(folder.getFileObject(), folder.isRecursive());
            Collection<? extends Resource> occurrences = ((IndexEnquirer)indexEnquirer).findResources(patterns, innerForAll, bulkPattern, problems, settingsProvider);
            if (!occurrences.isEmpty()) {
                hashMap.put(indexEnquirer, occurrences);
            }
            innerForAll.tick();
        }
        return new BatchResult(hashMap, problems);
    }

    private static BulkSearch.BulkPattern preparePattern(Iterable<? extends HintDescription> patterns, CompilationInfo info) {
        LinkedList<String> code = new LinkedList<String>();
        LinkedList<Tree> trees = new LinkedList<Tree>();
        LinkedList<HintDescription.AdditionalQueryConstraints> additionalConstraints = new LinkedList<HintDescription.AdditionalQueryConstraints>();
        for (HintDescription hintDescription : patterns) {
            String textPattern = ((Trigger.PatternDescription)hintDescription.getTrigger()).getPattern();
            code.add(textPattern);
            trees.add(Utilities.parseAndAttribute(info, textPattern, null));
            additionalConstraints.add(hintDescription.getAdditionalConstraints());
        }
        return BulkSearch.getDefault().create(code, trees, additionalConstraints, new AtomicBoolean());
    }

    public static void getVerifiedSpans(BatchResult candidates, @NonNull ProgressHandleWrapper progress, VerifiedSpansCallBack callback, Collection<? super MessageImpl> problems, AtomicBoolean cancel) {
        BatchSearch.getVerifiedSpans(candidates, progress, callback, false, problems, cancel);
    }

    public static void getVerifiedSpans(BatchResult candidates, @NonNull ProgressHandleWrapper progress, VerifiedSpansCallBack callback, boolean doNotRegisterClassPath, Collection<? super MessageImpl> problems, AtomicBoolean cancel) {
        int[] parts = new int[candidates.projectId2Resources.size()];
        int index = 0;
        for (Map.Entry e : candidates.projectId2Resources.entrySet()) {
            parts[index++] = ((Collection)e.getValue()).size();
        }
        ProgressHandleWrapper inner = progress.startNextPartWithEmbedding(parts);
        for (Map.Entry e : candidates.projectId2Resources.entrySet()) {
            if (cancel.get()) {
                return;
            }
            inner.startNextPart(((Collection)e.getValue()).size());
            ((IndexEnquirer)e.getKey()).validateResource((Collection)e.getValue(), inner, callback, doNotRegisterClassPath, problems, cancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void getLocalVerifiedSpans(Collection<? extends Resource> resources, final @NonNull ProgressHandleWrapper progress, final VerifiedSpansCallBack callback, boolean doNotRegisterClassPath, final Collection<? super MessageImpl> problems, final AtomicBoolean cancel) {
        LinkedList<FileObject> files = new LinkedList<FileObject>();
        final HashMap<FileObject, Resource> file2Resource = new HashMap<FileObject, Resource>();
        for (Resource resource : resources) {
            FileObject file = resource.getResolvedFile();
            if (file != null) {
                files.add(file);
                file2Resource.put(file, resource);
                continue;
            }
            callback.cannotVerifySpan(resource);
            progress.tick();
        }
        Map<ClasspathInfo, Collection<FileObject>> cp2Files = BatchUtilities.sortFiles(files);
        Object var9_10 = null;
        if (!doNotRegisterClassPath) {
            ClassPath[] classPathArray;
            HashSet<ClassPath> toRegisterSet = new HashSet<ClassPath>();
            for (ClasspathInfo cpInfo : cp2Files.keySet()) {
                toRegisterSet.add(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
            }
            ClassPath[] classPathArray2 = classPathArray = !toRegisterSet.isEmpty() ? toRegisterSet.toArray(new ClassPath[0]) : null;
            if (classPathArray != null) {
                GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
                try {
                    Utilities.waitScanFinished();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        try {
            Iterator<Map.Entry<ClasspathInfo, Collection<FileObject>>> iterator = cp2Files.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ClasspathInfo, Collection<FileObject>> e = iterator.next();
                try {
                    ArrayList<FileObject> toProcess = new ArrayList<FileObject>(e.getValue());
                    final AtomicInteger currentPointer = new AtomicInteger();
                    callback.groupStarted();
                    while (currentPointer.get() < toProcess.size()) {
                        if (cancel.get()) {
                            return;
                        }
                        final AtomicBoolean stop = new AtomicBoolean();
                        final List currentInputList = toProcess.subList(currentPointer.get(), toProcess.size());
                        JavaSource js = JavaSource.create((ClasspathInfo)e.getKey(), currentInputList);
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController parameter) throws Exception {
                                if (stop.get()) {
                                    return;
                                }
                                if (cancel.get()) {
                                    return;
                                }
                                boolean cont = true;
                                try {
                                    Iterable<? extends HintDescription> enabledHints;
                                    if (parameter.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                                        if (currentInputList.size() == 1) {
                                            problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "An error occurred while processing file: " + FileUtil.getFileDisplayName((FileObject)parameter.getFileObject()) + ", please see the IDE log for more information."));
                                            currentPointer.incrementAndGet();
                                        }
                                        return;
                                    }
                                    progress.setMessage("processing: " + FileUtil.getFileDisplayName((FileObject)parameter.getFileObject()));
                                    Resource r = (Resource)file2Resource.get(parameter.getFileObject());
                                    HintsSettings settings = r.settings;
                                    if (settings == null) {
                                        settings = HintsSettings.getSettingsFor(parameter.getFileObject());
                                        ArrayList<? extends HintDescription> hintsCopy = new ArrayList<HintDescription>();
                                        for (HintDescription hintDescription : r.hints) {
                                            if (!settings.isEnabled(hintDescription.getMetadata())) continue;
                                            hintsCopy.add(hintDescription);
                                        }
                                        enabledHints = hintsCopy;
                                    } else {
                                        enabledHints = r.hints;
                                    }
                                    List<ErrorDescription> hints = new HintsInvoker(settings, true, new AtomicBoolean()).computeHints((CompilationInfo)parameter, enabledHints, problems);
                                    assert (hints != null);
                                    cont = callback.spansVerified(parameter, r, hints);
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.INFO, "Exception while performing batch processing in " + FileUtil.getFileDisplayName((FileObject)parameter.getFileObject()), t);
                                    problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "An exception occurred while processing file: " + FileUtil.getFileDisplayName((FileObject)parameter.getFileObject()) + " (" + t.getLocalizedMessage() + ")."));
                                }
                                if (cont) {
                                    progress.tick();
                                    currentPointer.incrementAndGet();
                                } else {
                                    stop.set(true);
                                }
                            }
                        }, true);
                    }
                    callback.groupFinished();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return;
        }
        finally {
            void var9_12;
            if (var9_12 != null) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", (ClassPath[])var9_12);
            }
            progress.finish();
        }
    }

    public static final class FileSystemBasedIndexEnquirer
    extends LocalIndexEnquirer {
        private boolean recursive;

        public FileSystemBasedIndexEnquirer(FileObject src, boolean recursive) {
            super(src);
            this.recursive = recursive;
        }

        @Override
        public Collection<? extends Resource> findResources(Iterable<? extends HintDescription> hints, ProgressHandleWrapper progress, @NullAllowed Callable<BulkSearch.BulkPattern> bulkPattern, Collection<? super MessageImpl> problems, HintsSettings settingsProvider) {
            LinkedList<FileObject> files = new LinkedList<FileObject>();
            ProgressHandleWrapper innerProgress = progress.startNextPartWithEmbedding(30, 70);
            BatchUtilities.recursive(this.src, this.src, files, innerProgress, 0, null, null, this.recursive);
            LOG.log(Level.FINE, "files: {0}", files);
            innerProgress.startNextPart(files.size());
            ArrayList<Resource> result = new ArrayList<Resource>();
            if (!files.isEmpty()) {
                try {
                    if (bulkPattern != null) {
                        long start = System.currentTimeMillis();
                        JavaSource.create((ClasspathInfo)Utilities.createUniversalCPInfo(), files).runUserActionTask(cc -> {
                            if (cc.toPhase(JavaSource.Phase.PARSED).compareTo((Enum)JavaSource.Phase.PARSED) < 0) {
                                return;
                            }
                            try {
                                boolean matches = BulkSearch.getDefault().matches((CompilationInfo)cc, new AtomicBoolean(), new TreePath(cc.getCompilationUnit()), (BulkSearch.BulkPattern)bulkPattern.call());
                                if (matches) {
                                    result.add(new Resource(this, FileUtil.getRelativePath((FileObject)this.src, (FileObject)cc.getFileObject()), hints, (BulkSearch.BulkPattern)bulkPattern.call(), settingsProvider));
                                }
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                LOG.log(Level.INFO, "Exception while performing batch search in " + FileUtil.getFileDisplayName((FileObject)cc.getFileObject()), t);
                                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "An exception occurred while testing file: " + FileUtil.getFileDisplayName((FileObject)cc.getFileObject()) + " (" + t.getLocalizedMessage() + ")."));
                            }
                            innerProgress.tick();
                        }, true);
                        long end = System.currentTimeMillis();
                        LOG.log(Level.FINE, "took: {0}, per file: {1}", new Object[]{end - start, (end - start) / (long)files.size()});
                    } else {
                        for (FileObject file : files) {
                            result.add(new Resource(this, FileUtil.getRelativePath((FileObject)this.src, (FileObject)file), hints, null, settingsProvider));
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return result;
        }
    }

    public static abstract class LocalIndexEnquirer
    extends IndexEnquirer {
        public LocalIndexEnquirer(FileObject src) {
            super(src);
        }

        @Override
        public void validateResource(Collection<? extends Resource> resources, ProgressHandleWrapper progress, VerifiedSpansCallBack callback, boolean doNotRegisterClassPath, Collection<? super MessageImpl> problems, AtomicBoolean cancel) {
            BatchSearch.getLocalVerifiedSpans(resources, progress, callback, doNotRegisterClassPath, problems, cancel);
        }
    }

    public static abstract class IndexEnquirer {
        final FileObject src;

        public IndexEnquirer(FileObject src) {
            this.src = src;
        }

        public abstract Collection<? extends Resource> findResources(Iterable<? extends HintDescription> var1, ProgressHandleWrapper var2, @NullAllowed Callable<BulkSearch.BulkPattern> var3, Collection<? super MessageImpl> var4, HintsSettings var5);

        public abstract void validateResource(Collection<? extends Resource> var1, ProgressHandleWrapper var2, VerifiedSpansCallBack var3, boolean var4, Collection<? super MessageImpl> var5, AtomicBoolean var6);
    }

    public static interface MapIndices {
        public IndexEnquirer findIndex(FileObject var1, ProgressHandleWrapper var2, boolean var3);
    }

    public static final class Resource {
        private final IndexEnquirer indexEnquirer;
        private final String relativePath;
        final Iterable<? extends HintDescription> hints;
        private final BulkSearch.BulkPattern pattern;
        final HintsSettings settings;

        public Resource(IndexEnquirer indexEnquirer, String relativePath, Iterable<? extends HintDescription> hints, BulkSearch.BulkPattern pattern, HintsSettings settings) {
            this.indexEnquirer = indexEnquirer;
            this.relativePath = relativePath;
            this.hints = hints;
            this.pattern = pattern;
            this.settings = settings;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<int[]> getCandidateSpans() {
            JavaSource js;
            FileObject file = this.getResolvedFile();
            if (file != null) {
                js = JavaSource.forFileObject((FileObject)file);
            } else {
                CharSequence text = this.getSourceCode();
                if (text == null) {
                    return null;
                }
                Writer out = null;
                try {
                    file = FileUtil.createData((FileObject)FileUtil.createMemoryFileSystem().getRoot(), (String)this.relativePath);
                    out = new OutputStreamWriter(file.getOutputStream());
                    out.write(text.toString());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Iterable<int[]> iterable = null;
                    return iterable;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                js = JavaSource.create((ClasspathInfo)Utilities.createUniversalCPInfo(), (FileObject[])new FileObject[]{file});
            }
            LinkedList<int[]> span = new LinkedList<int[]>();
            try {
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.PARSED);
                    span.addAll(this.doComputeSpans((CompilationInfo)cc));
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return span;
        }

        private Collection<int[]> doComputeSpans(CompilationInfo ci) {
            LinkedList<int[]> result = new LinkedList<int[]>();
            Map<String, Collection<TreePath>> found = BulkSearch.getDefault().match(ci, new AtomicBoolean(), new TreePath(ci.getCompilationUnit()), this.pattern);
            for (Map.Entry<String, Collection<TreePath>> e : found.entrySet()) {
                Tree treePattern = Utilities.parseAndAttribute(ci, e.getKey(), null);
                for (TreePath tp : e.getValue()) {
                    if (BulkSearch.getDefault().requiresLightweightVerification() && !Matcher.create((CompilationInfo)ci).setCancel(new AtomicBoolean()).setSearchRoot(tp).setTreeTopSearch().setUntypedMatching().match(Pattern.createSimplePattern((TreePath)new TreePath(new TreePath(ci.getCompilationUnit()), treePattern))).iterator().hasNext()) continue;
                    int[] span = new int[]{(int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), tp.getLeaf()), (int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), tp.getLeaf())};
                    result.add(span);
                }
            }
            return result;
        }

        public FileObject getResolvedFile() {
            return this.indexEnquirer.src.getFileObject(this.relativePath);
        }

        public String getDisplayName() {
            FileObject file = this.getResolvedFile();
            if (file != null) {
                return FileUtil.getFileDisplayName((FileObject)file);
            }
            return this.relativePath;
        }

        public CharSequence getSourceCode() {
            try {
                FileObject file = this.getResolvedFile();
                ByteBuffer bb = ByteBuffer.wrap(file.asBytes());
                return FileEncodingQuery.getEncoding((FileObject)file).decode(bb);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public FileObject getRoot() {
            return this.indexEnquirer.src;
        }
    }

    public static final class BatchResult {
        private final Map<? extends IndexEnquirer, ? extends Collection<? extends Resource>> projectId2Resources;
        public final Collection<? extends MessageImpl> problems;

        public BatchResult(Map<? extends IndexEnquirer, ? extends Collection<? extends Resource>> projectId2Resources, Collection<? extends MessageImpl> problems) {
            this.projectId2Resources = projectId2Resources;
            this.problems = problems;
        }

        public Collection<? extends Collection<? extends Resource>> getResources() {
            return this.projectId2Resources.values();
        }

        public Map<FileObject, Collection<? extends Resource>> getResourcesWithRoots() {
            HashMap<FileObject, Collection<? extends Resource>> result = new HashMap<FileObject, Collection<? extends Resource>>();
            for (Map.Entry<? extends IndexEnquirer, ? extends Collection<? extends Resource>> e : this.projectId2Resources.entrySet()) {
                result.put(e.getKey().src, e.getValue());
            }
            return result;
        }
    }

    public static abstract class Scope {
        public abstract String getDisplayName();

        public abstract Collection<? extends Folder> getTodo();

        public abstract MapIndices getIndexMapper(Iterable<? extends HintDescription> var1);
    }

    public static class Folder {
        private FileObject file;
        private NonRecursiveFolder folder;

        public Folder(FileObject file) {
            this.file = file;
        }

        public Folder(NonRecursiveFolder folder) {
            this.folder = folder;
        }

        public FileObject getFileObject() {
            if (this.file != null) {
                return this.file;
            }
            return this.folder.getFolder();
        }

        private boolean isRecursive() {
            if (this.file != null) {
                return this.file.isFolder();
            }
            return false;
        }

        public static Folder[] convert(FileObject ... files) {
            Folder[] result = new Folder[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = new Folder(files[i]);
            }
            return result;
        }

        public static Folder[] convert(Collection<?> list) {
            Folder[] result = new Folder[list.size()];
            int i = 0;
            for (Object item : list) {
                result[i] = item instanceof FileObject ? new Folder((FileObject)item) : new Folder((NonRecursiveFolder)item);
                ++i;
            }
            return result;
        }

        public String toString() {
            return !this.isRecursive() ? "Non" : "Recursive file " + this.getFileObject().getPath();
        }
    }

    public static interface VerifiedSpansCallBack {
        public void groupStarted();

        public boolean spansVerified(CompilationController var1, Resource var2, Collection<? extends ErrorDescription> var3) throws Exception;

        public void groupFinished();

        public void cannotVerifySpan(Resource var1);
    }
}

