/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.debugger.ui.views.ViewModelListener;
import org.netbeans.spi.viewmodel.Models;

public final class ViewLifecycle {
    private ViewModelListener vml;
    private final CompoundModelUpdateListener cmul;

    ViewLifecycle(ViewModelListener vml, CompoundModelUpdateListener cmul) {
        this.vml = vml;
        this.cmul = cmul;
    }

    public Models.CompoundModel getModel() {
        return this.cmul.getCurrentModel();
    }

    public void addModelUpdateListener(ModelUpdateListener mul) {
        this.cmul.addModelUpdateListener(mul);
    }

    public void removeModelUpdateListener(ModelUpdateListener mul) {
        this.cmul.removeModelUpdateListener(mul);
    }

    public void destroy() {
        this.vml.destroy();
    }

    static class CompoundModelUpdateListener
    implements ModelUpdateListener {
        private final List<ModelUpdateListener> muls = new LinkedList<ModelUpdateListener>();
        private Models.CompoundModel currentCompoundModel;

        CompoundModelUpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelUpdateListener(ModelUpdateListener mul) {
            List<ModelUpdateListener> list = this.muls;
            synchronized (list) {
                this.muls.add(mul);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelUpdateListener(ModelUpdateListener mul) {
            List<ModelUpdateListener> list = this.muls;
            synchronized (list) {
                this.muls.remove(mul);
            }
        }

        public Models.CompoundModel getCurrentModel() {
            return this.currentCompoundModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelUpdated(Models.CompoundModel compoundModel, DebuggerEngine de) {
            LinkedList<ModelUpdateListener> muls2;
            List<ModelUpdateListener> list = this.muls;
            synchronized (list) {
                this.currentCompoundModel = compoundModel;
                muls2 = new LinkedList<ModelUpdateListener>(this.muls);
            }
            for (ModelUpdateListener mul : muls2) {
                mul.modelUpdated(compoundModel, de);
            }
        }
    }

    public static interface ModelUpdateListener {
        public void modelUpdated(Models.CompoundModel var1, DebuggerEngine var2);
    }
}

