/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.debugging.DebuggingViewComponent;
import org.netbeans.modules.debugger.ui.views.debugging.FiltersDescriptor;
import org.openide.windows.TopComponent;

public final class DebuggingView {
    private static final DebuggingView INSTANCE = new DebuggingView();
    private Reference<DebuggingViewComponent> dvcRef = new WeakReference<Object>(null);

    private DebuggingView() {
    }

    public static DebuggingView getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebuggingViewComponent getDVC() {
        DebuggingViewComponent dvc;
        DebuggingView debuggingView = this;
        synchronized (debuggingView) {
            dvc = this.dvcRef.get();
            if (dvc == null) {
                dvc = DebuggingViewComponent.getInstance();
                this.dvcRef = new WeakReference<DebuggingViewComponent>(dvc);
            }
        }
        return dvc;
    }

    public TopComponent getViewTC() {
        return this.getDVC();
    }

    public static final class DVFilter {
        private static Reference<Group> sortGroupRef = new WeakReference<Object>(null);
        private final FiltersDescriptor.FilterImpl fimpl;
        private final Group group;

        public static DVFilter getDefault(DefaultFilter filter) {
            Group g;
            FiltersDescriptor.FilterImpl fimpl = FiltersDescriptor.FilterImpl.createDefault(filter);
            switch (filter) {
                case sortAlphabetic: 
                case sortNatural: 
                case sortSuspend: {
                    g = DVFilter.getGroupFor(filter, fimpl);
                    break;
                }
                default: {
                    g = null;
                }
            }
            fimpl.setGroup(g);
            return new DVFilter(fimpl, g);
        }

        private static Group getGroupFor(DefaultFilter filter, FiltersDescriptor.FilterImpl fimpl) {
            Group group = sortGroupRef.get();
            if (group == null) {
                group = new Group();
                sortGroupRef = new WeakReference<Group>(group);
            } else {
                for (DVFilter df : group.getItems()) {
                    if (!df.getImpl().getName().equals(fimpl.getName())) continue;
                    group = new Group();
                    sortGroupRef = new WeakReference<Group>(group);
                }
            }
            return group;
        }

        public static DVFilter create(String name, String displayName, String tooltip, Icon selectedIcon, Preferences valuePrefs, String valuePrefKey, boolean isSelectedDefault, Group group) {
            FiltersDescriptor.FilterImpl fimpl = new FiltersDescriptor.FilterImpl(name, displayName, tooltip, selectedIcon, valuePrefs, valuePrefKey, isSelectedDefault);
            fimpl.setGroup(group);
            return new DVFilter(fimpl, group);
        }

        DVFilter(FiltersDescriptor.FilterImpl fimpl, Group group) {
            this.fimpl = fimpl;
            this.group = group;
            if (group != null) {
                group.add(this);
            }
        }

        private FiltersDescriptor.FilterImpl getImpl() {
            return this.fimpl;
        }

        public Group getGroup() {
            return this.group;
        }

        public String getName() {
            return this.fimpl.getName();
        }

        public String getDisplayName() {
            return this.fimpl.getDisplayName();
        }

        public String getTooltip() {
            return this.fimpl.getTooltip();
        }

        public Icon getIcon() {
            return this.fimpl.getIcon();
        }

        public boolean isSelected() {
            return this.fimpl.isSelected();
        }

        public void setSelected(boolean state) {
            if (!state && this.group != null) {
                boolean isSomeSelected = false;
                for (DVFilter dvf : this.group.getItems()) {
                    if (dvf.getImpl() == this.fimpl || !dvf.isSelected()) continue;
                    isSomeSelected = true;
                    break;
                }
                if (!isSomeSelected) {
                    if ("natural_sort".equals(this.fimpl.getName())) {
                        this.fimpl.setSelected(true);
                        this.fimpl.assureButtonSelected(true);
                        return;
                    }
                    for (DVFilter dvf : this.group.getItems()) {
                        if (!"natural_sort".equals(dvf.getName())) continue;
                        dvf.getImpl().setSelected(true);
                    }
                }
            }
            this.fimpl.setSelected(state);
        }

        public Preferences getPreferences() {
            return this.fimpl.getPreferences();
        }

        public String getPrefKey() {
            return this.fimpl.getPrefKey();
        }

        public static final class Group {
            private final List<DVFilter> items = new LinkedList<DVFilter>();

            void add(DVFilter filter) {
                this.items.add(filter);
            }

            public List<DVFilter> getItems() {
                return this.items;
            }
        }

        public static enum DefaultFilter {
            sortAlphabetic,
            sortSuspend,
            sortNatural,
            showQualifiedNames,
            showMonitors,
            showSystemThreads,
            showSuspendTable,
            showThreadGroups,
            showSuspendedThreadsOnly;

        }
    }

    public static final class Deadlock {
        private final Collection<DVThread> threads;

        private Deadlock(Collection<DVThread> threads) {
            this.threads = threads;
        }

        public Collection<DVThread> getThreads() {
            return this.threads;
        }
    }

    public static interface DVThreadGroup {
        public String getName();

        public DVThreadGroup getParentThreadGroup();

        public DVThread[] getThreads();

        public DVThreadGroup[] getThreadGroups();
    }

    public static interface DVThread {
        public static final String PROP_SUSPENDED = "suspended";
        public static final String PROP_LOCKER_THREADS = "lockerThreads";
        public static final String PROP_BREAKPOINT = "currentBreakpoint";

        public String getName();

        public boolean isSuspended();

        public void resume();

        public void suspend();

        public void makeCurrent();

        public DVSupport getDVSupport();

        public List<DVThread> getLockerThreads();

        public void resumeBlockingThreads();

        public Breakpoint getCurrentBreakpoint();

        public boolean isInStep();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static abstract class DVSupport {
        public static final String PROP_THREAD_STARTED = "threadStarted";
        public static final String PROP_THREAD_DIED = "threadDied";
        public static final String PROP_THREAD_GROUP_ADDED = "threadGroupAdded";
        public static final String PROP_THREAD_SUSPENDED = "threadSuspended";
        public static final String PROP_THREAD_RESUMED = "threadResumed";
        public static final String PROP_CURRENT_THREAD = "currentThread";
        public static final String PROP_DEADLOCK = "deadlock";
        public static final String PROP_STATE = "state";
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        protected DVSupport() {
        }

        public abstract STATE getState();

        public abstract List<DVThread> getAllThreads();

        public abstract DVThread getCurrentThread();

        public abstract String getDisplayName(DVThread var1);

        public abstract Image getIcon(DVThread var1);

        public abstract Session getSession();

        public abstract void resume();

        public abstract Set<Deadlock> getDeadlocks();

        protected final Deadlock createDeadlock(Collection<DVThread> threads) {
            return new Deadlock(threads);
        }

        protected abstract List<DVFilter> getFilters();

        public final Action[] getFilterActions() {
            return FiltersDescriptor.getInstance().getFilterActions();
        }

        protected final void firePropertyChange(PropertyChangeEvent pce) {
            this.pcs.firePropertyChange(pce);
        }

        protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public final void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.addPropertyChangeListener(pcl);
        }

        public final void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.removePropertyChangeListener(pcl);
        }

        static {
            FiltersDescriptor.getInstance().setFiltersAccessor(new FiltersDescriptor.FiltersAccessor(){

                @Override
                public List<DVFilter> getFilters(DVSupport dvs) {
                    return dvs.getFilters();
                }

                @Override
                public FiltersDescriptor.FilterImpl getImpl(DVFilter filter) {
                    return filter.getImpl();
                }
            });
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE})
        public static @interface Registration {
            public String path();

            public int position() default 0x7FFFFFFF;
        }

        public static enum STATE {
            RUNNING,
            DISCONNECTED;

        }
    }
}

