/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.beancontext.BeanContextChildComponentProxy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.debugger.ui.ComponentInfoFromBeanContext;
import org.netbeans.modules.debugger.ui.DebuggerModule;
import org.netbeans.modules.debugger.ui.actions.DebuggerAction;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ui.EngineComponentsProvider;
import org.openide.ErrorManager;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class DebuggerManagerListener
extends DebuggerManagerAdapter {
    private List<DebuggerEngine> openedGroups = new LinkedList<DebuggerEngine>();
    private final Map<DebuggerEngine, Map<EngineComponentsProvider, List<? extends EngineComponentsProvider.ComponentInfo>>> openedComponents = new HashMap<DebuggerEngine, Map<EngineComponentsProvider, List<? extends EngineComponentsProvider.ComponentInfo>>>();
    private static final Set<ComponentInitiallyOpened> componentsInitiallyOpened = new HashSet<ComponentInitiallyOpened>();
    private final Map<DebuggerEngine, List<? extends Component>> closedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<DebuggerEngine, List<? extends Component>> usedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<Component, Dimension> toolbarButtonsPrefferedSize = new HashMap<Component, Dimension>();
    private final Map<Mode, Reference<TopComponent>> lastSelectedTopComponents = new WeakHashMap<Mode, Reference<TopComponent>>();
    private ToolbarContainerListener toolbarContainerListener;
    private static final RequestProcessor RP = new RequestProcessor("Debugger Engine Setup", 1);
    private static final List<EngineComponentsProvider.ComponentInfo> OPENED_COMPONENTS = new LinkedList<EngineComponentsProvider.ComponentInfo>();

    public void engineAdded(DebuggerEngine engine) {
        this.openEngineComponents(engine);
        this.setupToolbar(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openEngineComponents(DebuggerEngine engine) {
        Map<DebuggerEngine, Map<EngineComponentsProvider, List<? extends EngineComponentsProvider.ComponentInfo>>> map = this.openedComponents;
        synchronized (map) {
            if (this.openedComponents.containsKey(engine) || this.openedGroups.contains(engine)) {
                return;
            }
            final List componentProxies = engine.lookup(null, BeanContextChildComponentProxy.class);
            final List componentsProvidersL = engine.lookup(null, EngineComponentsProvider.class);
            if (!componentProxies.isEmpty() || !componentsProvidersL.isEmpty()) {
                boolean filedOpenedComponents;
                final LinkedHashMap<Object, Object> componentsToOpen = new LinkedHashMap<Object, Object>();
                componentsToOpen.put(null, null);
                if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                    this.fillOpenedDebuggerComponents(componentsInitiallyOpened);
                    filedOpenedComponents = true;
                } else {
                    filedOpenedComponents = false;
                }
                RequestProcessor rp = (RequestProcessor)engine.lookupFirst(null, RequestProcessor.class);
                if (rp == null) {
                    rp = RP;
                }
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (filedOpenedComponents) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Map map = DebuggerManagerListener.this.openedComponents;
                                        synchronized (map) {
                                            for (ComponentInitiallyOpened cio : componentsInitiallyOpened) {
                                                cio.initState();
                                            }
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        LinkedHashMap<EngineComponentsProvider, List<EngineComponentsProvider.ComponentInfo>> ecs = new LinkedHashMap<EngineComponentsProvider, List<EngineComponentsProvider.ComponentInfo>>();
                        ArrayList<EngineComponentsProvider.ComponentInfo> cs = new ArrayList<EngineComponentsProvider.ComponentInfo>();
                        try {
                            List<BeanContextComponentProvider> componentsProviders;
                            if (!componentProxies.isEmpty()) {
                                BeanContextComponentProvider bccp = new BeanContextComponentProvider(componentProxies);
                                if (componentsProvidersL.isEmpty()) {
                                    componentsProviders = Collections.singletonList(bccp);
                                } else {
                                    ArrayList<BeanContextComponentProvider> cps = new ArrayList<BeanContextComponentProvider>(componentsProvidersL.size() + 1);
                                    cps.addAll(componentsProvidersL);
                                    cps.add(bccp);
                                    componentsProviders = Collections.unmodifiableList(cps);
                                }
                            } else {
                                componentsProviders = componentsProvidersL;
                            }
                            final LinkedHashMap topComponentsToOpen = new LinkedHashMap();
                            for (EngineComponentsProvider engineComponentsProvider : componentsProviders) {
                                List<EngineComponentsProvider.ComponentInfo> cis = engineComponentsProvider.getComponents();
                                for (final EngineComponentsProvider.ComponentInfo ci : cis) {
                                    if (ci.isOpened()) {
                                        try {
                                            SwingUtilities.invokeAndWait(new Runnable(){

                                                @Override
                                                public void run() {
                                                    Component c = ci.getComponent();
                                                    if (c == null) {
                                                        ErrorManager.getDefault().notify((Throwable)new IllegalStateException("Null component from " + ci));
                                                        return;
                                                    }
                                                    if (c instanceof TopComponent) {
                                                        topComponentsToOpen.put((TopComponent)c, ci);
                                                    } else {
                                                        c.setVisible(true);
                                                    }
                                                }
                                            });
                                        }
                                        catch (Exception ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                            continue;
                                        }
                                    }
                                    cs.add(ci);
                                }
                                ecs.put(engineComponentsProvider, cis);
                            }
                            if (topComponentsToOpen.size() > 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DebuggerManagerListener.this.openTopComponents(topComponentsToOpen);
                                    }
                                });
                            }
                        }
                        finally {
                            Object object = DebuggerManagerListener.this.openedComponents;
                            synchronized (object) {
                                componentsToOpen.clear();
                                componentsToOpen.putAll(ecs);
                                DebuggerManagerListener.this.openedComponents.notifyAll();
                            }
                            object = OPENED_COMPONENTS;
                            synchronized (object) {
                                OPENED_COMPONENTS.addAll(cs);
                            }
                        }
                    }
                });
                this.openedComponents.put(engine, componentsToOpen);
            } else {
                if (this.openedGroups.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
                            if (group != null) {
                                group.open();
                            }
                        }
                    });
                }
                this.openedGroups.add(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOpenedDebuggerComponents(Set<ComponentInitiallyOpened> componentsInitiallyOpened) {
        TopComponent.Registry registry;
        TopComponent.Registry registry2 = registry = TopComponent.getRegistry();
        synchronized (registry2) {
            for (TopComponent tc : registry.getOpened()) {
                componentsInitiallyOpened.add(new ComponentInitiallyOpened((Component)tc));
            }
        }
    }

    private void openTopComponents(Map<TopComponent, EngineComponentsProvider.ComponentInfo> components) {
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<Mode> modesWithVisibleTC = new HashSet<Mode>();
        for (Map.Entry<TopComponent, EngineComponentsProvider.ComponentInfo> tci : components.entrySet()) {
            Mode mode;
            TopComponent tc = tci.getKey();
            EngineComponentsProvider.ComponentInfo ci = tci.getValue();
            boolean wasOpened = tc.isOpened();
            tc.open();
            if (!wasOpened || !ci.isMinimized()) {
                WindowManager.getDefault().setTopComponentMinimized(tc, ci.isMinimized());
            }
            if (!modesWithVisibleTC.add(mode = WindowManager.getDefault().findMode(tc))) continue;
            TopComponent tcSel = mode.getSelectedTopComponent();
            if (tcSel != null && tcSel != tc) {
                WeakReference<TopComponent> lastSelectedTCRef = new WeakReference<TopComponent>(tcSel);
                this.lastSelectedTopComponents.put(mode, lastSelectedTCRef);
            }
            String side = null;
            try {
                side = (String)mode.getClass().getMethod("getSide", new Class[0]).invoke((Object)mode, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (side != null) continue;
            tc.requestVisible();
        }
    }

    private void closeTopComponentsList(List<TopComponent> components) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<TopComponent> componentToActivateAfterClose = new ArrayList<TopComponent>();
        for (TopComponent tc : components) {
            TopComponent tcAct;
            Reference<TopComponent> tcActRef;
            Mode mode = WindowManager.getDefault().findMode(tc);
            if (mode.getSelectedTopComponent() == tc && (tcActRef = this.lastSelectedTopComponents.remove(mode)) != null && (tcAct = tcActRef.get()) != null && tcAct.isOpened()) {
                componentToActivateAfterClose.add(tcAct);
            }
            tc.close();
        }
        for (TopComponent tc : componentToActivateAfterClose) {
            tc.requestVisible();
        }
    }

    private DebuggerAction getDebuggerAction(Component c) {
        if (c instanceof AbstractButton) {
            Action a = ((AbstractButton)c).getAction();
            if (a == null) {
                ActionListener[] actionListeners;
                for (ActionListener l : actionListeners = ((AbstractButton)c).getActionListeners()) {
                    if (!(l instanceof Action)) continue;
                    a = (Action)l;
                    break;
                }
            }
            if (a != null && a instanceof DebuggerAction) {
                return (DebuggerAction)a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupToolbar(final DebuggerEngine engine) {
        boolean isFirst;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        final ArrayList<Label> buttonsToClose = new ArrayList<Label>();
        buttonsToClose.add(new Label("EMPTY"));
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            isFirst = this.closedToolbarButtons.isEmpty();
            this.closedToolbarButtons.put(engine, buttonsToClose);
        }
        RequestProcessor rp = (RequestProcessor)engine.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            rp = RP;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                List actionsProviderList = engine.lookup(null, ActionsProvider.class);
                final HashSet engineActions = new HashSet();
                for (ActionsProvider ap : actionsProviderList) {
                    engineActions.addAll(ap.getActions());
                }
                ToolbarPool.getDefault().waitFinished();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList<Component> buttonsClosed = new ArrayList<Component>();
                        ArrayList<Component> buttonsUsed = new ArrayList<Component>();
                        try {
                            Toolbar debugToolbar;
                            if (ToolbarPool.getDefault().getConfiguration().equals("Standard")) {
                                ToolbarPool.getDefault().setConfiguration("Debugging");
                            }
                            if ((debugToolbar = ToolbarPool.getDefault().findToolbar("Debug")) == null) {
                                return;
                            }
                            DebuggerManagerListener.this.registerToolbarListener(debugToolbar);
                            for (Component c : debugToolbar.getComponents()) {
                                DebuggerAction a = DebuggerManagerListener.this.getDebuggerAction(c);
                                if (a == null) continue;
                                Object action = a.getAction();
                                boolean containsAction = engineActions.contains(action);
                                if (isFirst && !containsAction) {
                                    c.setVisible(false);
                                    buttonsClosed.add(c);
                                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                                    c.setPreferredSize(new Dimension(0, 0));
                                }
                                if (!isFirst && containsAction) {
                                    Dimension d = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
                                    if (d != null) {
                                        c.setPreferredSize(d);
                                    }
                                    c.setVisible(true);
                                }
                                if (!containsAction) continue;
                                buttonsUsed.add(c);
                            }
                            debugToolbar.revalidate();
                            debugToolbar.repaint();
                        }
                        finally {
                            Map map = DebuggerManagerListener.this.closedToolbarButtons;
                            synchronized (map) {
                                DebuggerManagerListener.this.usedToolbarButtons.put(engine, buttonsUsed);
                                buttonsToClose.clear();
                                buttonsToClose.addAll(buttonsClosed);
                                DebuggerManagerListener.this.closedToolbarButtons.notifyAll();
                            }
                        }
                    }
                });
            }
        });
    }

    public void engineRemoved(final DebuggerEngine engine) {
        DebuggerModule dm = (DebuggerModule)DebuggerModule.findObject(DebuggerModule.class);
        if (dm != null && dm.isClosing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        RP.post((Runnable)this);
                    } else {
                        DebuggerManagerListener.this.doEngineRemoved(engine);
                    }
                }
            });
        } else {
            this.doEngineRemoved(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEngineRemoved(DebuggerEngine engine) {
        Map<DebuggerEngine, Map<EngineComponentsProvider, List<? extends EngineComponentsProvider.ComponentInfo>>> map = this.openedComponents;
        synchronized (map) {
            final Map<EngineComponentsProvider, List<? extends EngineComponentsProvider.ComponentInfo>> openedWindowsByProvider = this.openedComponents.remove(engine);
            if (openedWindowsByProvider != null) {
                while (openedWindowsByProvider.size() == 1 && openedWindowsByProvider.containsKey(null)) {
                    try {
                        this.openedComponents.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ArrayList<? extends EngineComponentsProvider.ComponentInfo> openedWindows = new ArrayList<EngineComponentsProvider.ComponentInfo>();
                for (List<? extends EngineComponentsProvider.ComponentInfo> lci : openedWindowsByProvider.values()) {
                    if (lci == null) continue;
                    openedWindows.addAll(lci);
                }
                final ArrayList retainOpened = new ArrayList();
                for (Map map2 : this.openedComponents.values()) {
                    for (List lci : map2.values()) {
                        if (lci == null) continue;
                        retainOpened.addAll(lci);
                    }
                }
                final ArrayList<Component> initiallyOpened = new ArrayList<Component>();
                final HashSet<Component> hashSet = new HashSet<Component>();
                for (ComponentInitiallyOpened cio : componentsInitiallyOpened) {
                    Component c = cio.getComponent();
                    if (c == null) continue;
                    initiallyOpened.add(c);
                    if (!cio.isMinimized()) continue;
                    hashSet.add(c);
                }
                final ArrayList windowsToClose = new ArrayList(openedWindows);
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ArrayList<Component> retainOpenedComponents = new ArrayList<Component>(retainOpened.size());
                            for (EngineComponentsProvider.ComponentInfo ci : retainOpened) {
                                Component c = ci.getComponent();
                                if (c == null) {
                                    ErrorManager.getDefault().notify((Throwable)new IllegalStateException("Null component from " + ci));
                                    continue;
                                }
                                retainOpenedComponents.add(c);
                            }
                            for (Object c : initiallyOpened) {
                                boolean initialOnly;
                                if (c == null || !(initialOnly = retainOpenedComponents.add((Component)c)) || !(c instanceof TopComponent)) continue;
                                WindowManager.getDefault().setTopComponentMinimized((TopComponent)c, hashSet.contains(c));
                            }
                            ArrayList windowsToCloseCopy = (ArrayList)((ArrayList)windowsToClose).clone();
                            for (EngineComponentsProvider.ComponentInfo ci : windowsToCloseCopy) {
                                Component c = ci.getComponent();
                                if (!retainOpenedComponents.contains(c)) continue;
                                windowsToClose.remove(ci);
                            }
                            for (EngineComponentsProvider ecp : openedWindowsByProvider.keySet()) {
                                List cis = (List)openedWindowsByProvider.get(ecp);
                                ArrayList<EngineComponentsProvider.ComponentInfo> closing = new ArrayList<EngineComponentsProvider.ComponentInfo>(cis);
                                closing.retainAll(windowsToClose);
                                ecp.willCloseNotify(closing);
                            }
                            ArrayList<TopComponent> topComponentsToClose = new ArrayList<TopComponent>(windowsToClose.size());
                            for (EngineComponentsProvider.ComponentInfo ci : windowsToClose) {
                                Component c = ci.getComponent();
                                if (c == null) {
                                    ErrorManager.getDefault().notify((Throwable)new IllegalStateException("Null component from " + ci));
                                    continue;
                                }
                                if (c instanceof TopComponent) {
                                    TopComponent tc = (TopComponent)c;
                                    boolean isOpened = tc.isOpened();
                                    if (!isOpened) continue;
                                    topComponentsToClose.add(tc);
                                    continue;
                                }
                                c.setVisible(false);
                            }
                            DebuggerManagerListener.this.closeTopComponentsList(topComponentsToClose);
                            List list = OPENED_COMPONENTS;
                            synchronized (list) {
                                OPENED_COMPONENTS.removeAll(windowsToClose);
                            }
                        }
                    });
                }
                catch (Exception exc) {
                    Exceptions.printStackTrace((Throwable)exc);
                }
            } else {
                this.openedGroups.remove(engine);
                if (this.openedGroups.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
                            if (group != null) {
                                group.close();
                            }
                        }
                    });
                }
            }
            if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                componentsInitiallyOpened.clear();
                List<EngineComponentsProvider.ComponentInfo> list = OPENED_COMPONENTS;
                synchronized (list) {
                    OPENED_COMPONENTS.clear();
                }
            }
        }
        this.closeToolbar(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeToolbar(DebuggerEngine engine) {
        boolean doCloseToolbar;
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            List<? extends Component> closedButtons = this.closedToolbarButtons.remove(engine);
            doCloseToolbar = this.closedToolbarButtons.isEmpty();
            if (closedButtons != null) {
                while (closedButtons.size() == 1 && closedButtons.get(0) instanceof Label) {
                    try {
                        this.closedToolbarButtons.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                List<? extends Component> usedButtons = this.usedToolbarButtons.remove(engine);
                ToolbarPool.getDefault().waitFinished();
                if (!ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
                    return;
                }
                final Toolbar debugToolbar = ToolbarPool.getDefault().findToolbar("Debug");
                if (debugToolbar == null) {
                    return;
                }
                if (!doCloseToolbar) {
                    ArrayList<? extends Component> usedByAllButtons = new ArrayList<Component>();
                    for (List<? extends Component> ltc : this.usedToolbarButtons.values()) {
                        usedByAllButtons.addAll(ltc);
                    }
                    final ArrayList<? extends Component> buttonsToClose = new ArrayList<Component>(usedButtons);
                    buttonsToClose.removeAll(usedByAllButtons);
                    if (!buttonsToClose.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (Component c : buttonsToClose) {
                                    c.setVisible(false);
                                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                                    c.setPreferredSize(new Dimension(0, 0));
                                }
                                debugToolbar.revalidate();
                                debugToolbar.repaint();
                            }
                        });
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (Component c : debugToolbar.getComponents()) {
                                if (!(c instanceof AbstractButton)) continue;
                                Dimension d = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
                                if (d != null) {
                                    c.setPreferredSize(d);
                                }
                                c.setVisible(true);
                            }
                            debugToolbar.revalidate();
                            debugToolbar.repaint();
                        }
                    });
                }
            }
        }
        if (doCloseToolbar) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Toolbar debugToolbar = ToolbarPool.getDefault().findToolbar("Debug");
                    if (debugToolbar != null) {
                        DebuggerManagerListener.this.unregisterToolbarListener(debugToolbar);
                    }
                    if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
                        ToolbarPool.getDefault().setConfiguration("Standard");
                    }
                }
            });
        }
    }

    private void registerToolbarListener(Toolbar debugToolbar) {
        if (this.toolbarContainerListener == null) {
            this.toolbarContainerListener = new ToolbarContainerListener();
            debugToolbar.addContainerListener((ContainerListener)this.toolbarContainerListener);
        }
    }

    private void unregisterToolbarListener(Toolbar debugToolbar) {
        if (this.toolbarContainerListener != null) {
            debugToolbar.removeContainerListener((ContainerListener)this.toolbarContainerListener);
            this.toolbarContainerListener = null;
        }
    }

    static void closeDebuggerUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerManagerListener.doCloseDebuggerUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebuggerManagerListener.doCloseDebuggerUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCloseDebuggerUI() {
        TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
        if (group != null) {
            group.close();
        }
        List<EngineComponentsProvider.ComponentInfo> list = OPENED_COMPONENTS;
        synchronized (list) {
            Component c;
            Set initiallyOpenedMinimized;
            List initiallyOpened;
            if (componentsInitiallyOpened.isEmpty()) {
                initiallyOpened = Collections.emptyList();
                initiallyOpenedMinimized = Collections.emptySet();
            } else {
                initiallyOpened = new ArrayList();
                initiallyOpenedMinimized = new HashSet();
                for (ComponentInitiallyOpened cio : componentsInitiallyOpened) {
                    c = cio.getComponent();
                    if (c == null) continue;
                    initiallyOpened.add(c);
                    if (!cio.isMinimized()) continue;
                    initiallyOpenedMinimized.add(c);
                }
            }
            for (EngineComponentsProvider.ComponentInfo ci : OPENED_COMPONENTS) {
                c = ci.getComponent();
                if (initiallyOpened.contains(c)) {
                    if (!(c instanceof TopComponent)) continue;
                    WindowManager.getDefault().setTopComponentMinimized((TopComponent)c, initiallyOpenedMinimized.contains(c));
                    continue;
                }
                if (c instanceof TopComponent) {
                    ((TopComponent)c).close();
                    continue;
                }
                if (c == null) continue;
                c.setVisible(false);
            }
            OPENED_COMPONENTS.clear();
            componentsInitiallyOpened.clear();
        }
        ToolbarPool.getDefault().waitFinished();
        if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
            ToolbarPool.getDefault().setConfiguration("Standard");
        }
    }

    private static class ComponentInitiallyOpened {
        private final Reference<Component> componentRef;
        private boolean isMinimized;

        public ComponentInitiallyOpened(Component c) {
            this.componentRef = new WeakReference<Component>(c);
        }

        public Component getComponent() {
            return this.componentRef.get();
        }

        public boolean isMinimized() {
            return this.isMinimized;
        }

        private void initState() {
            Component c = this.getComponent();
            this.isMinimized = c instanceof TopComponent ? WindowManager.getDefault().isTopComponentMinimized((TopComponent)c) : false;
        }
    }

    private static class BeanContextComponentProvider
    implements EngineComponentsProvider {
        private final List<? extends BeanContextChildComponentProxy> componentProxies;

        public BeanContextComponentProvider(List<? extends BeanContextChildComponentProxy> componentProxies) {
            this.componentProxies = componentProxies;
        }

        @Override
        public List<EngineComponentsProvider.ComponentInfo> getComponents() {
            return ComponentInfoFromBeanContext.transform(this.componentProxies);
        }

        @Override
        public void willCloseNotify(List<EngineComponentsProvider.ComponentInfo> components) {
            ComponentInfoFromBeanContext.closing(components);
        }
    }

    private class ToolbarContainerListener
    implements ContainerListener {
        private final Map<DebuggerAction, Set<DebuggerEngine>> buttonActionsUsed = new HashMap<DebuggerAction, Set<DebuggerEngine>>();
        private final Map<DebuggerAction, Set<DebuggerEngine>> buttonActionsClosed = new HashMap<DebuggerAction, Set<DebuggerEngine>>();
        private boolean clearScheduled = false;

        private ToolbarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            DebuggerAction action = DebuggerManagerListener.this.getDebuggerAction(c);
            if (action != null) {
                Set<DebuggerEngine> closedEngines;
                Set<DebuggerEngine> usedEngines = this.buttonActionsUsed.get(action);
                if (usedEngines != null) {
                    for (DebuggerEngine engine : usedEngines) {
                        List buttonsUsed = (List)DebuggerManagerListener.this.usedToolbarButtons.get(engine);
                        buttonsUsed.add(c);
                    }
                }
                if ((closedEngines = this.buttonActionsClosed.get(action)) != null) {
                    for (DebuggerEngine engine : closedEngines) {
                        List buttonsClosed = (List)DebuggerManagerListener.this.closedToolbarButtons.get(engine);
                        buttonsClosed.add(c);
                    }
                }
                if (usedEngines == null && closedEngines != null) {
                    c.setVisible(false);
                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                    c.setPreferredSize(new Dimension(0, 0));
                }
                if (usedEngines == null && closedEngines == null) {
                    for (DebuggerEngine engine : DebuggerManagerListener.this.usedToolbarButtons.keySet()) {
                        List buttonsUsed = (List)DebuggerManagerListener.this.usedToolbarButtons.get(engine);
                        buttonsUsed.add(c);
                    }
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            DebuggerAction action = DebuggerManagerListener.this.getDebuggerAction(c);
            if (action != null) {
                HashSet<DebuggerEngine> usedEngines = null;
                HashSet<DebuggerEngine> closedEngines = null;
                for (DebuggerEngine engine : DebuggerManagerListener.this.usedToolbarButtons.keySet()) {
                    if (!((List)DebuggerManagerListener.this.usedToolbarButtons.get(engine)).remove(c)) continue;
                    if (usedEngines == null) {
                        usedEngines = new HashSet<DebuggerEngine>();
                    }
                    usedEngines.add(engine);
                }
                for (DebuggerEngine engine : DebuggerManagerListener.this.closedToolbarButtons.keySet()) {
                    if (!((List)DebuggerManagerListener.this.closedToolbarButtons.get(engine)).remove(c)) continue;
                    if (closedEngines == null) {
                        closedEngines = new HashSet<DebuggerEngine>();
                    }
                    closedEngines.add(engine);
                }
                if (usedEngines != null) {
                    this.buttonActionsUsed.put(action, usedEngines);
                }
                if (closedEngines != null) {
                    this.buttonActionsClosed.put(action, closedEngines);
                }
            }
            DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
            if (!this.clearScheduled) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolbarContainerListener.this.buttonActionsUsed.clear();
                        ToolbarContainerListener.this.buttonActionsClosed.clear();
                        ToolbarContainerListener.this.clearScheduled = false;
                    }
                });
            }
        }
    }
}

