/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.io.IOException;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.XMLSyntaxParser;
import org.w3c.dom.NodeList;

public class Utils {
    public static void replaceDocument(javax.swing.text.Document doc, String newDoc, String prefixMark) throws BadLocationException {
        int offset;
        int tailIndex;
        String newDocument;
        if (doc == null) {
            return;
        }
        String origDocument = doc.getText(0, doc.getLength());
        if (origDocument.equals(newDocument = newDoc)) {
            return;
        }
        char[] origChars = origDocument.toCharArray();
        char[] newcChars = newDocument.toCharArray();
        int delta = newcChars.length - (tailIndex = origChars.length);
        int n = delta < 0 ? tailIndex + delta : tailIndex;
        for (offset = 0; offset < n && origChars[offset] == newcChars[offset]; ++offset) {
        }
        n = delta < 0 ? offset - delta : offset;
        int i = tailIndex - 1;
        while (i >= n && origChars[i] == newcChars[i + delta]) {
            tailIndex = i--;
        }
        String s = newDocument.substring(offset, tailIndex + delta);
        int length = tailIndex - offset;
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).replace(offset, length, s, null);
        } else {
            if (length > 0) {
                doc.remove(offset, length);
            }
            if (s.length() > 0) {
                doc.insertString(offset, s, null);
            }
        }
    }

    public static void replaceDocument(javax.swing.text.Document doc, String newDoc) throws BadLocationException {
        Utils.replaceDocument(doc, newDoc, null);
    }

    public static String filterEndLines(String str) {
        char[] text = str.toCharArray();
        if (text.length == 0) {
            return "";
        }
        int pos = 0;
        for (int i = 0; i < text.length; ++i) {
            char c = text[i];
            if (c == '\r') continue;
            if (pos != i) {
                text[pos] = c;
            }
            ++pos;
        }
        return new String(text, 0, pos);
    }

    public static BaseDocument loadDocument(String text) throws IOException {
        BaseDocument sd = new BaseDocument(true, "text/xml");
        sd.putProperty(Language.class, (Object)XMLTokenId.language());
        try {
            sd.insertString(0, text, null);
            return sd;
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getLocalizedMessage());
        }
    }

    public static NodeList parseFragment(String text) throws IOException {
        StringBuilder sb = new StringBuilder(text.length() + 20);
        sb.append("<r>");
        sb.append(text);
        sb.append("</r>");
        XMLSyntaxParser parser = new XMLSyntaxParser();
        try {
            Document dom = parser.parse(Utils.loadDocument(sb.toString()));
            return dom.getDocumentElement().getChildNodes();
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getLocalizedMessage());
        }
    }
}

