/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.api;

import java.util.Collection;
import org.netbeans.modules.websvc.wsstack.WSStackAccessor;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.openide.util.Lookup;

public final class WSStack<T> {
    private final WSStackImplementation<T> impl;
    private final Source stackSource;
    private final Class<T> stackDescriptor;

    public static <T> WSStack<T> findWSStack(Lookup lookupContext, Class<T> stackDescriptor) {
        Collection wsStacks = lookupContext.lookupAll(WSStack.class);
        for (WSStack wsStack : wsStacks) {
            if (wsStack.stackDescriptor != stackDescriptor) continue;
            return wsStack;
        }
        return null;
    }

    private WSStack(Class<T> stackDescriptor, WSStackImplementation<T> impl, Source stackSource) {
        this.impl = impl;
        this.stackSource = stackSource;
        this.stackDescriptor = stackDescriptor;
    }

    public T get() {
        return this.impl.get();
    }

    public WSStackVersion getVersion() {
        return this.impl.getVersion();
    }

    public WSTool getWSTool(Tool toolId) {
        return this.impl.getWSTool(toolId);
    }

    public boolean isFeatureSupported(Feature feature) {
        return this.impl.isFeatureSupported(feature);
    }

    public Source getSource() {
        return this.stackSource;
    }

    static {
        WSStackAccessor.DEFAULT = new WSStackAccessor(){

            @Override
            public <T> WSStack<T> createWSStack(Class<T> clazz, WSStackImplementation<T> spi, Source stackSource) {
                return new WSStack(clazz, spi, stackSource);
            }
        };
    }

    public static enum Source {
        IDE,
        JDK,
        SERVER;

    }

    public static interface Tool {
        public String getName();
    }

    public static interface Feature {
        public String getName();
    }
}

