/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.modules.sampler.SamplesOutputStream;

class CLISampler
extends Sampler {
    private final ThreadMXBean threadMXBean;
    private final File output;

    public static void main(String ... args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: <port> <snapshot.npss>");
            System.out.println();
            System.out.println("First of all start your application with following parameters:");
            System.out.println("  -Dcom.sun.management.jmxremote.authenticate=false");
            System.out.println("  -Dcom.sun.management.jmxremote.ssl=false");
            System.out.println("  -Dcom.sun.management.jmxremote.port=<port>");
            System.out.println("Then you can start this sampler with correct port and file to write snapshot to.");
            System.exit(1);
        }
        if (!SamplesOutputStream.isSupported()) {
            System.err.println("Sampling is not supported by JVM");
            System.exit(2);
        }
        Object u = args[0];
        try {
            u = "service:jmx:rmi:///jndi/rmi://localhost:" + Integer.parseInt(args[0]) + "/jmxrmi";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.err.println("Connecting to " + (String)u);
        JMXServiceURL url = new JMXServiceURL((String)u);
        JMXConnector jmxc = null;
        Throwable ex = null;
        for (int i = 0; i < 100; ++i) {
            try {
                jmxc = JMXConnectorFactory.connect(url, null);
                break;
            }
            catch (IOException e) {
                ex = e;
                System.err.println("Connection failed. Will retry in 300ms.");
                Thread.sleep(300L);
                continue;
            }
        }
        if (jmxc == null) {
            ex.printStackTrace();
            System.err.println("Cannot connect to " + (String)u);
            System.exit(3);
        }
        MBeanServerConnection server = jmxc.getMBeanServerConnection();
        ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
        File output = new File(args[1]);
        CLISampler s = new CLISampler(threadMXBean, output);
        s.start();
        System.out.println("Press enter to generate sample into " + output);
        System.in.read();
        s.stop();
        System.out.println();
        System.out.println("Sample written to " + output);
        System.exit(0);
    }

    CLISampler(ThreadMXBean threadBean, File out) {
        super("CLISampler");
        this.threadMXBean = threadBean;
        this.output = out;
    }

    @Override
    protected ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    protected void saveSnapshot(byte[] arr) throws IOException {
        try (FileOutputStream os = new FileOutputStream(this.output);){
            os.write(arr);
        }
    }

    @Override
    protected void printStackTrace(Throwable ex) {
        ex.printStackTrace();
        System.exit(2);
    }

    @Override
    protected void openProgress(int steps) {
    }

    @Override
    protected void closeProgress() {
    }

    @Override
    protected void progress(int i) {
        System.out.print("#");
        System.out.flush();
    }
}

