/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.project.ant.AntBuildExtenderAccessor;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.netbeans.modules.project.spi.intern.ProjectIDEServicesImplementation;
import org.netbeans.spi.project.ant.GeneratedFilesInterceptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class GeneratedFilesHelper {
    public static final String BUILD_XML_PATH = "build.xml";
    public static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    static final String GENFILES_PROPERTIES_PATH = "nbproject/genfiles.properties";
    private static final String KEY_SUFFIX_DATA_CRC = ".data.CRC32";
    private static final String KEY_SUFFIX_STYLESHEET_CRC_PLUS_VERSION = ".stylesheet.CRC32";
    private static final String KEY_SUFFIX_SCRIPT_CRC = ".script.CRC32";
    public static final int FLAG_MISSING = 2;
    public static final int FLAG_MODIFIED = 4;
    public static final int FLAG_OLD_PROJECT_XML = 8;
    public static final int FLAG_OLD_STYLESHEET = 16;
    public static final int FLAG_UNKNOWN = 32;
    private final AntProjectHelper h;
    private final FileObject dir;
    private AntBuildExtender extender;
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    private static final Map<URL, String> crcCache = new HashMap<URL, String>();
    private static final Map<URL, Long> crcCacheTimestampsXorSizes = new HashMap<URL, Long>();
    static final Map<URL, SpecificationVersion> STYLESHEET_VERSIONS = new HashMap<URL, SpecificationVersion>();

    public GeneratedFilesHelper(AntProjectHelper h) {
        this.h = h;
        this.dir = h.getProjectDirectory();
    }

    public GeneratedFilesHelper(AntProjectHelper h, AntBuildExtender ex) {
        this(h);
        this.extender = ex;
    }

    public GeneratedFilesHelper(FileObject d) {
        if (d == null || !d.isFolder() || d.getFileObject("nbproject/project.xml") == null) {
            throw new IllegalArgumentException("Does not look like an Ant-based project: " + d);
        }
        this.h = null;
        this.dir = d;
    }

    public void generateBuildScriptFromStylesheet(final String path, final URL stylesheet) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (stylesheet == null) {
            throw new IllegalArgumentException("Null stylesheet");
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (GeneratedFilesHelper.this.h != null) {
                        GeneratedFilesHelper.this.h.ensureProjectXmlUnmodified("Cannot generate build scripts from a modified project", true);
                    }
                    GeneratedFilesHelper.this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            byte[] resultData;
                            byte[] stylesheetData;
                            byte[] projectXmlData;
                            FileObject projectXml = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                            if (projectXml == null) {
                                throw new IOException("Missing project metadata: " + GeneratedFilesHelper.this.h.resolveFile("nbproject/project.xml"));
                            }
                            try (InputStream is = projectXml.getInputStream();){
                                projectXmlData = GeneratedFilesHelper.load(is);
                            }
                            is = stylesheet.openStream();
                            try {
                                stylesheetData = GeneratedFilesHelper.load(is);
                            }
                            finally {
                                is.close();
                            }
                            TransformerFactory tf = TransformerFactory.newInstance();
                            try {
                                StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheetData), stylesheet.toExternalForm());
                                Transformer t = tf.newTransformer(stylesheetSource);
                                try {
                                    t.setOutputProperty(GeneratedFilesHelper.ORACLE_IS_STANDALONE, "yes");
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                File projectXmlF = FileUtil.toFile((FileObject)projectXml);
                                assert (projectXmlF != null);
                                StreamSource projectXmlSource = new StreamSource(new ByteArrayInputStream(projectXmlData), BaseUtilities.toURI((File)projectXmlF).toString());
                                ByteArrayOutputStream result = new ByteArrayOutputStream();
                                t.transform(projectXmlSource, new StreamResult(result));
                                resultData = GeneratedFilesHelper.BUILD_IMPL_XML_PATH.equals(path) ? GeneratedFilesHelper.this.applyBuildExtensions(result.toByteArray(), GeneratedFilesHelper.this.extender) : result.toByteArray();
                            }
                            catch (TransformerException e) {
                                throw (IOException)new IOException(e.toString()).initCause(e);
                            }
                            final EditableProperties p = new EditableProperties(true);
                            FileObject genfiles = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            if (genfiles != null && genfiles.isVirtual()) {
                                genfiles = null;
                            }
                            if (genfiles != null) {
                                is = genfiles.getInputStream();
                                try {
                                    p.load(is);
                                }
                                finally {
                                    is.close();
                                }
                            }
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(projectXmlData), projectXml));
                            if (genfiles == null) {
                                p.setComment(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, new String[]{"# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_1"), "# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_2")}, false);
                            }
                            String crc = GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(stylesheetData), stylesheet);
                            SpecificationVersion v = GeneratedFilesHelper.stylesheetVersion(stylesheet);
                            if (v != null) {
                                crc = crc + "@" + v;
                            }
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC_PLUS_VERSION, crc);
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC, GeneratedFilesHelper.computeCrc32(new ByteArrayInputStream(resultData)));
                            if (genfiles == null) {
                                genfiles = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            }
                            final FileObject _genfiles = genfiles;
                            final FileSystem.AtomicAction body = new FileSystem.AtomicAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() throws IOException {
                                    FileObject buildScriptXml = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)path);
                                    assert (buildScriptXml.isValid());
                                    FileLock lock1 = buildScriptXml.lock();
                                    try {
                                        FileLock lock2 = _genfiles.lock();
                                        try (EolFilterOutputStream os1 = new EolFilterOutputStream(buildScriptXml.getOutputStream(lock1));
                                             OutputStream os2 = _genfiles.getOutputStream(lock2);){
                                            ((OutputStream)os1).write(resultData);
                                            p.store(os2);
                                        }
                                        finally {
                                            lock2.releaseLock();
                                        }
                                    }
                                    finally {
                                        lock1.releaseLock();
                                    }
                                    GeneratedFilesHelper.callInterceptors(GeneratedFilesHelper.this.dir, path);
                                }
                            };
                            try {
                                body.run();
                            }
                            catch (IOException ioe) {
                                if (!ProjectIDEServices.isUserQuestionException((IOException)ioe)) {
                                    throw ioe;
                                }
                                ProjectIDEServices.handleUserQuestionException((IOException)ioe, (ProjectIDEServicesImplementation.UserQuestionExceptionCallback)new ProjectIDEServicesImplementation.UserQuestionExceptionCallback(){

                                    public void accepted() {
                                        try {
                                            body.run();
                                        }
                                        catch (IOException ioe2) {
                                            if (!ProjectIDEServices.isUserQuestionException((IOException)ioe2)) {
                                                Logger.getLogger(GeneratedFilesHelper.this.getClass().getName()).log(Level.SEVERE, null, ioe2);
                                            }
                                            ProjectIDEServices.handleUserQuestionException((IOException)ioe2, (ProjectIDEServicesImplementation.UserQuestionExceptionCallback)new ProjectIDEServicesImplementation.UserQuestionExceptionCallback(){

                                                public void accepted() {
                                                    try {
                                                        body.run();
                                                    }
                                                    catch (IOException e) {
                                                        Logger.getLogger(GeneratedFilesHelper.this.getClass().getName()).log(Level.SEVERE, null, e);
                                                    }
                                                }

                                                public void denied() {
                                                }

                                                public void error(IOException e) {
                                                    Logger.getLogger(GeneratedFilesHelper.this.getClass().getName()).log(Level.SEVERE, null, e);
                                                }
                                            });
                                        }
                                    }

                                    public void denied() {
                                    }

                                    public void error(IOException e) {
                                        Logger.getLogger(GeneratedFilesHelper.this.getClass().getName()).log(Level.SEVERE, null, e);
                                    }
                                });
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private byte[] applyBuildExtensions(byte[] resultData, AntBuildExtender ext) {
        if (ext == null) {
            return resultData;
        }
        try {
            ByteArrayInputStream in2 = new ByteArrayInputStream(resultData);
            InputSource is = new InputSource(in2);
            Document doc = XMLUtil.parse((InputSource)is, (boolean)false, (boolean)true, null, null);
            Element el = doc.getDocumentElement();
            Node firstSubnode = el.getFirstChild();
            for (AntBuildExtender.Extension extension : AntBuildExtenderAccessor.DEFAULT.getExtensions(ext)) {
                Text after = doc.createTextNode("\n");
                el.insertBefore(after, firstSubnode);
                Element imp = this.createImportElement(AntBuildExtenderAccessor.DEFAULT.getPath(extension), doc);
                el.insertBefore(imp, after);
                Text before = doc.createTextNode("    ");
                el.insertBefore(before, imp);
                firstSubnode = before;
                NodeList nl = el.getElementsByTagName("target");
                Map<String, Collection<String>> deps = AntBuildExtenderAccessor.DEFAULT.getDependencies(extension);
                for (String targetName : deps.keySet()) {
                    Element targetEl = null;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element elem = (Element)nl.item(i);
                        String at = elem.getAttribute("name");
                        if (at == null || !at.equals(targetName)) continue;
                        targetEl = elem;
                        break;
                    }
                    if (targetEl == null) continue;
                    Attr depend = targetEl.getAttributeNode("depends");
                    if (depend == null) {
                        depend = doc.createAttribute("depends");
                        depend.setValue("");
                        targetEl.setAttributeNode(depend);
                    }
                    String oldVal = depend.getValue();
                    for (String targ : deps.get(targetName)) {
                        oldVal = oldVal + "," + targ;
                    }
                    if (oldVal.startsWith(",")) {
                        oldVal = oldVal.substring(1);
                    }
                    depend.setValue(oldVal);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
            return out.toByteArray();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return resultData;
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return resultData;
        }
    }

    private Element createImportElement(String path, Document doc) {
        Element el = doc.createElement("import");
        el.setAttribute("file", path);
        return el;
    }

    private static byte[] load(InputStream is) throws IOException {
        int read;
        int size = Math.max(1024, is.available());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[size];
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    public int getBuildScriptState(final String path, final URL stylesheet) {
        try {
            return (Integer)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Integer run() throws IOException {
                    String crc;
                    FileObject script;
                    if (GeneratedFilesHelper.this.h != null) {
                        GeneratedFilesHelper.this.h.ensureProjectXmlUnmodified("Cannot generate build scripts from a modified project", false);
                    }
                    if ((script = GeneratedFilesHelper.this.dir.getFileObject(path)) == null || script.isVirtual()) {
                        return 2;
                    }
                    int flags = 0;
                    Properties p = new Properties();
                    FileObject genfiles = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                    if (genfiles == null || genfiles.isVirtual()) {
                        return 60;
                    }
                    try (BufferedInputStream is = new BufferedInputStream(genfiles.getInputStream());){
                        p.load(is);
                    }
                    FileObject projectXml = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                    if (projectXml != null && !projectXml.isVirtual()) {
                        crc = GeneratedFilesHelper.getCrc32(projectXml);
                        if (!crc.equals(p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC))) {
                            flags |= 8;
                        }
                    } else {
                        flags |= 8;
                    }
                    crc = GeneratedFilesHelper.getCrc32(stylesheet);
                    String oldCrcAndV = p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC_PLUS_VERSION);
                    if (oldCrcAndV == null) {
                        flags |= 0x10;
                    } else if (oldCrcAndV.indexOf(64) != -1) {
                        String[] split = oldCrcAndV.split("@", 2);
                        if (!crc.equals(split[0])) {
                            SpecificationVersion newV = GeneratedFilesHelper.stylesheetVersion(stylesheet);
                            try {
                                if (newV == null || newV.compareTo((Object)new SpecificationVersion(split[1])) >= 0) {
                                    flags |= 0x10;
                                }
                            }
                            catch (NumberFormatException x) {
                                flags |= 0x10;
                            }
                        }
                    } else if (!crc.equals(oldCrcAndV)) {
                        flags |= 0x10;
                    }
                    crc = GeneratedFilesHelper.getCrc32(script);
                    if (!crc.equals(p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC))) {
                        flags |= 4;
                    }
                    return flags;
                }
            });
        }
        catch (MutexException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
            return 60;
        }
    }

    static String computeCrc32(InputStream is) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = is.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static synchronized String findCachedCrc32(URL u, long footprint) {
        String crc = crcCache.get(u);
        if (crc != null) {
            Long l = crcCacheTimestampsXorSizes.get(u);
            assert (l != null);
            if (l == footprint) {
                return crc;
            }
        }
        return null;
    }

    private static synchronized void cacheCrc32(String crc, URL u, long footprint) {
        crcCache.put(u, crc);
        crcCacheTimestampsXorSizes.put(u, footprint);
    }

    private static String getCrc32(InputStream is, FileObject fo) throws IOException {
        URL u = fo.toURL();
        fo.refresh();
        long footprint = fo.lastModified().getTime() ^ fo.getSize();
        String crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        if (crc == null) {
            crc = GeneratedFilesHelper.computeCrc32(is);
            GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
        }
        return crc;
    }

    private static long checkFootprint(URL u) {
        File f = FileUtil.archiveOrDirForURL((URL)u);
        if (f != null) {
            return f.lastModified() ^ f.length();
        }
        return 0L;
    }

    private static String getCrc32(InputStream is, URL u) throws IOException {
        long footprint = GeneratedFilesHelper.checkFootprint(u);
        String crc = null;
        if (footprint != 0L) {
            crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        }
        if (crc == null) {
            crc = GeneratedFilesHelper.computeCrc32(is);
            if (footprint != 0L) {
                GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
            }
        }
        return crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(FileObject fo) throws IOException {
        URL u = fo.toURL();
        fo.refresh();
        long footprint = fo.lastModified().getTime() ^ fo.getSize();
        String crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        if (crc == null) {
            try (InputStream is = fo.getInputStream();){
                crc = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(is));
                GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
            }
        }
        return crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(URL u) throws IOException {
        long footprint = GeneratedFilesHelper.checkFootprint(u);
        String crc = null;
        if (footprint != 0L) {
            crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        }
        if (crc == null) {
            try (InputStream is = u.openStream();){
                crc = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(is));
                if (footprint != 0L) {
                    GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
                }
            }
        }
        return crc;
    }

    public boolean refreshBuildScript(final String path, final URL stylesheet, final boolean checkForProjectXmlModified) throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    int flags = GeneratedFilesHelper.this.getBuildScriptState(path, stylesheet);
                    if (GeneratedFilesHelper.shouldGenerateBuildScript(flags, checkForProjectXmlModified)) {
                        GeneratedFilesHelper.this.generateBuildScriptFromStylesheet(path, stylesheet);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static void callInterceptors(@NonNull FileObject dir, @NonNull String path) {
        Project prj = FileOwnerQuery.getOwner((FileObject)dir);
        if (prj != null) {
            Collection interceptors = prj.getLookup().lookupAll(GeneratedFilesInterceptor.class);
            for (GeneratedFilesInterceptor interceptor : interceptors) {
                interceptor.fileGenerated(prj, path);
            }
        }
    }

    private static boolean shouldGenerateBuildScript(int flags, boolean checkForProjectXmlModified) {
        if ((flags & 2) != 0) {
            return true;
        }
        if ((flags & 4) != 0) {
            return false;
        }
        if (!checkForProjectXmlModified) {
            return true;
        }
        return (flags & 0x18) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized SpecificationVersion stylesheetVersion(URL stylesheet) {
        if (STYLESHEET_VERSIONS.containsKey(stylesheet)) {
            return STYLESHEET_VERSIONS.get(stylesheet);
        }
        String stylesheetS = stylesheet.toString();
        int idx = stylesheetS.indexOf("!/");
        if (idx != -1) {
            try (InputStream is = new URL(stylesheetS.substring(0, idx + 2) + "META-INF/MANIFEST.MF").openStream();){
                Manifest m = new Manifest(is);
                String v = m.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                if (v != null) {
                    SpecificationVersion sv = new SpecificationVersion(v);
                    STYLESHEET_VERSIONS.put(stylesheet, sv);
                    SpecificationVersion specificationVersion = sv;
                    return specificationVersion;
                }
            }
            catch (Exception x) {
                Logger.getLogger(GeneratedFilesHelper.class.getName()).log(Level.FINE, "Failed to determine spec version for " + stylesheet, x);
            }
        }
        STYLESHEET_VERSIONS.put(stylesheet, null);
        return null;
    }

    private static class EolFilterOutputStream
    extends BufferedOutputStream {
        private boolean isActive = BaseUtilities.isWindows();
        private int last = -1;

        public EolFilterOutputStream(OutputStream os) {
            super(os, 4096);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.isActive) {
                for (int i = off; i < off + len; ++i) {
                    this.write(b[i]);
                }
            } else {
                super.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isActive) {
                if (b == 10 && this.last != 13) {
                    super.write(13);
                }
                this.last = b;
            }
            super.write(b);
        }
    }
}

