/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.fish.payara.micro.project.ReloadAction;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.j2ee.execution.ExecutionChecker;

public class MicroExecutionChecker
extends ExecutionChecker {
    private static final String COMMAND_BUILD_WITH_DEPENDENCIES = "build-with-dependencies";
    private static final Set<String> BUILD_ACTIONS = new HashSet<String>(Arrays.asList("clean", "build", "rebuild", "build-with-dependencies", "micro-complie-explode", "micro-explode"));
    private static final Set<String> RUN_ACTIONS = new HashSet<String>(Arrays.asList("run", "debug", "profile", "run.single.deploy", "debug.single.deploy", "profile.single.deploy"));

    public MicroExecutionChecker(Project project) {
        super(project);
    }

    public boolean checkRunConfig(RunConfig config) {
        Project project = config.getProject();
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication != null) {
            if (BUILD_ACTIONS.contains(config.getActionName())) {
                microApplication.setBuilding(true, config.getActionName());
            } else if (RUN_ACTIONS.contains(config.getActionName())) {
                microApplication.setRunning(true, config.getActionName());
            }
            return true;
        }
        return super.checkRunConfig(config);
    }

    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        Project project = config.getProject();
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication != null) {
            if (BUILD_ACTIONS.contains(config.getActionName())) {
                if (config.getActionName().contains("build") || config.getActionName().contains("explode")) {
                    MicroExecutionChecker.reloadApplication(microApplication);
                }
                microApplication.setBuilding(false);
            } else if (RUN_ACTIONS.contains(config.getActionName())) {
                microApplication.setRunning(false);
            }
        } else {
            super.executionResult(config, res, resultCode);
        }
    }

    public static void reloadApplication(MicroApplication application) {
        if (!application.isRunning()) {
            return;
        }
        String buildPath = application.getMavenProject().getBuild().getDirectory() + File.separator + application.getMavenProject().getBuild().getFinalName();
        ReloadAction.reloadApplication(buildPath);
    }
}

